/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.dao.property;

import com.arun.bhardwaj.dao.property.PropertyOnRentDao;
import com.arun.bhardwaj.model.property.DepositTrackerDetails;
import com.arun.bhardwaj.model.property.PaymentTrackerDetails;
import com.arun.bhardwaj.model.property.PropertyOnRentDetails;
import com.arun.bhardwaj.model.property.PropertyStatus;
import com.arun.bhardwaj.model.property.PropertyTerminationDetails;
import com.arun.bhardwaj.model.property.RentDetails;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.utility.DbUtility;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;

public class PropertyOnRentDaoImpl
implements PropertyOnRentDao {
    private static final String SAVE_ON_RENT_DETAILS = "INSERT INTO PROPERTY_ON_RENT (START_DATE, DEPOSIT,RENT,FK_OWNER_CONTACT_ID,\n                                 FK_TENANT_CONTACT_ID,FK_RENTED_BY_CONTACT_ID,TENURE_IN_MONTHS,\n                                 END_DATE, BROKERAGE, PROPERTY_RENT_BY,FK_PROPERTY_STATUS_ID,CREATED_ON\n                             )values(?,?,?,?,?,?,?,?,?,?,?,?)\n";
    private static final String UPDATE_ON_RENT_DETAILS = "UPDATE  PROPERTY_ON_RENT SET START_DATE = ?, DEPOSIT =? ,RENT=? , FK_OWNER_CONTACT_ID=?,\n FK_TENANT_CONTACT_ID=? ,FK_RENTED_BY_CONTACT_ID=? ,TENURE_IN_MONTHS=?,\n END_DATE =?, BROKERAGE =?, PROPERTY_RENT_BY=?,MODIFY_ON=?\n WHERE PROPERTY_ON_RENT_ID=?\n";
    private static final String INSERT_STATUS = "INSERT INTO PROPERTY_STATUS ( PROPERTY_STATUS,  FK_PROPERTY_ID,CREATED_ON) VALUES (?,?,?)";
    private static final String UPDATE_TERMINATION_REASON = "UPDATE PROPERTY_ON_RENT SET TERMINATION_REASON =? , TERMINATION_DATE =? WHERE PROPERTY_ON_RENT_ID =?";
    private static final String SAVE_PAYMENT_DETAILS = "INSERT INTO PAYMENT_TRACKER (PAYMENT_DATE ,MONTH, MODE_OF_PAYMENT, PAYMENT_REFERENCE_NO,PAYMENT_AMOUNT,CREATED_ON,FK_PROPERTY_ON_RENT_ID,COMMENTS)\nvalues(?,?,?,?,?,?,?,?)\n";
    private static final String LOAD_PAYMENT_DETAILS = "SELECT PAYMENT_DATE, MONTH, MODE_OF_PAYMENT, PAYMENT_REFERENCE_NO,PAYMENT_AMOUNT,CREATED_ON, MODIFY_ON, PAYMENT_TRACKER_ID, COMMENTS FROM PAYMENT_TRACKER\nwhere FK_PROPERTY_ON_RENT_ID =?\n";
    private static final String UPDATE_PAYMENT_DETAILS = "UPDATE PAYMENT_TRACKER SET MONTH=?, MODE_OF_PAYMENT=?, PAYMENT_REFERENCE_NO=?,PAYMENT_AMOUNT=?, MODIFY_ON=? ,PAYMENT_DATE=?, COMMENTS=? WHERE PAYMENT_TRACKER_ID=?\n";
    private static final String DELETE_PAYMENT_DETAILS = "DELETE FROM PAYMENT_TRACKER WHERE PAYMENT_TRACKER_ID=?\n";
    private static final String UPDATE_DEPOSIT_RENT = "UPDATE PROPERTY_RECORDS SET DEPOSIT=? , RENT=? where PROPERTY_ID=?";
    private static final String SAVE_DEPOSIT_DETAILS = "INSERT INTO DEPOSIT_TRACKER (PAYMENT_DATE,MODE_OF_PAYMENT, PAYMENT_REFERENCE_NO, PAYMENT_AMOUNT,\n                                COMMENTS, CREATED_ON, FK_PROPERTY_ON_RENT_ID , PAID_BY\n                            )\n                            VALUES (?,?,?,?,?,?,?,?)\n";
    private static final String LOAD_DEPOSIT_DETAILS = "SELECT PAYMENT_DATE, MODE_OF_PAYMENT, PAYMENT_REFERENCE_NO,PAYMENT_AMOUNT, DEPOSIT_ID, COMMENTS FROM DEPOSIT_TRACKER\nwhere FK_PROPERTY_ON_RENT_ID =? and PAID_BY =?\n";
    private static final String DELETE_DEPOSIT_DETAILS = "DELETE FROM DEPOSIT_TRACKER WHERE DEPOSIT_ID=?\n";
    private static final String UPDATE_DEPOSIT_DETAILS = "UPDATE DEPOSIT_TRACKER SET  MODE_OF_PAYMENT=?, PAYMENT_REFERENCE_NO=?,PAYMENT_AMOUNT=?, MODIFY_ON=? ,PAYMENT_DATE=?, COMMENTS=? WHERE DEPOSIT_ID=?\n";
    private static final String INSERT_RENT_CONDITIONS = "    INSERT INTO RENT_CONDITIONS ( START_MONTH, END_MONTH, RENT, RENT_REVISED_IN_MONTHS, FK_PROPERTY_STATUS_ID )\n    VALUES (?,?,?,?,?)\n";
    private static final String DELETE_RENT_CONDITION = "DELETE FROM RENT_CONDITIONS WHERE FK_PROPERTY_STATUS_ID =?";
    private static final String UPDATE_RENT_CONDITIONS = "    UPDATE RENT_CONDITIONS SET RENT =? where RENT_CONDITIONS_ID =?\n";
    private static final String FETCH_STATUS_ID_BY_PROPERTY_ON_RENT_ID = "select FK_PROPERTY_STATUS_ID from PROPERTY_ON_RENT where PROPERTY_ON_RENT_ID =?";

    @Override
    public void saveOnRentDetails(PropertyOnRentDetails propertyOnRentDetails) throws Exception {
        try (Connection con = DbUtility.getConnection();){
            con.setAutoCommit(false);
            try (PreparedStatement psStatus = con.prepareStatement(INSERT_STATUS, 1);){
                PreparedStatement preparedStatement;
                psStatus.setInt(1, PropertyStatus.ON_RENT.ordinal());
                psStatus.setInt(2, propertyOnRentDetails.propertyId());
                psStatus.setString(3, propertyOnRentDetails.startDate());
                psStatus.executeUpdate();
                int statusId = psStatus.getGeneratedKeys().getInt(1);
                try (PreparedStatement ps = con.prepareStatement(SAVE_ON_RENT_DETAILS, 1);){
                    ps.setString(1, propertyOnRentDetails.startDate());
                    ps.setInt(2, propertyOnRentDetails.deposit());
                    ps.setInt(3, propertyOnRentDetails.rent());
                    ps.setInt(4, propertyOnRentDetails.ownerContactId());
                    ps.setInt(5, propertyOnRentDetails.tenantContactId());
                    ps.setInt(6, propertyOnRentDetails.rentedByContactId());
                    ps.setInt(7, propertyOnRentDetails.tenureIntMonths());
                    ps.setString(8, propertyOnRentDetails.endDate());
                    ps.setInt(9, propertyOnRentDetails.brokerage());
                    ps.setInt(10, propertyOnRentDetails.rentedBy());
                    ps.setInt(11, statusId);
                    ps.setString(12, AppUtility.getCurrentDateInString());
                    ps.executeUpdate();
                }
                catch (Exception e) {
                    con.rollback();
                    throw new RuntimeException(e.getMessage());
                }
                List<RentDetails> rentDetailsList = propertyOnRentDetails.rentDetails();
                if (!rentDetailsList.isEmpty()) {
                    try {
                        preparedStatement = con.prepareStatement(INSERT_RENT_CONDITIONS);
                        try {
                            for (RentDetails rentDetails : rentDetailsList) {
                                preparedStatement.setString(1, rentDetails.startMonth());
                                preparedStatement.setString(2, rentDetails.endMonth());
                                preparedStatement.setInt(3, rentDetails.rentAmount());
                                preparedStatement.setString(4, rentDetails.rentRevisedInMonths());
                                preparedStatement.setInt(5, statusId);
                                preparedStatement.addBatch();
                            }
                            preparedStatement.executeBatch();
                        }
                        finally {
                            if (preparedStatement != null) {
                                preparedStatement.close();
                            }
                        }
                    }
                    catch (Exception e) {
                        con.rollback();
                        throw new RuntimeException(e.getMessage());
                    }
                }
                try {
                    preparedStatement = con.prepareStatement(UPDATE_DEPOSIT_RENT);
                    try {
                        preparedStatement.setInt(1, propertyOnRentDetails.deposit());
                        preparedStatement.setInt(2, propertyOnRentDetails.rent());
                        preparedStatement.setInt(3, propertyOnRentDetails.propertyId());
                        preparedStatement.executeUpdate();
                        con.commit();
                    }
                    finally {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                }
                catch (Exception e) {
                    con.rollback();
                    throw new RuntimeException(e.getMessage());
                }
            }
            catch (Exception ex) {
                con.rollback();
                throw new RuntimeException(ex.getMessage());
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    @Override
    public void updateOnRentDetails(PropertyOnRentDetails propertyOnRentDetails) throws Exception {
        try (Connection con = DbUtility.getConnection();){
            PreparedStatement preparedStatement;
            List<RentDetails> updateRentDetailsList;
            con.setAutoCommit(false);
            try (PreparedStatement ps = con.prepareStatement(UPDATE_ON_RENT_DETAILS);){
                ps.setString(1, propertyOnRentDetails.startDate());
                ps.setInt(2, propertyOnRentDetails.deposit());
                ps.setInt(3, propertyOnRentDetails.rent());
                ps.setInt(4, propertyOnRentDetails.ownerContactId());
                ps.setInt(5, propertyOnRentDetails.tenantContactId());
                ps.setInt(6, propertyOnRentDetails.rentedByContactId());
                ps.setInt(7, propertyOnRentDetails.tenureIntMonths());
                ps.setString(8, propertyOnRentDetails.endDate());
                ps.setInt(9, propertyOnRentDetails.brokerage());
                ps.setInt(10, propertyOnRentDetails.rentedBy());
                ps.setString(11, AppUtility.getCurrentDateInString());
                ps.setInt(12, propertyOnRentDetails.propertyOnRentId());
                ps.executeUpdate();
            }
            catch (Exception e) {
                con.rollback();
                throw new RuntimeException(e.getMessage());
            }
            List<RentDetails> rentDetailsList = propertyOnRentDetails.rentDetails();
            List<RentDetails> saveRentDetailsList = rentDetailsList.stream().filter(rentDetails -> rentDetails.rentConditionId() == 0).toList();
            if (!saveRentDetailsList.isEmpty()) {
                PreparedStatement preparedStatement2;
                try {
                    preparedStatement2 = con.prepareStatement(DELETE_RENT_CONDITION);
                    try {
                        preparedStatement2.setInt(1, this.fetchStatusIdByRentId(propertyOnRentDetails.propertyOnRentId(), con));
                        preparedStatement2.executeUpdate();
                    }
                    finally {
                        if (preparedStatement2 != null) {
                            preparedStatement2.close();
                        }
                    }
                }
                catch (Exception e) {
                    con.rollback();
                    throw new RuntimeException(e.getMessage());
                }
                try {
                    preparedStatement2 = con.prepareStatement(INSERT_RENT_CONDITIONS);
                    try {
                        for (RentDetails rentDetails2 : saveRentDetailsList) {
                            preparedStatement2.setString(1, rentDetails2.startMonth());
                            preparedStatement2.setString(2, rentDetails2.endMonth());
                            preparedStatement2.setInt(3, rentDetails2.rentAmount());
                            preparedStatement2.setString(4, rentDetails2.rentRevisedInMonths());
                            preparedStatement2.setInt(5, this.fetchStatusIdByRentId(propertyOnRentDetails.propertyOnRentId(), con));
                            preparedStatement2.addBatch();
                        }
                        preparedStatement2.executeBatch();
                    }
                    finally {
                        if (preparedStatement2 != null) {
                            preparedStatement2.close();
                        }
                    }
                }
                catch (Exception e) {
                    con.rollback();
                    throw new RuntimeException(e.getMessage());
                }
            }
            if (!(updateRentDetailsList = rentDetailsList.stream().filter(rentDetails -> rentDetails.rentConditionId() > 0).toList()).isEmpty()) {
                try {
                    preparedStatement = con.prepareStatement(UPDATE_RENT_CONDITIONS);
                    try {
                        for (RentDetails rentDetails3 : updateRentDetailsList) {
                            preparedStatement.setInt(1, rentDetails3.rentAmount());
                            preparedStatement.setInt(2, rentDetails3.rentConditionId());
                            preparedStatement.addBatch();
                        }
                        preparedStatement.executeBatch();
                    }
                    finally {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                }
                catch (Exception e) {
                    con.rollback();
                    throw new RuntimeException(e.getMessage());
                }
            }
            try {
                preparedStatement = con.prepareStatement(UPDATE_DEPOSIT_RENT);
                try {
                    preparedStatement.setInt(1, propertyOnRentDetails.deposit());
                    preparedStatement.setInt(2, propertyOnRentDetails.rent());
                    preparedStatement.setInt(3, propertyOnRentDetails.propertyId());
                    preparedStatement.executeUpdate();
                    con.commit();
                }
                finally {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
            }
            catch (Exception e) {
                con.rollback();
                throw new RuntimeException(e.getMessage());
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int fetchStatusIdByRentId(int rentId, Connection conn) throws Exception {
        try (PreparedStatement ps = conn.prepareStatement(FETCH_STATUS_ID_BY_PROPERTY_ON_RENT_ID);){
            ps.setInt(1, rentId);
            try (ResultSet res = ps.executeQuery();){
                if (!res.next()) return 0;
                int n = res.getInt("FK_PROPERTY_STATUS_ID");
                return n;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public void terminateRecord(PropertyTerminationDetails propertyTerminationDetails) throws Exception {
        try (Connection con = DbUtility.getConnection();){
            con.setAutoCommit(false);
            Optional<PropertyStatus> propertyStatus = Arrays.stream(PropertyStatus.values()).filter(propStatus -> propStatus.name().equals(propertyTerminationDetails.newPropStatus())).findAny();
            try (PreparedStatement psStatus = con.prepareStatement(INSERT_STATUS, 1);){
                PreparedStatement ps;
                psStatus.setInt(1, propertyStatus.get().ordinal());
                psStatus.setInt(2, propertyTerminationDetails.propertyId());
                psStatus.setString(3, propertyTerminationDetails.terminationDate());
                psStatus.executeUpdate();
                try {
                    ps = con.prepareStatement(SAVE_DEPOSIT_DETAILS);
                    try {
                        ps.setString(1, propertyTerminationDetails.depositTrackerDetails().paymentDate());
                        ps.setInt(2, propertyTerminationDetails.depositTrackerDetails().modeOfPayment());
                        ps.setString(3, propertyTerminationDetails.depositTrackerDetails().paymentReference());
                        ps.setInt(4, propertyTerminationDetails.depositTrackerDetails().amount());
                        ps.setString(5, propertyTerminationDetails.depositTrackerDetails().comments());
                        ps.setString(6, AppUtility.getCurrentDateInString());
                        ps.setInt(7, propertyTerminationDetails.depositTrackerDetails().propertyOnRentId());
                        ps.setString(8, propertyTerminationDetails.depositTrackerDetails().paidBy());
                        ps.executeUpdate();
                    }
                    finally {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                }
                catch (Exception e) {
                    con.rollback();
                    throw new RuntimeException(e.getMessage());
                }
                try {
                    ps = con.prepareStatement(UPDATE_TERMINATION_REASON);
                    try {
                        ps.setString(1, propertyTerminationDetails.reason());
                        ps.setString(2, propertyTerminationDetails.terminationDate());
                        ps.setInt(3, propertyTerminationDetails.propertyOnRentId());
                        ps.executeUpdate();
                        con.commit();
                    }
                    finally {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
            catch (Exception ex) {
                con.rollback();
                throw new RuntimeException(ex.getMessage());
            }
        }
    }

    @Override
    public void savePaymentDetails(PaymentTrackerDetails paymentTrackerDetails) throws Exception {
        try (Connection con = DbUtility.getConnection();
             PreparedStatement ps = con.prepareStatement(SAVE_PAYMENT_DETAILS);){
            ps.setString(1, paymentTrackerDetails.paymentDate());
            ps.setString(2, paymentTrackerDetails.monthYear());
            ps.setInt(3, paymentTrackerDetails.modeOfPayment());
            ps.setString(4, paymentTrackerDetails.paymentReference());
            ps.setInt(5, paymentTrackerDetails.amount());
            ps.setString(6, AppUtility.getCurrentDateInString());
            ps.setInt(7, paymentTrackerDetails.propertyOnRentId());
            ps.setString(8, paymentTrackerDetails.comments());
            ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public void updatePaymentDetails(PaymentTrackerDetails paymentTrackerDetails) throws Exception {
        try (Connection con = DbUtility.getConnection();
             PreparedStatement ps = con.prepareStatement(UPDATE_PAYMENT_DETAILS);){
            ps.setString(1, paymentTrackerDetails.monthYear());
            ps.setInt(2, paymentTrackerDetails.modeOfPayment());
            ps.setString(3, paymentTrackerDetails.paymentReference());
            ps.setInt(4, paymentTrackerDetails.amount());
            ps.setString(5, AppUtility.getCurrentDateInString());
            ps.setString(6, paymentTrackerDetails.paymentDate());
            ps.setString(7, paymentTrackerDetails.comments());
            ps.setInt(8, paymentTrackerDetails.paymentTrackerId());
            ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public void deletePaymentDetails(int paymentTrackerId) throws Exception {
        try (Connection con = DbUtility.getConnection();
             PreparedStatement ps = con.prepareStatement(DELETE_PAYMENT_DETAILS);){
            ps.setInt(1, paymentTrackerId);
            ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<PaymentTrackerDetails> loadPaymentDetails(int propertyOnRentId) throws Exception {
        ArrayList<PaymentTrackerDetails> data = new ArrayList<PaymentTrackerDetails>();
        try (Connection con = DbUtility.getConnection();){
            ArrayList<PaymentTrackerDetails> arrayList;
            block22: {
                PreparedStatement ps = con.prepareStatement(LOAD_PAYMENT_DETAILS);
                try {
                    ps.setInt(1, propertyOnRentId);
                    try (ResultSet rs = ps.executeQuery();){
                        while (rs.next()) {
                            data.add(new PaymentTrackerDetails(rs.getString("PAYMENT_DATE"), rs.getString("MONTH"), rs.getInt("MODE_OF_PAYMENT"), rs.getString("PAYMENT_REFERENCE_NO"), rs.getInt("PAYMENT_AMOUNT"), rs.getInt("PAYMENT_TRACKER_ID"), 0, rs.getString("CREATED_ON"), rs.getString("MODIFY_ON"), rs.getString("COMMENTS"), AppUtility.convertStringToDate(rs.getString("PAYMENT_DATE"))));
                        }
                    }
                    Collections.sort(data, Comparator.comparing(PaymentTrackerDetails::localDate).reversed());
                    arrayList = data;
                    if (ps == null) break block22;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return arrayList;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public void saveDepositDetails(DepositTrackerDetails depositTrackerDetails) throws Exception {
        try (Connection con = DbUtility.getConnection();
             PreparedStatement ps = con.prepareStatement(SAVE_DEPOSIT_DETAILS);){
            ps.setString(1, depositTrackerDetails.paymentDate());
            ps.setInt(2, depositTrackerDetails.modeOfPayment());
            ps.setString(3, depositTrackerDetails.paymentReference());
            ps.setInt(4, depositTrackerDetails.amount());
            ps.setString(5, depositTrackerDetails.comments());
            ps.setString(6, AppUtility.getCurrentDateInString());
            ps.setInt(7, depositTrackerDetails.propertyOnRentId());
            ps.setString(8, depositTrackerDetails.paidBy());
            ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<DepositTrackerDetails> loadDepositDetails(int propertyOnRentId, String paidBy) throws Exception {
        ArrayList<DepositTrackerDetails> data = new ArrayList<DepositTrackerDetails>();
        try (Connection con = DbUtility.getConnection();){
            ArrayList<DepositTrackerDetails> arrayList;
            block22: {
                PreparedStatement ps = con.prepareStatement(LOAD_DEPOSIT_DETAILS);
                try {
                    ps.setInt(1, propertyOnRentId);
                    ps.setString(2, paidBy);
                    try (ResultSet rs = ps.executeQuery();){
                        while (rs.next()) {
                            data.add(new DepositTrackerDetails(rs.getString("PAYMENT_DATE"), rs.getInt("MODE_OF_PAYMENT"), rs.getString("PAYMENT_REFERENCE_NO"), rs.getInt("PAYMENT_AMOUNT"), rs.getInt("DEPOSIT_ID"), propertyOnRentId, rs.getString("COMMENTS"), AppUtility.convertStringToDate(rs.getString("PAYMENT_DATE")), null));
                        }
                    }
                    Collections.sort(data, Comparator.comparing(DepositTrackerDetails::localDate).reversed());
                    arrayList = data;
                    if (ps == null) break block22;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return arrayList;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public void deleteDepositDetails(int depositId) throws Exception {
        try (Connection con = DbUtility.getConnection();
             PreparedStatement ps = con.prepareStatement(DELETE_DEPOSIT_DETAILS);){
            ps.setInt(1, depositId);
            ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public void updateDepositDetails(DepositTrackerDetails depositTrackerDetails) throws Exception {
        try (Connection con = DbUtility.getConnection();
             PreparedStatement ps = con.prepareStatement(UPDATE_DEPOSIT_DETAILS);){
            ps.setInt(1, depositTrackerDetails.modeOfPayment());
            ps.setString(2, depositTrackerDetails.paymentReference());
            ps.setInt(3, depositTrackerDetails.amount());
            ps.setString(4, AppUtility.getCurrentDateInString());
            ps.setString(5, depositTrackerDetails.paymentDate());
            ps.setString(6, depositTrackerDetails.comments());
            ps.setInt(7, depositTrackerDetails.depositTrackerId());
            ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

