/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.dao.property;

import com.arun.bhardwaj.dao.property.PropertyRecordDao;
import com.arun.bhardwaj.exceptions.DatabaseException;
import com.arun.bhardwaj.model.property.PropertyAdditionalDetails;
import com.arun.bhardwaj.model.property.PropertyRecord;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.utility.DbUtility;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class PropertyRecordDaoImpl
implements PropertyRecordDao {
    private static final String INSERT_RECORD = "INSERT INTO PROPERTY_RECORDS(DATE,ADDRESS,LOCATION,CITY,PIN,DEPOSIT,RENT,PRICE,AREA_IN_SQFT,OFFERED_BY_TYPE,\nFURNISHING_STATUS,COMMENTS,FK_GROUP_ID,FK_CONTACT_ID,CREATED_ON,UNAVAILABLE_UNTIL)\nvalues(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)\n";
    private static final String UPDATE_RECORD = "UPDATE PROPERTY_RECORDS SET  ADDRESS =? ,LOCATION=?,CITY=?,PIN=?,DEPOSIT=?,RENT=?,PRICE=?, AREA_IN_SQFT=?, OFFERED_BY_TYPE=?,\nFURNISHING_STATUS=?,COMMENTS=?, FK_GROUP_ID=?,FK_CONTACT_ID =? ,\nMODIFY_ON= ?, DATE =? ,UNAVAILABLE_UNTIL=?\nWHERE PROPERTY_ID=?\n";
    private static final String DELETE_RECORD = "DELETE FROM PROPERTY_RECORDS where PROPERTY_ID in(\n";
    private static final String INSERT_STATUS = "INSERT INTO PROPERTY_STATUS(PROPERTY_STATUS,  FK_PROPERTY_ID, CREATED_ON) VALUES (?,?,?)";
    private static final String FETCH_LATEST_PROPERTY_STATUS = "Select PROPERTY_STATUS from PROPERTY_STATUS where PROPERTY_STATUS_ID=(Select max(PROPERTY_STATUS_ID) from PROPERTY_STATUS where FK_PROPERTY_ID = ?)";
    private static final String INSERT_ADDITIONAL_DETAILS = "INSERT INTO PROPERTY_ADDITIONAL_DETAILS (NAME,VALUE,FK_PROPERTY_ID,CREATED_ON) VALUES (?,?,?,?)";
    private static final String DELETE_ADDITIONAL_DETAILS = "DELETE FROM PROPERTY_ADDITIONAL_DETAILS WHERE ADDITIONAL_ID=? and FK_PROPERTY_ID =?";
    private static final String LOAD_ADDITIONAL_DETAILS = "SELECT ADDITIONAL_ID, NAME, VALUE FROM PROPERTY_ADDITIONAL_DETAILS WHERE FK_PROPERTY_ID =? order by NAME asc ";

    @Override
    public int saveLeaseRecord(PropertyRecord record) throws DatabaseException {
        int propertyId = 0;
        try (Connection con = DbUtility.getConnection();){
            con.setAutoCommit(false);
            try (PreparedStatement ps = con.prepareStatement(INSERT_RECORD, 1);){
                ps.setString(1, record.date());
                ps.setString(2, record.address());
                ps.setString(3, record.location());
                ps.setString(4, record.city());
                ps.setString(5, record.pin());
                ps.setInt(6, record.deposit());
                ps.setInt(7, record.rent());
                ps.setInt(8, record.price());
                ps.setInt(9, record.areaInSqFt());
                ps.setInt(10, record.offeredByType());
                ps.setInt(11, record.furnishingStatus());
                ps.setString(12, record.comments());
                ps.setInt(13, record.fkGroupId());
                ps.setInt(14, record.fkContactId());
                ps.setString(15, AppUtility.getCurrentDateInString());
                ps.setString(16, record.unAvailableUntil());
                ps.executeUpdate();
                propertyId = ps.getGeneratedKeys().getInt(1);
                try (PreparedStatement psStatus = con.prepareStatement(INSERT_STATUS);){
                    psStatus.setInt(1, record.propertyStatus());
                    psStatus.setInt(2, propertyId);
                    psStatus.setString(3, record.date());
                    psStatus.executeUpdate();
                    con.commit();
                }
                catch (Exception ex) {
                    con.rollback();
                    throw new RuntimeException(ex.getMessage());
                }
            }
            catch (SQLException e) {
                con.rollback();
                throw new DatabaseException(e.getMessage(), e);
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        return propertyId;
    }

    @Override
    public void updateLeaseRecord(PropertyRecord record) throws DatabaseException {
        block25: {
            try (Connection con = DbUtility.getConnection();){
                con.setAutoCommit(false);
                try (PreparedStatement ps = con.prepareStatement(UPDATE_RECORD);){
                    ps.setString(1, record.address());
                    ps.setString(2, record.location());
                    ps.setString(3, record.city());
                    ps.setString(4, record.pin());
                    ps.setInt(5, record.deposit());
                    ps.setInt(6, record.rent());
                    ps.setInt(7, record.price());
                    ps.setInt(8, record.areaInSqFt());
                    ps.setInt(9, record.offeredByType());
                    ps.setInt(10, record.furnishingStatus());
                    ps.setString(11, record.comments());
                    ps.setInt(12, record.fkGroupId());
                    ps.setInt(13, record.fkContactId());
                    ps.setString(14, AppUtility.getCurrentDateInString());
                    ps.setString(15, record.date());
                    ps.setString(16, record.unAvailableUntil());
                    ps.setInt(17, record.leaseId());
                    ps.executeUpdate();
                    Integer currentPropertyStatus = this.fetchCurrentPropertyStatus(record.leaseId(), con);
                    if (currentPropertyStatus != -1 && currentPropertyStatus != record.propertyStatus()) {
                        try (PreparedStatement psStatus = con.prepareStatement(INSERT_STATUS);){
                            psStatus.setInt(1, record.propertyStatus());
                            psStatus.setInt(2, record.leaseId());
                            psStatus.setString(3, record.date());
                            psStatus.executeUpdate();
                            con.commit();
                            break block25;
                        }
                        catch (SQLException ex) {
                            con.rollback();
                            throw new DatabaseException(ex.getMessage(), ex);
                        }
                    }
                    con.commit();
                }
                catch (SQLException e) {
                    throw new DatabaseException(e.getMessage(), e);
                }
            }
            catch (SQLException ex) {
                throw new DatabaseException(ex.getMessage(), ex);
            }
        }
    }

    private Integer fetchCurrentPropertyStatus(Integer propertyId, Connection conn) throws DatabaseException {
        Integer propertyStatus = -1;
        try (PreparedStatement ps = conn.prepareStatement(FETCH_LATEST_PROPERTY_STATUS);){
            ps.setInt(1, propertyId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    propertyStatus = rs.getInt("PROPERTY_STATUS");
                }
            }
        }
        catch (SQLException ex) {
            throw new DatabaseException(ex.getMessage(), ex);
        }
        return propertyStatus;
    }

    @Override
    public void deleteLeaseRecord(List<Integer> leaseIds) throws DatabaseException {
        if (leaseIds != null || !leaseIds.isEmpty()) {
            StringBuilder queryBuilder = new StringBuilder(DELETE_RECORD);
            for (int i = 0; i < leaseIds.size(); ++i) {
                queryBuilder.append("?");
                if (i >= leaseIds.size() - 1) continue;
                queryBuilder.append(",");
            }
            queryBuilder.append(")");
            try (Connection con = DbUtility.getConnection();
                 PreparedStatement ps = con.prepareStatement(queryBuilder.toString());){
                for (int i = 0; i < leaseIds.size(); ++i) {
                    ps.setInt(i + 1, leaseIds.get(i));
                }
                ps.executeUpdate();
            }
            catch (SQLException e) {
                throw new DatabaseException(e.getMessage(), e);
            }
        }
    }

    @Override
    public List<PropertyAdditionalDetails> loadAllAdditionalDetails(int leaseId) throws DatabaseException {
        ArrayList<PropertyAdditionalDetails> propertyAdditionalDetails = new ArrayList<PropertyAdditionalDetails>();
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(LOAD_ADDITIONAL_DETAILS);){
            ps.setInt(1, leaseId);
            try (ResultSet result = ps.executeQuery();){
                while (result.next()) {
                    propertyAdditionalDetails.add(new PropertyAdditionalDetails(result.getInt("ADDITIONAL_ID"), result.getString("NAME"), result.getString("VALUE"), leaseId));
                }
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        return propertyAdditionalDetails;
    }

    @Override
    public void addAdditionalDetails(PropertyAdditionalDetails propertyAdditionalDetails) throws DatabaseException {
        try (Connection con = DbUtility.getConnection();
             PreparedStatement ps = con.prepareStatement(INSERT_ADDITIONAL_DETAILS);){
            ps.setString(1, propertyAdditionalDetails.name());
            ps.setString(2, propertyAdditionalDetails.value());
            ps.setInt(3, propertyAdditionalDetails.fkPropertyId());
            ps.setString(4, AppUtility.getCurrentDateInString());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
    }

    @Override
    public void deleteAdditionalDetails(PropertyAdditionalDetails propertyAdditionalDetails) throws DatabaseException {
        try (Connection con = DbUtility.getConnection();
             PreparedStatement ps = con.prepareStatement(DELETE_ADDITIONAL_DETAILS);){
            ps.setInt(1, propertyAdditionalDetails.additionalId());
            ps.setInt(2, propertyAdditionalDetails.fkPropertyId());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
    }
}

