/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.dao.property;

import com.arun.bhardwaj.dao.property.PropertySellDetailsDao;
import com.arun.bhardwaj.model.property.PropertySellDetails;
import com.arun.bhardwaj.model.property.PropertyStatus;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.utility.DbUtility;
import java.sql.Connection;
import java.sql.PreparedStatement;

public class PropertySellDetailsDaoImpl
implements PropertySellDetailsDao {
    private static final String SAVE_RECORD = "INSERT INTO PROPERTY_SELL_DETAILS (CONTRACT_DATE, PRICE, FK_BUYER_ID, FK_SELLER_ID,\n                                      FK_SELL_BY_CONTACT_ID,BROKERAGE,\n                                      CREATED_ON, PROPERTY_SELL_BY,FK_PROPERTY_STATUS_ID\n                                  )\n                                  VALUES (?,?,?,?,?,?,?,?,?);\n";
    private static final String INSERT_STATUS = "INSERT INTO PROPERTY_STATUS ( PROPERTY_STATUS,  FK_PROPERTY_ID,CREATED_ON) VALUES (?,?,?)";
    private static final String UPDATE_PROPERTY_OWNER_AND_PRICE = "UPDATE PROPERTY_RECORDS SET FK_CONTACT_ID=? , PRICE=? WHERE PROPERTY_ID=? ";

    @Override
    public void saveRecord(PropertySellDetails propertySaleDetails) throws Exception {
        try (Connection con = DbUtility.getConnection();){
            con.setAutoCommit(false);
            try (PreparedStatement psStatus = con.prepareStatement(INSERT_STATUS, 1);){
                psStatus.setInt(1, PropertyStatus.SOLD.ordinal());
                psStatus.setInt(2, propertySaleDetails.propertyId());
                psStatus.setString(3, propertySaleDetails.date());
                psStatus.executeUpdate();
                Integer statusId = psStatus.getGeneratedKeys().getInt(1);
                try (PreparedStatement ps = con.prepareStatement(SAVE_RECORD);){
                    ps.setString(1, propertySaleDetails.date());
                    ps.setInt(2, propertySaleDetails.amount());
                    ps.setInt(3, propertySaleDetails.buyerContactId());
                    ps.setInt(4, propertySaleDetails.sellerContactId());
                    ps.setInt(5, propertySaleDetails.saleByContactId());
                    ps.setInt(6, propertySaleDetails.brokerage());
                    ps.setString(7, AppUtility.getCurrentDateInString());
                    ps.setInt(8, propertySaleDetails.saleBy());
                    ps.setInt(9, statusId);
                    ps.executeUpdate();
                    try (PreparedStatement propStatus = con.prepareStatement(UPDATE_PROPERTY_OWNER_AND_PRICE);){
                        propStatus.setInt(1, propertySaleDetails.buyerContactId());
                        propStatus.setInt(2, propertySaleDetails.amount());
                        propStatus.setInt(3, propertySaleDetails.propertyId());
                        propStatus.executeUpdate();
                    }
                    try (PreparedStatement psNewStatus = con.prepareStatement(INSERT_STATUS);){
                        psNewStatus.setInt(1, propertySaleDetails.propertyStatus());
                        psNewStatus.setInt(2, propertySaleDetails.propertyId());
                        psNewStatus.setString(3, propertySaleDetails.date());
                        psNewStatus.executeUpdate();
                        con.commit();
                    }
                    catch (Exception ex) {
                        con.rollback();
                        throw new RuntimeException(ex.getMessage());
                    }
                }
                catch (Exception e) {
                    con.rollback();
                    throw new RuntimeException(e.getMessage());
                }
            }
            catch (Exception ex) {
                con.rollback();
                throw new RuntimeException(ex.getMessage());
            }
        }
    }
}

