/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.dao.settings;

import com.arun.bhardwaj.dao.settings.ManageTeamDao;
import com.arun.bhardwaj.model.team.EmailConfig;
import com.arun.bhardwaj.model.team.TeamConversationDetails;
import com.arun.bhardwaj.model.team.TeamDetails;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.utility.DbUtility;
import com.arun.bhardwaj.utility.EncryptionUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class ManageTeamDaoImpl
implements ManageTeamDao {
    private static final String SAVE_TEAM_MEMBERS = "INSERT INTO TEAM_MEMBERS (FK_CONTACT_ID ,CREATED_ON) VALUES (?,?)\n";
    private static final String LOAD_TEAM_MEMBER_DETAILS = "SELECT  NAME,\n        (SELECT VALUE FROM CONTACT_NUMBERS WHERE FK_CONTACT_ID = C.CONTACT_ID AND IS_PRIMARY ='Yes') AS NUMBER,\n        (SELECT ADDRESS || ' ' || AREA || ' ' || CITY || ' ' || PIN FROM CONTACT_ADDRESS WHERE FK_CONTACT_ID = C.CONTACT_ID AND IS_PRIMARY ='Yes') AS ADDRESS,\n        (SELECT GROUP_CONCAT(VALUE, ';') FROM CONTACT_EMAILS WHERE FK_CONTACT_ID = C.CONTACT_ID AND TYPE = 'Email' GROUP BY FK_CONTACT_ID) AS EMAIL_IDS,\n        COMMENTS,\n        CONTACT_ID\nFROM CONTACTS C\nWHERE CONTACT_ID IN (SELECT FK_CONTACT_ID FROM TEAM_MEMBERS) order by NAME ASC\n";
    private static final String FIND_TEAM_MEMBER_ID_BY_EMAIL_ID = "select TEAM_MEMBER_ID from CONTACT_EMAILS CM\nJOIN TEAM_MEMBERS TM ON CM.FK_CONTACT_ID = TM.FK_CONTACT_ID\nwhere CM.VALUE =?\n";
    private static final String LOAD_TEAM_CONVERSTION_DETAILS = "SELECT REQUEST_RECEIVED,\n       REQUEST_DATE_TIME,\n       RESPONSE,\n       RESPONSE_DATE_TIME\n  FROM TEAM_AUDIT_DETAILS\n  where FK_TEAM_MEMBER_ID =(select TEAM_MEMBER_ID from TEAM_MEMBERS where FK_CONTACT_ID =?) order by TEAM_AUDIT_ID DESC\n";
    private static final String SAVE_TEAM_MEMBER_REQUEST = "INSERT INTO TEAM_AUDIT_DETAILS (FK_TEAM_MEMBER_ID, REQUEST_RECEIVED, REQUEST_DATE_TIME, CREATED_ON ) VALUES (?,?,?,?)";
    private static final String UPDATE_TEAM_MEMBER_RESPONSE = "UPDATE TEAM_AUDIT_DETAILS SET RESPONSE =? , RESPONSE_DATE_TIME=? WHERE TEAM_AUDIT_ID =?";
    private static final String CHECK_TEAM_MEMBER_EXISTS = "Select * from TEAM_MEMBERS where FK_CONTACT_ID =?";
    private static final String DELETE_TEAM_MEMBER = "DELETE  FROM TEAM_MEMBERS where FK_CONTACT_ID =?";
    private static final String FETCH_EMAIL_CONFIG = "SELECT EMAIL_CONFIG_ID ,EMAIL, PASSWORD,IMAP_HOST, IMAP_PORT,SMTP_HOST,SMTP_PORT FROM EMAIL_CONFIG_DETAILS";
    private static final String SAVE_EMAIL_CONFIG = "INSERT INTO EMAIL_CONFIG_DETAILS (EMAIL, PASSWORD,IMAP_HOST, IMAP_PORT,SMTP_HOST,SMTP_PORT, CREATED_ON) VALUES (?,?,?,?,?,?,?)";
    private static final String UPDATE_EMAIL_CONFIG = "UPDATE EMAIL_CONFIG_DETAILS SET EMAIL=?, PASSWORD=?,IMAP_HOST=?, IMAP_PORT=?,SMTP_HOST=?,SMTP_PORT=? ,MODIFY_ON=? where EMAIL_CONFIG_ID =? ";

    @Override
    public void save(int contactId) throws Exception {
        try (Connection con = DbUtility.getConnection();){
            try (PreparedStatement ps = con.prepareStatement(SAVE_TEAM_MEMBERS);){
                ps.setInt(1, contactId);
                ps.setString(2, AppUtility.getCurrentDateInString());
                ps.executeUpdate();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public List<TeamDetails> loadTeamDetails() throws Exception {
        ArrayList<TeamDetails> response = new ArrayList<TeamDetails>();
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(LOAD_TEAM_MEMBER_DETAILS);
             ResultSet result = ps.executeQuery();){
            while (result.next()) {
                response.add(new TeamDetails(result.getString("NAME"), result.getString("ADDRESS"), result.getString("NUMBER"), result.getString("EMAIL_IDS"), result.getString("COMMENTS"), result.getInt("CONTACT_ID")));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return response;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public int saveTeamRequest(String request, String requestFrom) throws RuntimeException {
        int teamId = this.findTeamMemberIdByEmail(requestFrom);
        try (Connection con = DbUtility.getConnection();){
            int n;
            block16: {
                PreparedStatement ps = con.prepareStatement(SAVE_TEAM_MEMBER_REQUEST, 1);
                try {
                    ps.setInt(1, teamId);
                    ps.setString(2, request);
                    ps.setString(3, AppUtility.getCurrentDateInString());
                    ps.setString(4, AppUtility.getCurrentDateInString());
                    ps.executeUpdate();
                    n = ps.getGeneratedKeys().getInt(1);
                    if (ps == null) break block16;
                }
                catch (Throwable throwable) {
                    try {
                        if (ps != null) {
                            try {
                                ps.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e.getMessage());
                    }
                }
                ps.close();
            }
            return n;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int findTeamMemberIdByEmail(String requestFrom) throws RuntimeException {
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(FIND_TEAM_MEMBER_ID_BY_EMAIL_ID);){
            ps.setString(1, requestFrom);
            try (ResultSet result = ps.executeQuery();){
                if (!result.next()) return 0;
                int n = result.getInt(1);
                return n;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public void updateTeamResponse(String response, int teamAuditId) throws RuntimeException {
        try (Connection con = DbUtility.getConnection();){
            try (PreparedStatement ps = con.prepareStatement(UPDATE_TEAM_MEMBER_RESPONSE);){
                ps.setString(1, response);
                ps.setString(2, AppUtility.getCurrentDateInString());
                ps.setInt(3, teamAuditId);
                ps.executeUpdate();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public boolean isTeamMemberExists(Integer contactId) throws Exception {
        block25: {
            try (Connection con = DbUtility.getConnection();){
                ResultSet resultSet;
                PreparedStatement ps;
                block22: {
                    boolean bl;
                    block24: {
                        block23: {
                            ps = con.prepareStatement(CHECK_TEAM_MEMBER_EXISTS);
                            ps.setInt(1, contactId);
                            resultSet = ps.executeQuery();
                            if (!resultSet.next()) break block22;
                            bl = true;
                            if (resultSet == null) break block23;
                            resultSet.close();
                        }
                        if (ps == null) break block24;
                        ps.close();
                    }
                    return bl;
                }
                try {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        break block25;
                        {
                            catch (Throwable throwable) {
                                if (resultSet != null) {
                                    try {
                                        resultSet.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
        }
        return false;
    }

    @Override
    public List<TeamConversationDetails> loadTeamConversationDetails(Integer contactId) throws Exception {
        ArrayList<TeamConversationDetails> teamConversationDetails = new ArrayList<TeamConversationDetails>();
        try (Connection con = DbUtility.getConnection();
             PreparedStatement ps = con.prepareStatement(LOAD_TEAM_CONVERSTION_DETAILS);){
            ps.setInt(1, contactId);
            try (ResultSet resultSet = ps.executeQuery();){
                while (resultSet.next()) {
                    teamConversationDetails.add(new TeamConversationDetails(resultSet.getString("REQUEST_RECEIVED"), resultSet.getString("REQUEST_DATE_TIME"), resultSet.getString("RESPONSE"), resultSet.getString("RESPONSE_DATE_TIME")));
                }
            }
        }
        return teamConversationDetails;
    }

    @Override
    public void deleteTeamMemberRecord(Integer contactId) throws Exception {
        try (Connection con = DbUtility.getConnection();
             PreparedStatement ps = con.prepareStatement(DELETE_TEAM_MEMBER);){
            ps.setInt(1, contactId);
            ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public EmailConfig fetchEmailConfigId() throws Exception {
        try (Connection con = DbUtility.getConnection();
             Statement statement = con.createStatement();
             ResultSet resultSet = statement.executeQuery(FETCH_EMAIL_CONFIG);){
            if (!resultSet.next()) return null;
            EmailConfig emailConfig = new EmailConfig(resultSet.getInt("EMAIL_CONFIG_ID"), resultSet.getString("EMAIL"), EncryptionUtil.decrypt(resultSet.getString("PASSWORD")), resultSet.getString("IMAP_HOST"), resultSet.getString("IMAP_PORT"), resultSet.getString("SMTP_HOST"), resultSet.getString("SMTP_PORT"));
            return emailConfig;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public void saveEmailConfig(EmailConfig emailConfig) throws Exception {
        try (Connection con = DbUtility.getConnection();){
            try (PreparedStatement ps = con.prepareStatement(SAVE_EMAIL_CONFIG);){
                ps.setString(1, emailConfig.email());
                ps.setString(2, EncryptionUtil.encrypt(emailConfig.password()));
                ps.setString(3, emailConfig.imapHost());
                ps.setString(4, emailConfig.imapPort());
                ps.setString(5, emailConfig.smtpHost());
                ps.setString(6, emailConfig.smtpPort());
                ps.setString(7, AppUtility.getCurrentDateInString());
                ps.executeUpdate();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public void updateEmailConfig(EmailConfig emailConfig) throws Exception {
        try (Connection con = DbUtility.getConnection();){
            try (PreparedStatement ps = con.prepareStatement(UPDATE_EMAIL_CONFIG);){
                ps.setString(1, emailConfig.email());
                ps.setString(2, EncryptionUtil.encrypt(emailConfig.password()));
                ps.setString(3, emailConfig.imapHost());
                ps.setString(4, emailConfig.imapPort());
                ps.setString(5, emailConfig.smtpHost());
                ps.setString(6, emailConfig.smtpPort());
                ps.setString(7, AppUtility.getCurrentDateInString());
                ps.setInt(8, emailConfig.emailconfigId());
                ps.executeUpdate();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

