/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.dao.settings;

import com.arun.bhardwaj.dao.settings.UserDetailDao;
import com.arun.bhardwaj.exceptions.DatabaseException;
import com.arun.bhardwaj.model.UserDetails;
import com.arun.bhardwaj.utility.DbUtility;
import com.arun.bhardwaj.view.LoginView;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.mindrot.jbcrypt.BCrypt;

public class UserDetailsDaoImpl
implements UserDetailDao {
    private static final String LOAD_USER_DETAILS = "SELECT USER_NAME,ADDRESS,LOGO,\n       VERSION,CREATED_ON,\n       EMAIL,MOBILE,CLIENT_ID,CREATED_ON\n  FROM USER_DETAILS;\n";
    private static final String UPDATE_USER_DETAILS = "UPDATE  USER_DETAILS SET  ADDRESS =?, MOBILE=?, EMAIL=?;\n";
    private static final String UPDATE_USER_LOGO = "UPDATE  USER_DETAILS SET  LOGO=?;\n";
    private static final String UPDATE_NEW_PASSWORD = "UPDATE USER_DETAILS SET PASSWORD =?";

    @Override
    public UserDetails loadUserDetails() throws DatabaseException {
        UserDetails userDetails = null;
        try (Connection con = DbUtility.getConnection();
             Statement statement = con.createStatement();
             ResultSet resultSet = statement.executeQuery(LOAD_USER_DETAILS);){
            if (resultSet.next()) {
                userDetails = new UserDetails.Builder().userName(resultSet.getString("USER_NAME")).address(resultSet.getString("ADDRESS")).email(resultSet.getString("EMAIL")).logo(resultSet.getBinaryStream("LOGO")).clientId(resultSet.getString("CLIENT_ID")).createdOn(resultSet.getString("CREATED_ON")).mobileNo(resultSet.getString("MOBILE")).build();
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        return userDetails;
    }

    @Override
    public void updateUserDetails(UserDetails userDetails) throws Exception {
        String sql = UPDATE_USER_DETAILS;
        try (Connection conn = DbUtility.getConnection();){
            try (PreparedStatement ps = conn.prepareStatement(UPDATE_USER_DETAILS);){
                ps.setString(1, userDetails.address());
                ps.setString(2, userDetails.mobileNo());
                ps.setString(3, userDetails.email());
                ps.executeUpdate();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    @Override
    public void changePassword(String oldPassword, String newPassword) throws Exception {
        block15: {
            if (oldPassword.equals(LoginView.password)) {
                try (Connection conn = DbUtility.getConnection();){
                    try (PreparedStatement ps = conn.prepareStatement(UPDATE_NEW_PASSWORD);){
                        ps.setString(1, BCrypt.hashpw(newPassword, BCrypt.gensalt()));
                        ps.executeUpdate();
                        break block15;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e.getMessage());
                    }
                }
            }
            throw new RuntimeException("Old password does not match");
        }
    }

    @Override
    public void changeLogo(String imagePath) throws Exception {
        try (Connection conn = DbUtility.getConnection();
             PreparedStatement ps = conn.prepareStatement(UPDATE_USER_LOGO);){
            if (!"-".equals(imagePath)) {
                File file = new File(imagePath);
                FileInputStream fis = new FileInputStream(file);
                ps.setBinaryStream(1, (InputStream)fis, (int)file.length());
            } else {
                ps.setBinaryStream(1, (InputStream)new ByteArrayInputStream(new byte[0]), 0);
            }
            ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

