/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.dbMigration;

import com.arun.bhardwaj.dbMigration.DatabaseMigration;
import com.arun.bhardwaj.utility.DbUtility;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;

public class DatabaseMigration2Dot4Impl
implements DatabaseMigration {
    private final String version;
    private static final String ADD_NEW_DATABASE_TABLES = "  CREATE TABLE ENQUIRY (\n          ENQUIRY_ID  INTEGER    PRIMARY KEY ASC AUTOINCREMENT,\n          DATE  TEXT NOT NULL,\n          LOOKING_FOR TEXT NOT NULL,\n          AREA TEXT NULL,\n          BUDGET_FROM TEXT NULL,\n          BUDGET_TO TEXT NULL,\n          SIZE_FROM TEXT NULL,\n          SIZE_TO TEXT NULL,\n          SOURCE TEXT NULL,\n          COMMENTS TEXT NULL,\n          STATUS INTEGER NOT NULL,\n          CREATED_ON  TEXT  NOT NULL,\n          MODIFY_ON   TEXT NULL,\n          FK_CONTACT_ID INTEGER  REFERENCES CONTACTS (CONTACT_ID) ON DELETE CASCADE,\n          FK_GROUP_ID   INTEGER  REFERENCES PROPERTY_GROUP (GROUP_ID) ON DELETE CASCADE\n        );\n\n         CREATE TABLE ENQUIRY_FOLLOWUP (\n              ENQUIRY_FOLLOW_UP_ID  INTEGER    PRIMARY KEY ASC AUTOINCREMENT,\n              DATE  TEXT NOT NULL,\n              FOLLOW_UP_DATE  TEXT NOT NULL,\n              COMMENTS TEXT NULL,\n              FOLLOWUP_STATUS INTEGER NOT NULL,\n              CREATED_ON  TEXT  NOT NULL,\n              MODIFY_ON   TEXT NULL,\n              FK_ENQUIRY_ID INTEGER  REFERENCES ENQUIRY (ENQUIRY_ID) ON DELETE CASCADE\n           );\n\n";
    private static final String UPDATE_DATABASE_VERSION = "UPDATE USER_DETAILS SET VERSION =?";

    public DatabaseMigration2Dot4Impl(String version) {
        this.version = version;
    }

    @Override
    public void execute() throws Exception {
        conn.setAutoCommit(false);
        try (Connection conn = DbUtility.getConnection();
             Statement stmt = conn.createStatement();){
            stmt.executeUpdate(ADD_NEW_DATABASE_TABLES);
            try (PreparedStatement preparedStatement = conn.prepareStatement(UPDATE_DATABASE_VERSION);){
                preparedStatement.setString(1, this.version);
                preparedStatement.executeUpdate();
                conn.commit();
            }
            catch (Exception e) {
                conn.rollback();
                throw new RuntimeException(e.getMessage());
            }
        }
    }
}

