/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.dbMigration;

import com.arun.bhardwaj.dbMigration.DatabaseMigration;
import com.arun.bhardwaj.utility.DbUtility;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;

public class DatabaseMigration2Dot7Impl
implements DatabaseMigration {
    private final String version;
    private static final String UPDATE_DATABASE_VERSION = "UPDATE USER_DETAILS SET VERSION =?";
    private static final String CREATE_DATABASE_TABLES = "        DROP TABLE IF EXISTS DEPOSIT_TRACKER;\n        DROP TABLE IF EXISTS RENT_CONDITIONS;\n\n        CREATE TABLE DEPOSIT_TRACKER (\n           DEPOSIT_ID  INTEGER PRIMARY KEY ASC AUTOINCREMENT,\n           PAYMENT_DATE TEXT NOT NULL,\n           MODE_OF_PAYMENT INTEGER NOT NULL,\n           PAYMENT_REFERENCE_NO TEXT NULL,\n           PAYMENT_AMOUNT INTEGER NOT NULL,\n           COMMENTS TEXT NULL,\n           PAID_BY TEXT NOT NULL,\n           CREATED_ON TEXT NOT NULL,\n           MODIFY_ON  TEXT NULL,\n           FK_PROPERTY_ON_RENT_ID  INTEGER NOT NULL REFERENCES PROPERTY_ON_RENT (PROPERTY_ON_RENT_ID) ON DELETE CASCADE\n       );\n\n       CREATE TABLE RENT_CONDITIONS (\n          RENT_CONDITIONS_ID  INTEGER PRIMARY KEY ASC AUTOINCREMENT,\n          START_MONTH           TEXT    NOT NULL,\n          END_MONTH             TEXT    NOT NULL,\n          RENT                 INTEGER  NULL,\n          RENT_REVISED_IN_MONTHS     INTEGER NOT NULL,\n          FK_PROPERTY_STATUS_ID  INTEGER NOT NULL REFERENCES PROPERTY_STATUS (PROPERTY_STATUS_ID) ON DELETE CASCADE\n       );\n";

    public DatabaseMigration2Dot7Impl(String version) {
        this.version = version;
    }

    @Override
    public void execute() throws Exception {
        conn.setAutoCommit(false);
        try (Connection conn = DbUtility.getConnection();
             Statement stmt = conn.createStatement();){
            stmt.executeUpdate(CREATE_DATABASE_TABLES);
            try (PreparedStatement preparedStatement = conn.prepareStatement(UPDATE_DATABASE_VERSION);){
                preparedStatement.setString(1, this.version);
                preparedStatement.executeUpdate();
                conn.commit();
            }
            catch (Exception e) {
                conn.rollback();
                throw new RuntimeException(e.getMessage());
            }
        }
    }
}

