/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.dbMigration;

import com.arun.bhardwaj.dbMigration.DatabaseMigration;
import com.arun.bhardwaj.utility.DbUtility;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;

public class DatabaseMigration2Dot8Impl
implements DatabaseMigration {
    private final String version;
    private static final String UPDATE_DATABASE_VERSION = "UPDATE USER_DETAILS SET VERSION =?";
    private static final String CREATE_DATABASE_TABLES = "\nDROP TABLE IF EXISTS CONTACT_DOCUMENTS;\nDROP TABLE IF EXISTS PROPERTY_DOCUMENTS;\nDROP TABLE IF EXISTS PROPERTY_LEASE_DOCUMENTS;\n\nCREATE TABLE CONTACT_DOCUMENTS (\n    CONTACT_DOCUMENT_ID  INTEGER PRIMARY KEY ASC AUTOINCREMENT,\n    DOCUMENT_NAME TEXT NOT NULL,\n    DOCUMENT BLOB NULL,\n    CREATED_ON  TEXT  NOT NULL,\n    MODIFY_ON   TEXT NULL,\n    FK_CONTACT_ID INTEGER NOT NULL ,\n    CONSTRAINT FK_CONTACT_ID_CONSTRAINT\n    FOREIGN KEY (FK_CONTACT_ID)\n    REFERENCES CONTACTS(CONTACT_ID)\n    ON DELETE CASCADE\n);\n\n\n CREATE TABLE PROPERTY_DOCUMENTS (\n    PROPERTY_DOCUMENT_ID  INTEGER PRIMARY KEY ASC AUTOINCREMENT,\n    DOCUMENT_NAME TEXT NOT NULL,\n    DOCUMENT BLOB NULL,\n    CREATED_ON  TEXT  NOT NULL,\n    MODIFY_ON   TEXT NULL,\n    FK_PROPERTY_ID INTEGER    REFERENCES PROPERTY_RECORDS (PROPERTY_ID) ON DELETE CASCADE\n);\n\n  CREATE TABLE PROPERTY_TRANSACTION_DOCUMENTS (\n        TRANSACTION_DOCUMENT_ID  INTEGER PRIMARY KEY ASC AUTOINCREMENT,\n        DOCUMENT_NAME TEXT NOT NULL,\n        DOCUMENT BLOB NULL,\n        CREATED_ON  TEXT  NOT NULL,\n        MODIFY_ON   TEXT NULL,\n        FK_PROPERTY_STATUS_ID INTEGER REFERENCES PROPERTY_STATUS (PROPERTY_STATUS_ID) ON DELETE CASCADE\n    );\n\n";

    public DatabaseMigration2Dot8Impl(String version) {
        this.version = version;
    }

    @Override
    public void execute() throws Exception {
        conn.setAutoCommit(false);
        try (Connection conn = DbUtility.getConnection();
             Statement stmt = conn.createStatement();){
            stmt.executeUpdate(CREATE_DATABASE_TABLES);
            try (PreparedStatement preparedStatement = conn.prepareStatement(UPDATE_DATABASE_VERSION);){
                preparedStatement.setString(1, this.version);
                preparedStatement.executeUpdate();
                conn.commit();
            }
            catch (Exception e) {
                conn.rollback();
                throw new RuntimeException(e.getMessage());
            }
        }
    }
}

