/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.dbMigration;

import com.arun.bhardwaj.dbMigration.DatabaseMigration;
import com.arun.bhardwaj.utility.DbUtility;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;

public class DatabaseMigration2Dot9Impl
implements DatabaseMigration {
    private final String version;
    private static final String UPDATE_DATABASE_VERSION = "UPDATE USER_DETAILS SET VERSION =?";
    private static final String CREATE_DATABASE_TABLES = "\n      DROP TABLE IF EXISTS TEAM_MEMBERS;\n      DROP TABLE IF EXISTS TEAM_AUDIT_DETAILS;\n      DROP TABLE IF EXISTS EMAIL_CONFIG_DETAILS;\n\n      CREATE TABLE TEAM_MEMBERS (\n          TEAM_MEMBER_ID  INTEGER    PRIMARY KEY ASC AUTOINCREMENT,\n          FK_CONTACT_ID INTEGER NOT NULL ,\n          CREATED_ON  TEXT  NOT NULL,\n          CONSTRAINT FK_CONTACT_ID_CONSTRAINT\n          FOREIGN KEY (FK_CONTACT_ID)\n          REFERENCES CONTACTS(CONTACT_ID)\n          ON DELETE CASCADE\n      );\n\n       CREATE TABLE TEAM_AUDIT_DETAILS (\n          TEAM_AUDIT_ID  INTEGER    PRIMARY KEY ASC AUTOINCREMENT,\n          FK_TEAM_MEMBER_ID INTEGER NOT NULL ,\n          REQUEST_RECEIVED TEXT  NOT NULL,\n          REQUEST_DATE_TIME TEXT NOT NULL,\n          RESPONSE TEXT  NULL,\n          RESPONSE_DATE_TIME TEXT NULL,\n          CREATED_ON  TEXT  NOT NULL,\n          CONSTRAINT FK_TEAM_MEMBER_CONSTRAINT\n          FOREIGN KEY (FK_TEAM_MEMBER_ID)\n          REFERENCES TEAM_MEMBERS(TEAM_MEMBER_ID)\n          ON DELETE CASCADE\n      );\n\n      CREATE TABLE EMAIL_CONFIG_DETAILS (\n          EMAIL_CONFIG_ID  INTEGER    PRIMARY KEY ASC AUTOINCREMENT,\n          EMAIL TEXT  NOT NULL,\n          PASSWORD TEXT NOT NULL,\n          IMAP_HOST TEXT NOT NULL,\n          IMAP_PORT TEXT NOT NULL,\n          SMTP_HOST TEXT NOT NULL,\n          SMTP_PORT TEXT NOT NULL,\n          CREATED_ON  TEXT  NOT NULL,\n          MODIFY_ON   TEXT NULL\n      );\n\n";

    public DatabaseMigration2Dot9Impl(String version) {
        this.version = version;
    }

    @Override
    public void execute() throws Exception {
        conn.setAutoCommit(false);
        try (Connection conn = DbUtility.getConnection();
             Statement stmt = conn.createStatement();){
            stmt.executeUpdate(CREATE_DATABASE_TABLES);
            try (PreparedStatement preparedStatement = conn.prepareStatement(UPDATE_DATABASE_VERSION);){
                preparedStatement.setString(1, this.version);
                preparedStatement.executeUpdate();
                conn.commit();
            }
            catch (Exception e) {
                conn.rollback();
                throw new RuntimeException(e.getMessage());
            }
        }
    }
}

