/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.dbMigration;

import com.arun.bhardwaj.dbMigration.DatabaseMigration;
import com.arun.bhardwaj.exceptions.DatabaseException;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.utility.DbUtility;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;

public class DatabaseMigration3Dot4Impl
implements DatabaseMigration {
    private final String version;
    private static final String UPDATE_DATABASE_VERSION = "UPDATE USER_DETAILS SET VERSION =?";
    private static final String CREATE_DATABASE_TABLES = "\n\n\n      DROP TABLE IF EXISTS PROJECT_TYPES;\n      DROP TABLE IF EXISTS PROJECT_DETAILS;\n      DROP TABLE IF EXISTS PROJECT_UNIT_DETAILS;\n      DROP TABLE IF EXISTS PROJECT_AMENITIES_DETAILS;\n      DROP TABLE IF EXISTS PROJECT_ADDITIONAL_DETAILS;\n      DROP TABLE IF EXISTS PROJECT_TRANSACTION_DOCUMENTS;\n\n\n      CREATE TABLE PROJECT_TYPES\n        (\n          PROJECT_TYPE_ID   INTEGER  PRIMARY KEY ASC AUTOINCREMENT,\n          PROJECT_TYPE_NAME TEXT  UNIQUE NOT NULL,\n          CREATED_ON TEXT NOT NULL ,\n          MODIFY_ON  TEXT NULL\n      );\n\n      CREATE TABLE PROJECT_DETAILS\n        (\n          PROJECT_ID  INTEGER  PRIMARY KEY ASC AUTOINCREMENT,\n          PROJECT_NAME TEXT  UNIQUE NOT NULL,\n          FK_PROJECT_TYPE_ID INTEGER  REFERENCES PROJECT_TYPES (PROJECT_TYPE_ID) ON DELETE CASCADE,\n          PROJECT_STATUS TEXT NULL,\n          TOTAL_AREA INTEGER NULL,\n          TOTAL_UNITS INTEGER NULL,\n          NUMBER_OF_FLOORS INTEGER NULL,\n          PROJECT_DESCRIPTION TEXT NULL,\n          LAUNCH_DATE TEXT NULL,\n          COMPLETION_DATE TEXT NULL,\n          LOCATION_DETAILS TEXT NULL,\n          FK_BUILDER_CONTACT_ID  INTEGER NOT NULL,\n          FK_ARCHITECT_CONTACT_ID INTEGER NULL,\n          RERA_REGISTRATION_NUMBER TEXT NULL,\n          CREATED_ON TEXT NOT NULL ,\n          MODIFY_ON  TEXT NULL\n      );\n\n      CREATE INDEX idx_fk_project_type_id ON PROJECT_DETAILS (FK_PROJECT_TYPE_ID);\n      CREATE INDEX idx_project_name ON PROJECT_DETAILS (PROJECT_NAME);\n\n       CREATE TABLE PROJECT_UNIT_DETAILS\n        (\n          UNIT_ID   INTEGER  PRIMARY KEY ASC AUTOINCREMENT,\n          PROPERTY_TYPE TEXT  NOT NULL,\n          UNIT_SIZE INTEGER  NULL ,\n          UNIT_BASE_PRICE INTEGER  NULL ,\n          PAYMENT_PLAN TEXT NULL,\n          COMMENTS TEXT NULL,\n          FK_PROJECT_ID INT REFERENCES PROJECT_DETAILS (PROJECT_ID) ON DELETE CASCADE,\n          CREATED_ON TEXT NOT NULL ,\n          MODIFY_ON  TEXT NULL\n      );\n\n      CREATE INDEX idx_fk_project_id_unit_details ON PROJECT_UNIT_DETAILS (FK_PROJECT_ID);\n\n\n       CREATE TABLE PROJECT_AMENITIES_DETAILS\n        (\n          AMENITIES_ID   INTEGER  PRIMARY KEY ASC AUTOINCREMENT,\n          AMENITIES TEXT  NOT NULL,\n          FK_PROJECT_ID INT REFERENCES PROJECT_DETAILS (PROJECT_ID) ON DELETE CASCADE,\n          CREATED_ON TEXT NOT NULL\n      );\n      CREATE INDEX idx_fk_project_id_amenities_details ON PROJECT_AMENITIES_DETAILS (FK_PROJECT_ID);\n\n\n      CREATE TABLE PROJECT_ADDITIONAL_DETAILS\n        (\n          ADDITIONAL_ID INTEGER  PRIMARY KEY ASC AUTOINCREMENT,\n          NAME TEXT  NOT NULL,\n          VALUE TEXT NOT  NULL,\n          FK_PROJECT_ID INT REFERENCES PROJECT_DETAILS (PROJECT_ID) ON DELETE CASCADE,\n          CREATED_ON TEXT NOT NULL\n      );\n      CREATE INDEX idx_fk_project_id_additional_details ON PROJECT_ADDITIONAL_DETAILS (FK_PROJECT_ID);\n\n\n       CREATE TABLE PROJECT_TRANSACTION_DOCUMENTS (\n              TRANSACTION_DOCUMENT_ID  INTEGER PRIMARY KEY ASC AUTOINCREMENT,\n              DOCUMENT_NAME TEXT NOT NULL,\n              DOCUMENT BLOB NULL,\n              CREATED_ON  TEXT  NOT NULL,\n              MODIFY_ON   TEXT NULL,\n              FK_PROJECT_ID INT REFERENCES PROJECT_DETAILS (PROJECT_ID) ON DELETE CASCADE\n       );\n       CREATE INDEX idx_fk_project_documents ON PROJECT_TRANSACTION_DOCUMENTS (FK_PROJECT_ID);\n\n      CREATE INDEX idx_fk_contact_group ON CONTACTS (FK_GROUP_ID);\n      CREATE INDEX idx_fk_contact_address_contactId ON CONTACT_ADDRESS (FK_CONTACT_ID);\n      CREATE INDEX idx_fk_contact_numbers_contactId ON CONTACT_NUMBERS (FK_CONTACT_ID);\n      CREATE INDEX idx_fk_contact_email_contactId ON CONTACT_EMAILS (FK_CONTACT_ID);\n      CREATE INDEX idx_fk_contact_event_contactId ON CONTACT_EVENTS (FK_CONTACT_ID);\n      CREATE INDEX idx_fk_contact_add_info_contactId ON CONTACT_ADDITIONAL_INFO (FK_CONTACT_ID);\n      CREATE INDEX idx_fk_property_record_contactId ON PROPERTY_RECORDS (FK_CONTACT_ID);\n      CREATE INDEX idx_fk_property_record_groupId ON PROPERTY_RECORDS (FK_GROUP_ID);\n      CREATE INDEX idx_fk_property_status_propertyId ON PROPERTY_STATUS (FK_PROPERTY_ID);\n      CREATE INDEX idx_fk_property_on_rent_owner_contactId ON PROPERTY_ON_RENT (FK_OWNER_CONTACT_ID);\n      CREATE INDEX idx_fk_property_on_rent_tenant_contactId ON PROPERTY_ON_RENT (FK_TENANT_CONTACT_ID);\n      CREATE INDEX idx_fk_property_on_rent_statusId ON PROPERTY_ON_RENT (FK_PROPERTY_STATUS_ID);\n      CREATE INDEX idx_fk_property_on_sell_buyer_contactId ON PROPERTY_SELL_DETAILS (FK_BUYER_ID);\n      CREATE INDEX idx_fk_property_on_sell_seller_contactId ON PROPERTY_SELL_DETAILS (FK_SELLER_ID);\n      CREATE INDEX idx_fk_property_on_sell_statusId ON PROPERTY_SELL_DETAILS (FK_PROPERTY_STATUS_ID);\n      CREATE INDEX idx_fk_property_payment_tracker ON PAYMENT_TRACKER (FK_PROPERTY_ON_RENT_ID);\n      CREATE INDEX idx_fk_enquiry_contactId ON ENQUIRY (FK_CONTACT_ID);\n      CREATE INDEX idx_fk_enquiry_groupId ON ENQUIRY (FK_GROUP_ID);\n      CREATE INDEX idx_fk_enquiry_followUp ON ENQUIRY_FOLLOWUP (FK_ENQUIRY_ID);\n\n      CREATE INDEX idx_fk_rent_deposit_tracker ON DEPOSIT_TRACKER (FK_PROPERTY_ON_RENT_ID);\n      CREATE INDEX idx_fk_rent_conditions ON RENT_CONDITIONS (FK_PROPERTY_STATUS_ID);\n      CREATE INDEX idx_fk_contact_document ON CONTACT_DOCUMENTS (FK_CONTACT_ID);\n      CREATE INDEX idx_fk_property_document_propertyId ON PROPERTY_DOCUMENTS (FK_PROPERTY_ID);\n\n      CREATE INDEX idx_fk_property_trans_document_statusId ON PROPERTY_TRANSACTION_DOCUMENTS (FK_PROPERTY_STATUS_ID);\n\n\n\n";
    private static final String INSERT_DEFAULT_PROJECT_CATEGORIES = "INSERT INTO PROJECT_TYPES (PROJECT_TYPE_NAME, CREATED_ON) VALUES (?, ?);";

    public DatabaseMigration3Dot4Impl(String version) {
        this.version = version;
    }

    @Override
    public void execute() throws Exception {
        LocalDate currentDate = LocalDate.now();
        conn.setAutoCommit(false);
        try (Connection conn = DbUtility.getConnection();
             Statement stmt = conn.createStatement();){
            stmt.executeUpdate(CREATE_DATABASE_TABLES);
            try (PreparedStatement ps = conn.prepareStatement(INSERT_DEFAULT_PROJECT_CATEGORIES);){
                List<String> defaultProjectTypes = Arrays.asList("Residential", "Commercial", "Land", "Industrial");
                for (String category : defaultProjectTypes) {
                    ps.setString(1, category);
                    ps.setString(2, AppUtility.convertDatetoString(currentDate));
                    ps.addBatch();
                }
                ps.executeBatch();
            }
            catch (SQLException e) {
                conn.rollback();
                throw new DatabaseException(e.getMessage(), e);
            }
            try (PreparedStatement preparedStatement = conn.prepareStatement(UPDATE_DATABASE_VERSION);){
                preparedStatement.setString(1, this.version);
                preparedStatement.executeUpdate();
                conn.commit();
            }
            catch (SQLException e) {
                conn.rollback();
                throw new DatabaseException(e.getMessage(), e);
            }
        }
    }
}

