/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.dbMigration;

import com.arun.bhardwaj.dbMigration.DatabaseMigration;
import com.arun.bhardwaj.exceptions.DatabaseException;
import com.arun.bhardwaj.utility.DbUtility;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public class DatabaseMigration3Dot5Impl
implements DatabaseMigration {
    private final String version;
    private static final String UPDATE_DATABASE_VERSION = "UPDATE USER_DETAILS SET VERSION =?";
    private static final String CREATE_DATABASE_TABLES = "\n\n\n      DROP TABLE IF EXISTS PROPERTY_ADDITIONAL_DETAILS;\n\n\n      CREATE TABLE PROPERTY_ADDITIONAL_DETAILS\n        (\n          ADDITIONAL_ID INTEGER  PRIMARY KEY ASC AUTOINCREMENT,\n          NAME TEXT  NOT NULL,\n          VALUE TEXT NOT  NULL,\n          FK_PROPERTY_ID INT REFERENCES PROPERTY_RECORDS (PROPERTY_ID) ON DELETE CASCADE,\n          CREATED_ON TEXT NOT NULL\n      );\n      CREATE INDEX idx_fk_property_id_additional_details ON PROPERTY_ADDITIONAL_DETAILS (FK_PROPERTY_ID);\n\n";

    public DatabaseMigration3Dot5Impl(String version) {
        this.version = version;
    }

    @Override
    public void execute() throws Exception {
        conn.setAutoCommit(false);
        try (Connection conn = DbUtility.getConnection();
             Statement stmt = conn.createStatement();){
            stmt.executeUpdate(CREATE_DATABASE_TABLES);
            try (PreparedStatement preparedStatement = conn.prepareStatement(UPDATE_DATABASE_VERSION);){
                preparedStatement.setString(1, this.version);
                preparedStatement.executeUpdate();
                conn.commit();
            }
            catch (SQLException e) {
                conn.rollback();
                throw new DatabaseException(e.getMessage(), e);
            }
        }
    }
}

