/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.dbMigration;

import com.arun.bhardwaj.dbMigration.DatabaseMigration;
import com.arun.bhardwaj.exceptions.DatabaseException;
import com.arun.bhardwaj.utility.DbUtility;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public class DatabaseMigration4Dot3Impl
implements DatabaseMigration {
    private final String version;
    private static final String UPDATE_DATABASE_VERSION = "UPDATE USER_DETAILS SET VERSION =?";
    private static final String MODIFY_DATABASE_TABLES = "     ALTER TABLE ENQUIRY\n     ADD COLUMN ADDITIONAL_INFO TEXT;\n";

    public DatabaseMigration4Dot3Impl(String version) {
        this.version = version;
    }

    @Override
    public void execute() throws Exception {
        conn.setAutoCommit(false);
        try (Connection conn = DbUtility.getConnection();
             Statement stmt = conn.createStatement();){
            stmt.executeUpdate(MODIFY_DATABASE_TABLES);
            try (PreparedStatement preparedStatement = conn.prepareStatement(UPDATE_DATABASE_VERSION);){
                preparedStatement.setString(1, this.version);
                preparedStatement.executeUpdate();
                conn.commit();
            }
            catch (SQLException e) {
                conn.rollback();
                throw new DatabaseException(e.getMessage(), e);
            }
        }
    }
}

