/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.factory;

import java.awt.Color;
import java.awt.Cursor;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;

public class CustomButton
extends JButton {
    private static final Map<String, ButtonStyle> buttonStyles = new HashMap<String, ButtonStyle>();

    public CustomButton(String text, String type) {
        super(text);
        ButtonStyle style = buttonStyles.getOrDefault(type.toLowerCase(), buttonStyles.get("primary"));
        this.setBackground(style.backgroundColor);
        this.setForeground(style.foregroundColor);
        this.setFocusPainted(false);
        this.setBorder(BorderFactory.createEmptyBorder(8, 18, 8, 18));
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    static {
        buttonStyles.put("primary", new ButtonStyle(new Color(63, 151, 255), Color.WHITE));
        buttonStyles.put("secondary", new ButtonStyle(new Color(108, 117, 125), Color.WHITE));
        buttonStyles.put("success", new ButtonStyle(new Color(40, 167, 69), Color.WHITE));
        buttonStyles.put("danger", new ButtonStyle(new Color(220, 53, 69), Color.WHITE));
        buttonStyles.put("warning", new ButtonStyle(new Color(255, 193, 7), Color.BLACK));
        buttonStyles.put("info", new ButtonStyle(new Color(23, 162, 184), Color.WHITE));
        buttonStyles.put("light", new ButtonStyle(new Color(248, 249, 250), Color.BLACK));
        buttonStyles.put("dark", new ButtonStyle(new Color(52, 58, 64), Color.WHITE));
    }

    private static class ButtonStyle {
        private final Color backgroundColor;
        private final Color foregroundColor;

        public ButtonStyle(Color backgroundColor, Color foregroundColor) {
            this.backgroundColor = backgroundColor;
            this.foregroundColor = foregroundColor;
        }
    }
}

