/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.service;

import com.arun.bhardwaj.dao.LoginDao;
import com.arun.bhardwaj.dao.LoginDaoImpl;
import com.arun.bhardwaj.dbMigration.DatabaseMigration;
import com.arun.bhardwaj.dbMigration.DatabaseMigrationFactory;
import com.arun.bhardwaj.exceptions.DBMigrationException;
import com.arun.bhardwaj.exceptions.DatabaseException;
import com.arun.bhardwaj.exceptions.ServiceException;
import com.arun.bhardwaj.model.UserDetails;
import com.arun.bhardwaj.service.LoginService;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.utility.EmailUtility;
import com.arun.bhardwaj.utility.UserCache;
import com.arun.bhardwaj.view.LoginView;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.mindrot.jbcrypt.BCrypt;

public class LoginServiceImpl
implements LoginService {
    private final LoginDao dao = new LoginDaoImpl();

    @Override
    public void createUserWithDatabase(UserDetails userDetails) throws ServiceException {
        try {
            this.dao.createUserWithDatabase(userDetails);
            this.generateUserEmail(userDetails);
        }
        catch (Exception e) {
            throw new ServiceException("Error creating user with database: " + e.getMessage(), e);
        }
    }

    @Override
    public UserDetails fetchUserDetails() throws ServiceException {
        try {
            return this.dao.fetchUserDetails();
        }
        catch (DatabaseException e) {
            throw new ServiceException("Error in fetch client details: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean validateUser(String password) throws ServiceException {
        block7: {
            try {
                if (this.dao.validateUser(password)) {
                    if (UserCache.getValidity() > 0L) {
                        String key = this.dao.fetchKey();
                        if (key != null) {
                            if (BCrypt.checkpw(LocalDate.now() + password, key)) {
                                this.checkAndExecuteDBMigration();
                                return true;
                            }
                            break block7;
                        }
                        return false;
                    }
                    return true;
                }
                return false;
            }
            catch (DBMigrationException | DatabaseException | IOException | SQLException e) {
                throw new ServiceException("Error in validate user: " + e.getMessage(), e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    @Override
    public void changePassword(String newPassword) throws ServiceException {
        try {
            this.dao.changePassword(newPassword);
        }
        catch (DatabaseException e) {
            throw new ServiceException("Error in changePassword: " + e.getMessage(), e);
        }
    }

    @Override
    public void renewDatabase(long noOfDays, String password) throws ServiceException {
        try {
            this.dao.renewDatabase(noOfDays, password);
        }
        catch (DatabaseException e) {
            throw new ServiceException("Error in renewDatabase: " + e.getMessage(), e);
        }
    }

    private void checkAndExecuteDBMigration() throws Exception {
        if (!UserCache.getSoftwareVersion().equals(LoginView.version)) {
            for (String version : LoginServiceImpl.getRequiredVersionList(UserCache.getSoftwareVersion())) {
                DatabaseMigration databaseMigration = DatabaseMigrationFactory.makeDatabaseChanges(version);
                databaseMigration.execute();
            }
            EmailUtility.sendEmailToRES("RES upgraded successfully for :" + UserCache.getClientId(), LoginView.version);
        }
    }

    private static List<String> getRequiredVersionList(String clientDbVersion) {
        List<String> appVersions = Arrays.asList("1.0", "2.9", "3.0", "3.1", "3.2", "3.3", "3.4", "3.5", "3.6", "3.7", "3.8", "3.9", "4.0", "4.1", "4.2", "4.3", "4.4", "4.5");
        ArrayList<String> filteredList = new ArrayList<String>();
        boolean shouldAdd = false;
        for (String version : appVersions) {
            if (shouldAdd) {
                filteredList.add(version);
            }
            if (version.equals(clientDbVersion)) {
                shouldAdd = true;
            }
            if (!version.equals(LoginView.version)) continue;
            break;
        }
        return filteredList;
    }

    private void generateUserEmail(UserDetails userDetails) throws JsonProcessingException {
        StringBuilder message = new StringBuilder();
        message.append("<!DOCTYPE html>\n<html lang=\"en\">\n<head>\n    <meta charset=\"UTF-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    <title>Welcome to Real Estate Solutions</title>\n    <style>\n        body {\n            font-family: Arial, sans-serif;\n            background-color: #f5f5f5;\n            margin: 0;\n            padding: 0;\n        }\n        .container {\n            max-width: 600px;\n            margin: 0 auto;\n            padding: 20px;\n            background-color: #ffffff;\n            border-radius: 5px;\n            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);\n        }\n        h1 {\n            color: #333;\n        }\n        p {\n            font-size: 16px;\n            line-height: 1.5;\n            color: #666;\n        }\n        .btn {\n            display: inline-block;\n            padding: 10px 20px;\n            background-color: #007bff;\n            color: #fff;\n            text-decoration: none;\n            border-radius: 5px;\n        }\n        .btn:hover {\n            background-color: #0056b3;\n        }\n    </style>\n</head>\n<body>\n    <div class=\"container\">\n");
        message.append(" <h1>Welcome to Real Estate Solutions! </h1> </br> ");
        message.append("<p>Dear ");
        message.append(userDetails.userName());
        message.append(", </p>");
        message.append("     <p>Thank you for choosing Real Estate Solutions, your all-in-one platform for managing property transactions and contacts in the real estate industry.</p>\n            <p>With our software, you can:</p>\n            <ul>\n                <li>Project Management</li>\n                <li>Comprehensive Transaction Management</li>\n                <li>Property Listing and Statistics</li>\n                <li>Renewal and Termination Management</li>\n                <li>Advanced Property Filtering</li>\n                <li>Payment Tracker</li>\n                <li>Property History</li>\n                 <li>Manage Enquiries</li>\n                <li>Contact Management</li>\n\n\n            </ul>\n            <p>If you have any questions or need assistance, please don't hesitate to contact our support team at <a href=\"\">.</p>\n            <p>We're excited to have you on board, and we look forward to helping you succeed in the world of real estate!</p>\n            <p>Best regards,</p>\n            <p>The Real Estate Solutions Team</p>\n            <p> Chat: <a href='https://wa.me/8800776704'>8800776704</a> </p>\n            <p> Email <a href='mailto:support@shreetechnoworld.com'>support@shreetechnoworld.com </a></p>\n            <p> Website <a href='https://www.shreetechnoworld.com'>shreetechnoworld.com </a></p>\n\n             <p> <h3 style='color:#E75A3C'> Real estate solution for real estate people. </h3> </p>\n             <p><h6> This is a system generated mail. Please don't reply. </h6> </p>\n            </div>\n            </body> </html>\n");
        EmailUtility.sendEmailToClient(userDetails.email(), "Welcome to Real Estate Solution", message.toString());
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        UserDetails userDts = new UserDetails.Builder().userName(userDetails.userName()).address(userDetails.address()).email(userDetails.email()).clientId(userDetails.clientId()).mobileNo(userDetails.mobileNo()).effectiveTill(AppUtility.convertDatetoString(LocalDate.now().plusDays(9L))).productName("Real estate solution V" + LoginView.version).softwareVersion(LoginView.version).build();
        JsonNode jsonNode = objectMapper.readTree(objectMapper.writeValueAsString(userDts));
        if (jsonNode.has("password")) {
            ((ObjectNode)jsonNode).remove("password");
        }
        if (jsonNode.has("logoPath")) {
            ((ObjectNode)jsonNode).remove("logoPath");
        }
        if (jsonNode.has("logo")) {
            ((ObjectNode)jsonNode).remove("logo");
        }
        if (jsonNode.has("createdOn")) {
            ((ObjectNode)jsonNode).remove("createdOn");
        }
        EmailUtility.sendEmailToRES("New user has been registered " + userDetails.email(), objectMapper.writeValueAsString(jsonNode));
    }
}

