/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.service.contact;

import com.arun.bhardwaj.dao.contact.ManageGroupDao;
import com.arun.bhardwaj.dao.contact.ManageGroupDaoImpl;
import com.arun.bhardwaj.exceptions.BusinessException;
import com.arun.bhardwaj.exceptions.DatabaseException;
import com.arun.bhardwaj.exceptions.ServiceException;
import com.arun.bhardwaj.service.contact.ManageGroupService;
import java.util.Map;

public class ManageGroupServiceImpl
implements ManageGroupService {
    ManageGroupDao dao = new ManageGroupDaoImpl();

    @Override
    public void saveContactGroup(String groupName) throws ServiceException, BusinessException {
        try {
            if (this.dao.isGroupExists(groupName)) {
                throw new BusinessException(groupName + " already exists");
            }
            this.dao.saveContactGroup(groupName);
        }
        catch (DatabaseException e) {
            throw new ServiceException("Save contact group", e);
        }
    }

    @Override
    public void updateGroup(String groupName, int selectedGroupId) throws ServiceException, BusinessException {
        try {
            if (this.dao.isGroupExists(groupName)) {
                throw new BusinessException(groupName + " already exists");
            }
            this.dao.updateGroup(groupName, selectedGroupId);
        }
        catch (DatabaseException e) {
            throw new ServiceException("update contact group", e);
        }
    }

    @Override
    public Map<Integer, String> loadGroups() throws ServiceException {
        try {
            return this.dao.loadGroups();
        }
        catch (DatabaseException e) {
            throw new ServiceException("update contact group", e);
        }
    }

    @Override
    public void deleteGroup(int groupId) throws ServiceException {
        try {
            this.dao.deleteGroup(groupId);
        }
        catch (DatabaseException e) {
            throw new ServiceException("delete contact group", e);
        }
    }
}

