/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.service.project;

import com.arun.bhardwaj.dao.project.ManageProjectDao;
import com.arun.bhardwaj.dao.project.ManageProjectDaoImpl;
import com.arun.bhardwaj.exceptions.BusinessException;
import com.arun.bhardwaj.exceptions.DatabaseException;
import com.arun.bhardwaj.exceptions.ServiceException;
import com.arun.bhardwaj.model.project.AmenitiesRecord;
import com.arun.bhardwaj.model.project.ProjectAdditionalDetails;
import com.arun.bhardwaj.model.project.ProjectRecord;
import com.arun.bhardwaj.model.project.UnitPricingAndPaymentDetails;
import com.arun.bhardwaj.service.project.ManageProjectService;
import java.util.List;
import java.util.Map;

public class ManagerProjectServiceImpl
implements ManageProjectService {
    private ManageProjectDao dao = new ManageProjectDaoImpl();

    @Override
    public int saveProjectDetails(ProjectRecord projectRecord) throws ServiceException, BusinessException {
        try {
            if (this.dao.isProjectExist(projectRecord.projectName())) {
                throw new BusinessException(projectRecord.projectName() + " already exist");
            }
            return this.dao.saveProjectDetails(projectRecord);
        }
        catch (DatabaseException e) {
            throw new ServiceException(e.getMessage(), e);
        }
    }

    @Override
    public void updateProjectDetails(ProjectRecord projectRecord) throws ServiceException {
        try {
            this.dao.updateProjectDetails(projectRecord);
        }
        catch (DatabaseException e) {
            throw new ServiceException(e.getMessage(), e);
        }
    }

    @Override
    public void deleteProjectDetails(List<Integer> projectIds) throws ServiceException {
        try {
            this.dao.deleteProjectDetails(projectIds);
        }
        catch (DatabaseException e) {
            throw new ServiceException(e.getMessage(), e);
        }
    }

    @Override
    public int addUnitDetails(UnitPricingAndPaymentDetails unitPricingAndPaymentDetails) throws ServiceException, BusinessException {
        try {
            return this.dao.addUnitDetails(unitPricingAndPaymentDetails);
        }
        catch (DatabaseException e) {
            throw new ServiceException(e.getMessage(), e);
        }
    }

    @Override
    public void updateUnitDetails(UnitPricingAndPaymentDetails unitPricingAndPaymentDetails) throws ServiceException {
        try {
            this.dao.updateUnitDetails(unitPricingAndPaymentDetails);
        }
        catch (DatabaseException e) {
            throw new ServiceException(e.getMessage(), e);
        }
    }

    @Override
    public void deleteUnitDetails(int unitId) throws ServiceException {
        try {
            this.dao.deleteUnitDetails(unitId);
        }
        catch (DatabaseException e) {
            throw new ServiceException(e.getMessage(), e);
        }
    }

    @Override
    public List<UnitPricingAndPaymentDetails> loadAllUnitDetailsByProjectId(int projectId) throws ServiceException {
        try {
            return this.dao.loadAllUnitDetailsByProjectId(projectId);
        }
        catch (DatabaseException e) {
            throw new ServiceException(e.getMessage(), e);
        }
    }

    @Override
    public UnitPricingAndPaymentDetails loadUnitDetails(int unitId) throws ServiceException {
        try {
            return this.dao.loadUnitDetails(unitId);
        }
        catch (DatabaseException e) {
            throw new ServiceException(e.getMessage(), e);
        }
    }

    @Override
    public void addAmenities(AmenitiesRecord amenitiesRecord) throws ServiceException {
        try {
            this.dao.addAmenities(amenitiesRecord);
        }
        catch (DatabaseException e) {
            throw new ServiceException(e.getMessage(), e);
        }
    }

    @Override
    public void deleteAmenities(AmenitiesRecord amenitiesRecord) throws ServiceException {
        try {
            this.dao.deleteAmenities(amenitiesRecord);
        }
        catch (DatabaseException e) {
            throw new ServiceException(e.getMessage(), e);
        }
    }

    @Override
    public List<AmenitiesRecord> loadAllAmenities(int projectId) throws ServiceException {
        try {
            return this.dao.loadAllAmenities(projectId);
        }
        catch (DatabaseException e) {
            throw new ServiceException(e.getMessage(), e);
        }
    }

    @Override
    public void addAdditionalDetails(ProjectAdditionalDetails projectAdditionalDetails) throws ServiceException {
        try {
            this.dao.addAdditionalDetails(projectAdditionalDetails);
        }
        catch (DatabaseException e) {
            throw new ServiceException(e.getMessage(), e);
        }
    }

    @Override
    public void deleteAdditionalDetails(ProjectAdditionalDetails projectAdditionalDetails) throws ServiceException {
        try {
            this.dao.deleteAdditionalDetails(projectAdditionalDetails);
        }
        catch (DatabaseException e) {
            throw new ServiceException(e.getMessage(), e);
        }
    }

    @Override
    public List<ProjectAdditionalDetails> loadAllAdditionalDetails(int projectId) throws ServiceException {
        try {
            return this.dao.loadAllAdditionalDetails(projectId);
        }
        catch (DatabaseException e) {
            throw new ServiceException(e.getMessage(), e);
        }
    }

    @Override
    public Map<Integer, String> loadBuilderNames() throws ServiceException {
        try {
            return this.dao.loadBuilderNames();
        }
        catch (DatabaseException e) {
            throw new ServiceException(e.getMessage());
        }
    }

    @Override
    public Map<Integer, String> loadArchitectName() throws ServiceException {
        try {
            return this.dao.loadArchitectName();
        }
        catch (DatabaseException e) {
            throw new ServiceException(e.getMessage());
        }
    }
}

