/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.service.project;

import com.arun.bhardwaj.dao.project.ProjectCategoryDao;
import com.arun.bhardwaj.dao.project.ProjectCategoryDaoImpl;
import com.arun.bhardwaj.exceptions.BusinessException;
import com.arun.bhardwaj.exceptions.DatabaseException;
import com.arun.bhardwaj.exceptions.ServiceException;
import com.arun.bhardwaj.service.project.ProjectCategoryService;
import java.util.Map;

public class ProjectCategoryServiceImpl
implements ProjectCategoryService {
    private ProjectCategoryDao dao = new ProjectCategoryDaoImpl();

    @Override
    public void saveCategory(String categoryName) throws ServiceException, BusinessException {
        try {
            if (this.dao.isCategoryExists(categoryName)) {
                throw new BusinessException(categoryName + " already exists");
            }
            this.dao.saveCategory(categoryName);
        }
        catch (DatabaseException e) {
            throw new ServiceException("save project category", e);
        }
    }

    @Override
    public void updateCategory(String categoryName, int selectedGroupId) throws ServiceException, BusinessException {
        try {
            if (this.dao.isCategoryExists(categoryName)) {
                throw new BusinessException(categoryName + " already exists");
            }
            this.dao.updateCategory(categoryName, selectedGroupId);
        }
        catch (DatabaseException e) {
            throw new ServiceException("update project category", e);
        }
    }

    @Override
    public void deleteCategory(int selectedGroupId) throws ServiceException {
        try {
            this.dao.deleteCategory(selectedGroupId);
        }
        catch (DatabaseException e) {
            throw new ServiceException("delete project category", e);
        }
    }

    @Override
    public Map<Integer, String> loadGroups() throws ServiceException {
        try {
            return this.dao.loadGroups();
        }
        catch (DatabaseException e) {
            throw new ServiceException("load  project categories", e);
        }
    }
}

