/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.service.property;

import com.arun.bhardwaj.dao.property.PropertyCategoryDao;
import com.arun.bhardwaj.dao.property.PropertyCategoryDaoImpl;
import com.arun.bhardwaj.exceptions.BusinessException;
import com.arun.bhardwaj.exceptions.DatabaseException;
import com.arun.bhardwaj.exceptions.ServiceException;
import com.arun.bhardwaj.service.property.PropertyCategoryService;
import java.util.Map;

public class PropertyCategoryServiceImpl
implements PropertyCategoryService {
    private PropertyCategoryDao dao = new PropertyCategoryDaoImpl();

    @Override
    public void saveCategory(String categoryName) throws ServiceException, BusinessException {
        try {
            if (this.dao.isCategoryExists(categoryName)) {
                throw new BusinessException(categoryName + " already exists");
            }
            this.dao.saveCategory(categoryName);
        }
        catch (DatabaseException e) {
            throw new ServiceException("save property category", e);
        }
    }

    @Override
    public void updateCategory(String categoryName, int propertyGroupId) throws ServiceException, BusinessException {
        try {
            if (this.dao.isCategoryExists(categoryName)) {
                throw new BusinessException(categoryName + " already exists");
            }
            this.dao.updateCategory(categoryName, propertyGroupId);
        }
        catch (DatabaseException e) {
            throw new ServiceException("update property category", e);
        }
    }

    @Override
    public void deleteCategory(int propertyGroupId) throws ServiceException {
        try {
            this.dao.deleteCategory(propertyGroupId);
        }
        catch (DatabaseException e) {
            throw new ServiceException("delete property category", e);
        }
    }

    @Override
    public Map<Integer, String> loadGroups() throws ServiceException {
        try {
            return this.dao.loadGroups();
        }
        catch (DatabaseException e) {
            throw new ServiceException("load property group", e);
        }
    }
}

