/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.service.property;

import com.arun.bhardwaj.dao.property.PropertyDao;
import com.arun.bhardwaj.dao.property.PropertyDaoImpl;
import com.arun.bhardwaj.model.property.PropertyDetails;
import com.arun.bhardwaj.model.property.PropertyFilterCriteria;
import com.arun.bhardwaj.model.property.PropertyForRentDetails;
import com.arun.bhardwaj.model.property.PropertyOnRentDetails;
import com.arun.bhardwaj.model.property.PropertyRecord;
import com.arun.bhardwaj.model.property.PropertySearchCriteria;
import com.arun.bhardwaj.model.property.PropertyStatistics;
import com.arun.bhardwaj.service.property.PropertyService;
import com.arun.bhardwaj.utility.AppUtility;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.List;

public class PropertyServiceImpl
implements PropertyService {
    private PropertyDao dao = new PropertyDaoImpl();

    @Override
    public List<PropertyRecord> loadRecords(String groupName, PropertySearchCriteria criteria, PropertyFilterCriteria filterCriteria, int page, int pageSize) throws Exception {
        return this.dao.loadRecords(groupName, criteria, filterCriteria, page, pageSize);
    }

    @Override
    public PropertyDetails fetchPropertyDetails(int leaseId) throws Exception {
        return this.dao.fetchPropertyDetails(leaseId);
    }

    @Override
    public PropertyRecord fetchPropertyRecord(int leaseId) throws Exception {
        return this.dao.fetchPropertyRecord(leaseId);
    }

    @Override
    public PropertyForRentDetails fetchPropertyDetailsForRent(int leasePropertyId) throws Exception {
        return this.dao.fetchPropertyDetailsForRent(leasePropertyId);
    }

    @Override
    public PropertyOnRentDetails fetchPropertyDetailsOnRent(int propertyId) throws Exception {
        return this.dao.fetchPropertyDetailsOnRent(propertyId);
    }

    @Override
    public List<PropertyStatistics> fetchPropertyStatistics() throws Exception {
        return this.dao.fetchPropertyStatistics();
    }

    @Override
    public String generateRenewalStatus() throws Exception {
        StringBuilder status = new StringBuilder();
        List<String> endDates = this.dao.fetchEndDatesForOnRentProperty();
        int pendingForRenewalCount = 0;
        int contractExpiredCount = 0;
        for (String endDate : endDates) {
            LocalDate endDateObj = AppUtility.convertStringToDate(endDate);
            long days = ChronoUnit.DAYS.between(LocalDate.now(), endDateObj);
            if (days <= 45L && days >= 0L) {
                ++pendingForRenewalCount;
                continue;
            }
            if (days >= 0L) continue;
            ++contractExpiredCount;
        }
        if (pendingForRenewalCount > 0) {
            status.append("PENDING FOR RENEWAL :").append(pendingForRenewalCount);
        }
        if (contractExpiredCount > 0) {
            status.append("  ");
            status.append("CONTRACT EXPIRED :").append(contractExpiredCount);
        }
        return status.toString();
    }

    @Override
    public int fetchPropertyCountByContactId(int contactId) throws Exception {
        return this.dao.fetchPropertyCountByContactId(contactId);
    }
}

