/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.utility;

import com.arun.bhardwaj.exceptions.ServiceException;
import com.arun.bhardwaj.model.UserDetails;
import com.arun.bhardwaj.service.settings.UserDetailsServiceImpl;
import com.arun.bhardwaj.utility.UserCache;
import com.arun.bhardwaj.view.LoginView;
import com.arun.bhardwaj.view.common.ErrorDialog;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class AppUtility {
    private static final String datePattern = "d-MMM-yyyy";

    public static JLabel linkify(final String text, String URL2, String toolTip) {
        URI temp = null;
        try {
            temp = new URI(URL2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        final URI uri = temp;
        final JLabel link = new JLabel();
        link.setText("<HTML><FONT color=\"#000099\">" + text + "</FONT></HTML>");
        if (!toolTip.equals("")) {
            link.setToolTipText(toolTip);
        }
        link.setCursor(new Cursor(12));
        link.addMouseListener(new MouseListener(){

            @Override
            public void mouseExited(MouseEvent arg0) {
                link.setText("<HTML><FONT color=\"#000099\">" + text + "</FONT></HTML>");
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
                link.setText("<HTML><FONT color=\"#000099\"><U>" + text + "</U></FONT></HTML>");
            }

            @Override
            public void mouseClicked(MouseEvent arg0) {
                if (Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().browse(uri);
                    }
                    catch (Exception e) {
                        new ErrorDialog(e, "mouseClicked");
                    }
                } else {
                    JOptionPane pane = new JOptionPane("Could not open link.");
                    JDialog dialog = pane.createDialog(new JFrame(), "");
                    dialog.setVisible(true);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        return link;
    }

    public static JLabel linkify(final ImageIcon text, String URL2, String toolTip) {
        URI temp = null;
        try {
            temp = new URI(URL2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        final URI uri = temp;
        final JLabel link = new JLabel();
        link.setIcon(text);
        if (!toolTip.equals("")) {
            link.setToolTipText(toolTip);
        }
        link.setCursor(new Cursor(12));
        link.addMouseListener(new MouseListener(){

            @Override
            public void mouseExited(MouseEvent arg0) {
                link.setIcon(text);
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
                link.setIcon(text);
            }

            @Override
            public void mouseClicked(MouseEvent arg0) {
                if (Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().browse(uri);
                    }
                    catch (Exception e) {
                        new ErrorDialog(e, "mouseClicked");
                    }
                } else {
                    JOptionPane pane = new JOptionPane("Could not open link.");
                    JDialog dialog = pane.createDialog(new JFrame(), "");
                    dialog.setVisible(true);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        return link;
    }

    public static boolean isValidEmail(String email) {
        String emailRegex = "^[a-zA-Z0-9_+&*-]+(?:\\.[a-zA-Z0-9_+&*-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,7}$";
        Pattern pat = Pattern.compile(emailRegex);
        if (email == null) {
            return false;
        }
        return pat.matcher(email).matches();
    }

    public static String convertDatetoString(LocalDate date) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(datePattern);
        return formatter.format(date);
    }

    public static LocalDate convertStringToDate(String dateStr) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(datePattern);
        LocalDate localDate = LocalDate.parse(dateStr, formatter);
        return localDate;
    }

    public static String getCurrentDateInString() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(datePattern);
        return formatter.format(LocalDate.now());
    }

    public static boolean isValidatePhoneNo(String strPhoneNo) {
        String patterns = "^[0-9+\\-]+$";
        Pattern pattern = Pattern.compile(patterns);
        Matcher matcher = pattern.matcher(strPhoneNo);
        return matcher.matches();
    }

    public static boolean isValidNumber(String strNumber) {
        String patterns = "[0-9]+";
        Pattern pattern = Pattern.compile(patterns);
        Matcher matcher = pattern.matcher(strNumber);
        return matcher.matches();
    }

    public static boolean isValidText(String value) {
        String patterns = "^[A-Za-z .]+$";
        Pattern pattern = Pattern.compile(patterns);
        Matcher matcher = pattern.matcher(value);
        return matcher.matches();
    }

    public static boolean isValidURL(String url) throws MalformedURLException, URISyntaxException {
        try {
            new URL(url).toURI();
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public static void tableZoomInZoomOut(boolean zoomIn, JTable table) {
        Font oldFont = table.getFont();
        float size = oldFont.getSize() + (zoomIn ? 1 : -1);
        table.setFont(oldFont.deriveFont(size));
        for (int row = 0; row < table.getRowCount(); ++row) {
            int rowHeight = table.getRowHeight(row);
            for (int col = 0; col < table.getColumnCount(); ++col) {
                Component comp = table.prepareRenderer(table.getCellRenderer(row, col), row, col);
                rowHeight = comp.getPreferredSize().height;
            }
            table.setRowHeight(row, rowHeight);
        }
    }

    public static char[] generateOTP(int length) {
        String numbers = "0123456789";
        Random random = new Random();
        char[] otp = new char[length];
        IntStream.range(0, length).forEach(index -> {
            otp[index] = numbers.charAt(random.nextInt(numbers.length()));
        });
        return otp;
    }

    public static String generateTransactionId() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString();
    }

    public static String formatTime(int minutes, int seconds) {
        DecimalFormat df = new DecimalFormat("00");
        return df.format(minutes) + ":" + df.format(seconds);
    }

    public static boolean validateString(String value) {
        return value == null || value.isEmpty();
    }

    public static void setDialogLocationInCenter(JDialog dialog) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int centerX = (int)(screenSize.getWidth() - (double)dialog.getWidth()) / 2;
        int centerY = (int)(screenSize.getHeight() - (double)dialog.getHeight()) / 2;
        dialog.setLocation(centerX, centerY);
    }

    public static void openWebPage(String url) {
        try {
            URI uri = new URI(url);
            Desktop.getDesktop().browse(uri);
        }
        catch (IOException | URISyntaxException e) {
            JOptionPane.showMessageDialog(LoginView.frame, e.getMessage());
        }
    }

    public static String getEncodedText(String value) {
        return URLEncoder.encode(value, StandardCharsets.UTF_8);
    }

    public static String getFormattedCurrency(String value) {
        if (!AppUtility.isValidNumber(value)) {
            return "";
        }
        double amount = Double.parseDouble(value);
        NumberFormat currencyFormatter = NumberFormat.getCurrencyInstance(new Locale("en", "IN"));
        return currencyFormatter.format(amount).split("\\.")[0];
    }

    public static String removeCurrencyAndCommas(String input) {
        return input.replaceAll("[\u20b9,]", "");
    }

    public static boolean isInternetConnected() {
        try {
            InetAddress.getByName("www.shreetechnoworld.com").isReachable(2000);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void addBorderToPanel(String title, JPanel panel) {
        TitledBorder border = BorderFactory.createTitledBorder(title);
        panel.setBorder(BorderFactory.createCompoundBorder(border, new EmptyBorder(10, 10, 10, 10)));
    }

    public static void downloadAndReplaceJar() throws IOException {
        AppUtility.createBackup();
        String jarUrl = "https://www.shreetechnoworld.com/resources/file/real-estate-solution.jar";
        String jarFileName = "real-estate-solution.jar";
        try (BufferedInputStream in = new BufferedInputStream(new URL(jarUrl).openStream());
             FileOutputStream fileOutputStream = new FileOutputStream(jarFileName);){
            int bytesRead;
            byte[] dataBuffer = new byte[1024];
            while ((bytesRead = in.read(dataBuffer, 0, 1024)) != -1) {
                fileOutputStream.write(dataBuffer, 0, bytesRead);
            }
            JOptionPane.showMessageDialog(LoginView.frame, "Update successful. Please restart the application.", "Update Complete", 1);
            System.exit(0);
        }
        catch (Exception e) {
            new ErrorDialog(e, "downloadAndReplaceJar");
        }
    }

    public static void createBackup() throws IOException {
        Path jarFilePath = Paths.get("real-estate-solution.jar", new String[0]);
        Path otherFilePath = Paths.get("real-estate-solution-database.db", new String[0]);
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MMM-yyyy_HHmmss");
        String backupFolderName = "backup_" + dateFormat.format(new Date());
        Path backupFolderPath = Paths.get(backupFolderName, new String[0]);
        Files.createDirectory(backupFolderPath, new FileAttribute[0]);
        Files.copy(jarFilePath, backupFolderPath.resolve(jarFilePath.getFileName()), StandardCopyOption.REPLACE_EXISTING);
        Files.copy(otherFilePath, backupFolderPath.resolve(otherFilePath.getFileName()), StandardCopyOption.REPLACE_EXISTING);
    }

    public static boolean checkOllamaRunningStatus() {
        String urlString = "http://localhost:11434";
        try {
            URL url = new URL(urlString);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.connect();
            int responseCode = connection.getResponseCode();
            return responseCode == 200;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static void validateUser() throws ServiceException {
        UserDetails userDetails = new UserDetailsServiceImpl().loadUserDetails();
        if (!userDetails.clientId().equals(UserCache.clientId)) {
            JOptionPane.showMessageDialog(LoginView.frame, "Unauthorized database access detected due to file modification; please restore the original file or contact support for assistance.");
            System.exit(0);
        }
    }

    public static String capitalizeFirstLetter(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }
}

