/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.utility;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class AutoResize
extends JPanel {
    BufferedImage image;

    public AutoResize(BufferedImage image) {
        this.image = image;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        int w = this.getWidth();
        int h = this.getHeight();
        int iw = this.image.getWidth();
        int ih = this.image.getHeight();
        double xScale = (double)w / (double)iw;
        double yScale = (double)h / (double)ih;
        double scale = Math.min(xScale, yScale);
        int width = (int)(scale * (double)iw);
        int height = (int)(scale * (double)ih);
        int x = (w - width) / 2;
        int y = (h - height) / 2;
        g2.drawImage(this.image, x, y, width, height, this);
    }

    public static BufferedImage resize(BufferedImage image, int width, int height) {
        BufferedImage bi = new BufferedImage(width, height, 3);
        Graphics2D g2d = bi.createGraphics();
        g2d.addRenderingHints(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
        g2d.drawImage(image, 0, 0, width, height, null);
        g2d.dispose();
        return bi;
    }
}

