/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.utility;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;

public class UPIQRCodeGenerator {
    public static BufferedImage generateQRCode(String upiLink) throws WriterException, IOException {
        int width = 300;
        int height = 300;
        HashMap<EncodeHintType, String> hints = new HashMap<EncodeHintType, String>();
        hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        BitMatrix bitMatrix = new MultiFormatWriter().encode(upiLink, BarcodeFormat.QR_CODE, width, height, hints);
        BufferedImage qrImage = new BufferedImage(width, height, 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                qrImage.setRGB(x, y, bitMatrix.get(x, y) ? -16777216 : -1);
            }
        }
        return qrImage;
    }
}

