/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.utility;

import com.arun.bhardwaj.exceptions.ServiceException;
import com.arun.bhardwaj.model.UserDetails;
import com.arun.bhardwaj.service.LoginServiceImpl;
import com.arun.bhardwaj.utility.AppUtility;
import java.io.InputStream;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;

public class UserCache {
    static String userSignature;
    static String userName;
    static String clientId;
    static InputStream inputStreamLogoImage;
    static String userStatusDetails;
    static String registeredEmailId;
    static long validity;
    static String softwareVersion;

    private UserCache() {
    }

    public static void loadUserDetails() throws ServiceException {
        UserDetails userDetails = new LoginServiceImpl().fetchUserDetails();
        userSignature = "\n\nBest regards , \n" + userDetails.userName() + "\n" + userDetails.address() + "\n" + userDetails.mobileNo() + "\n" + userDetails.email();
        userName = userDetails.userName();
        clientId = userDetails.clientId();
        validity = LocalDate.now().until(AppUtility.convertStringToDate(userDetails.effectiveTill()), ChronoUnit.DAYS);
        inputStreamLogoImage = userDetails.logo();
        userStatusDetails = userDetails.userName() + " | " + userDetails.address() + " | Membership end date : " + userDetails.effectiveTill();
        registeredEmailId = userDetails.email();
        softwareVersion = userDetails.softwareVersion();
    }

    public static String getUserName() {
        return userName;
    }

    public static String getClientId() {
        return clientId;
    }

    public static InputStream getInputStreamLogoImage() {
        return inputStreamLogoImage;
    }

    public static String getUserStatusDetails() {
        return userStatusDetails;
    }

    public static String getRegisteredEmailId() {
        return registeredEmailId;
    }

    public static long getValidity() {
        return validity;
    }

    public static String getUserSignature() {
        return userSignature;
    }

    public static String getSoftwareVersion() {
        return softwareVersion;
    }
}

