/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.view;

import com.arun.bhardwaj.controller.ForgetPasswordController;
import com.arun.bhardwaj.factory.UIFactory;
import com.arun.bhardwaj.view.LoginView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.io.IOException;
import java.util.Objects;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class ForgetPasswordView
extends JPanel {
    private final JPanel basePanel;
    private LoginView loginView;
    private final JLabel headingLabel;
    private final JTextField emailOtpField;
    private final JPasswordField passwordField;
    private final JButton changePasswordButton;
    private final JButton signInButton;
    private final JButton sendOtpButton;
    private GridBagConstraints gbc;
    private JLabel messageToUser;

    public ForgetPasswordView(LoginView loginView) {
        this.loginView = loginView;
        this.headingLabel = new JLabel("Forget password ");
        this.headingLabel.setFont(this.headingLabel.getFont().deriveFont(18.0f));
        this.headingLabel.setForeground(new Color(63, 151, 255, 255));
        this.basePanel = new JPanel(){
            private Image backgroundImage;
            {
                try {
                    this.backgroundImage = ImageIO.read(Objects.requireNonNull(this.getClass().getResource("/pictures/login-background.jpg")));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (this.backgroundImage != null) {
                    g.drawImage(this.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
                }
            }
        };
        this.basePanel.setLayout(new GridBagLayout());
        this.gbc = new GridBagConstraints();
        this.gbc.insets = new Insets(2, 5, 2, 5);
        this.emailOtpField = new JTextField(10);
        this.passwordField = new JPasswordField(20);
        this.changePasswordButton = UIFactory.createCustomButton("Change Password", "primary");
        this.signInButton = UIFactory.createCustomButton("SignIn", "success");
        this.sendOtpButton = UIFactory.createCustomButton("Send OTP", "success");
        this.messageToUser = new JLabel("");
        new ForgetPasswordController(this);
        this.setLayout();
    }

    private void setLayout() {
        this.gbc.gridwidth = 2;
        this.gbc.anchor = 10;
        this.addFormField(this.headingLabel, 1);
        this.gbc.anchor = 17;
        this.addFormField(this.messageToUser, 2);
        this.gbc.gridwidth = 1;
        this.addFormField(new JLabel("<html>Email OTP <span style='color: red;'>*</html>"), 3);
        this.addFormField(this.emailOtpField, 4);
        this.gbc.gridx = 1;
        this.gbc.gridy = 4;
        this.basePanel.add((Component)this.sendOtpButton, this.gbc);
        this.gbc.gridwidth = 2;
        this.addFormField(new JLabel("<html>Password<span style='color: red;'>*</html>"), 5);
        this.addFormField(this.passwordField, 6);
        this.addFormField(this.changePasswordButton, 7);
        this.addFormField(this.signInButton, 8);
    }

    private void addFormField(JComponent component, int row) {
        this.gbc.gridx = 0;
        this.gbc.gridy = row;
        this.basePanel.add((Component)component, this.gbc);
    }

    public JPanel getBasePanel() {
        return this.basePanel;
    }

    public JTextField getEmailOtpField() {
        return this.emailOtpField;
    }

    public JPasswordField getPasswordField() {
        return this.passwordField;
    }

    public JButton getChangePasswordButton() {
        return this.changePasswordButton;
    }

    public JButton getSignInButton() {
        return this.signInButton;
    }

    public LoginView getLoginView() {
        return this.loginView;
    }

    public JButton getSendOtpButton() {
        return this.sendOtpButton;
    }

    public JLabel getMessageToUser() {
        return this.messageToUser;
    }
}

