/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.view;

import com.arun.bhardwaj.controller.InnerPanelController;
import com.arun.bhardwaj.factory.GradientPanel;
import com.arun.bhardwaj.factory.UIFactory;
import com.arun.bhardwaj.view.contact.ContactView;
import com.arun.bhardwaj.view.enquiry.EnquiryView;
import com.arun.bhardwaj.view.project.ProjectDetailsView;
import com.arun.bhardwaj.view.property.PropertyView;
import com.arun.bhardwaj.view.settings.SettingsView;
import java.awt.BorderLayout;
import java.awt.ComponentOrientation;
import java.util.Objects;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;

public class InnerPanelView
extends GradientPanel {
    private final JToolBar aiToolBar = UIFactory.createGradientToolBar();
    private final JTabbedPane mainTabs;
    private final ContactView contactView;
    private final PropertyView propertyView;
    private final SettingsView settingsView;
    private final EnquiryView enquiryView;
    private final ProjectDetailsView projectDetailsView;
    private JButton generateContentBtn;
    private JButton downloadOllamaBtn;

    public InnerPanelView() {
        this.aiToolBar.setFloatable(false);
        this.aiToolBar.setOrientation(1);
        this.generateContentBtn = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/generate.png"))));
        this.downloadOllamaBtn = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/download-s.png"))));
        this.mainTabs = new JTabbedPane();
        this.mainTabs.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        this.contactView = new ContactView();
        this.propertyView = new PropertyView();
        this.settingsView = new SettingsView();
        this.enquiryView = new EnquiryView();
        this.projectDetailsView = new ProjectDetailsView();
        this.setLayout();
        new InnerPanelController(this);
    }

    public void setLayout() {
        this.setLayout(new BorderLayout());
        this.add("West", this.aiToolBar);
        this.aiToolBar.add(new JLabel(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/AI.png")))));
        this.aiToolBar.addSeparator();
        this.aiToolBar.add(this.generateContentBtn);
        this.aiToolBar.addSeparator();
        this.aiToolBar.add(this.downloadOllamaBtn);
        this.add(this.mainTabs);
        this.mainTabs.addTab("Project Navigator", new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/property.png"))), this.projectDetailsView, "Manage projects");
        this.mainTabs.addTab("Property Management", new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/property.png"))), this.propertyView, "Manage properties");
        this.mainTabs.addTab("Enquiry Management", new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/enquiry.png"))), this.enquiryView, "Manage Enquiry");
        this.mainTabs.addTab("Contact Management", new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/contacts.png"))), this.contactView, "Manage contacts");
        this.mainTabs.addTab("Settings", new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/settings.png"))), this.settingsView);
        this.mainTabs.setSelectedIndex(0);
    }

    public PropertyView getPropertyView() {
        return this.propertyView;
    }

    public JTabbedPane getMainTabs() {
        return this.mainTabs;
    }

    public ContactView getContactView() {
        return this.contactView;
    }

    public SettingsView getSettingsView() {
        return this.settingsView;
    }

    public EnquiryView getEnquiryView() {
        return this.enquiryView;
    }

    public JButton getGenerateContentBtn() {
        return this.generateContentBtn;
    }

    public JButton getDownloadOllamaBtn() {
        return this.downloadOllamaBtn;
    }

    public ProjectDetailsView getProjectDetailsView() {
        return this.projectDetailsView;
    }
}

