/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.view;

import com.arun.bhardwaj.controller.LoginController;
import com.arun.bhardwaj.factory.UIFactory;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.view.ForgetPasswordView;
import com.arun.bhardwaj.view.RenewalView;
import com.arun.bhardwaj.view.SignInView;
import com.arun.bhardwaj.view.SignUpView;
import com.arun.bhardwaj.view.TextAnimation3D;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.io.IOException;
import java.util.Objects;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class LoginView {
    public static JFrame frame;
    private static JPanel basePanel;
    private static JPanel detailBasePanel;
    private static JPanel detailPanel;
    private static JPanel innerPanel;
    private final JPanel headerToolBar;
    public static JPanel clientLogo;
    private static JToolBar footerToolBar;
    private final JLabel currentDateLabel;
    private final CardLayout cardLayout;
    private final JPanel loginBasePanel;
    protected CardLayout loginCardLayout;
    public static String version;
    public static String AppName;
    private final JLabel userDetailsLabel;
    public static String password;
    public static String salt;
    private final JPanel footerToolBarPanel;
    private final JButton privacyPolicyButton;
    private final JButton exitButton;
    private final JButton renewalButton;
    public static boolean isBackgroundProcessActive;
    private LoginController controller;

    public LoginView() throws IOException {
        frame = new JFrame(AppName + " " + version);
        basePanel = new JPanel();
        detailBasePanel = new JPanel();
        detailPanel = new JPanel();
        innerPanel = new JPanel();
        innerPanel.setLayout(new BorderLayout());
        this.cardLayout = new CardLayout();
        this.headerToolBar = UIFactory.createGradientPanel();
        clientLogo = UIFactory.createGradientPanel();
        clientLogo.setPreferredSize(new Dimension(150, 100));
        clientLogo.setLayout(new BorderLayout());
        footerToolBar = UIFactory.createGradientToolBar();
        this.currentDateLabel = UIFactory.createGradientLabel(AppUtility.getCurrentDateInString(), 0);
        this.loginBasePanel = new JPanel();
        this.loginCardLayout = new CardLayout();
        this.userDetailsLabel = new JLabel("", 0);
        this.footerToolBarPanel = UIFactory.createGradientPanel();
        this.privacyPolicyButton = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/policy.png"))));
        this.exitButton = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/exit.png"))));
        this.renewalButton = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/buy.png"))));
        this.renewalButton.setVisible(false);
        this.setLayout();
        this.controller = new LoginController(this);
    }

    private void setLayout() throws IOException {
        frame.getContentPane().add(basePanel);
        basePanel.setLayout(new BorderLayout());
        basePanel.add("North", this.headerToolBar);
        this.headerToolBar.setLayout(new BorderLayout());
        this.headerToolBar.add("West", new JLabel(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/logo.jpg")))));
        this.headerToolBar.add("East", clientLogo);
        basePanel.add(detailBasePanel);
        detailBasePanel.setLayout(this.cardLayout);
        detailBasePanel.add("login", detailPanel);
        detailBasePanel.add("inner", innerPanel);
        detailPanel.setLayout(new BorderLayout());
        detailPanel.add(new TextAnimation3D());
        detailPanel.add("East", this.loginBasePanel);
        this.loginBasePanel.setLayout(this.loginCardLayout);
        this.loginBasePanel.add("signIn", new SignInView(this).getBasePanel());
        this.loginBasePanel.add("signUp", new SignUpView(this).getBasePanel());
        this.loginBasePanel.add("forgetPassword", new ForgetPasswordView(this).getBasePanel());
        this.loginBasePanel.add("renewalAccount", new RenewalView(this).getBasePanel());
        basePanel.add("South", footerToolBar);
        footerToolBar.setLayout(new BorderLayout());
        footerToolBar.add("West", this.currentDateLabel);
        footerToolBar.add(this.userDetailsLabel);
        footerToolBar.add("East", this.footerToolBarPanel);
        this.footerToolBarPanel.setLayout(new FlowLayout(2, 2, 2));
        this.footerToolBarPanel.add(this.renewalButton);
        this.footerToolBarPanel.add(this.privacyPolicyButton);
        this.footerToolBarPanel.add(this.exitButton);
        frame.setExtendedState(6);
        frame.setDefaultCloseOperation(3);
        frame.setMinimumSize(new Dimension(800, 600));
        frame.setDefaultCloseOperation(0);
        frame.setVisible(true);
    }

    public CardLayout getLoginCardLayout() {
        return this.loginCardLayout;
    }

    public JPanel getLoginBasePanel() {
        return this.loginBasePanel;
    }

    public JLabel getUserDetailsLabel() {
        return this.userDetailsLabel;
    }

    public JPanel getClientLogo() {
        return clientLogo;
    }

    public CardLayout getCardLayout() {
        return this.cardLayout;
    }

    public JPanel getDetailBasePanel() {
        return detailBasePanel;
    }

    public LoginController getController() {
        return this.controller;
    }

    public static JPanel getInnerPanel() {
        return innerPanel;
    }

    public JButton getPrivacyPolicyButton() {
        return this.privacyPolicyButton;
    }

    public JButton getExitButton() {
        return this.exitButton;
    }

    public JButton getRenewalButton() {
        return this.renewalButton;
    }

    static {
        version = "4.5";
        AppName = "Real Estate Solution";
    }
}

