/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.view;

import com.arun.bhardwaj.controller.RenewalViewController;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.view.LoginView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.io.IOException;
import java.util.Objects;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;

public class RenewalView
extends JPanel {
    private final JPanel basePanel;
    private final JLabel headingLabel;
    private final JLabel totalAmountLabel;
    private final JLabel nextEffectiveDateLabel;
    private final JLabel qrCodeLabel;
    private final JLabel errorLabel;
    private final JLabel timerLabel;
    private JComboBox<Integer> noOfMonths;
    private final JButton payButton;
    private final JButton validatePayButton;
    private GridBagConstraints gbc;
    private Timer timer;
    int minutes;
    int seconds;
    private final LoginView loginView;

    public RenewalView(LoginView loginView) {
        this.loginView = loginView;
        this.basePanel = new JPanel(){
            private Image backgroundImage;
            {
                try {
                    this.backgroundImage = ImageIO.read(Objects.requireNonNull(this.getClass().getResource("/pictures/login-background.jpg")));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (this.backgroundImage != null) {
                    g.drawImage(this.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
                }
            }
        };
        this.basePanel.setLayout(new GridBagLayout());
        this.gbc = new GridBagConstraints();
        this.gbc.insets = new Insets(5, 5, 5, 5);
        this.headingLabel = new JLabel("Extend software validity");
        this.headingLabel.setFont(this.headingLabel.getFont().deriveFont(18.0f));
        this.headingLabel.setForeground(new Color(63, 151, 255, 255));
        this.totalAmountLabel = new JLabel("Total amount :");
        this.nextEffectiveDateLabel = new JLabel("Next effective date :");
        this.totalAmountLabel.setVisible(false);
        this.nextEffectiveDateLabel.setVisible(false);
        this.qrCodeLabel = new JLabel("");
        this.errorLabel = new JLabel("");
        this.timerLabel = new JLabel(AppUtility.formatTime(this.getMinutes(), this.getSeconds()));
        this.timerLabel.setHorizontalAlignment(0);
        this.timerLabel.setFont(this.timerLabel.getFont().deriveFont(24.0f));
        this.timerLabel.setForeground(Color.DARK_GRAY);
        this.timerLabel.setVisible(false);
        Integer[] numbers = new Integer[]{0, 1, 3, 6, 12};
        this.noOfMonths = new JComboBox<Integer>(numbers);
        this.payButton = new JButton("Pay", new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/pay.png"))));
        this.payButton.setEnabled(false);
        this.validatePayButton = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/check.png"))));
        this.setLayout();
        new RenewalViewController(this);
    }

    private void setLayout() {
        this.gbc.anchor = 10;
        this.gbc.gridwidth = 3;
        this.addFormField(this.headingLabel, 1);
        this.gbc.anchor = 17;
        this.addFormField(this.errorLabel, 2);
        this.gbc.gridwidth = 1;
        this.addFormField(new JLabel("<html>Duration (in Months) :<span style='color: red;'>*</html>"), 3);
        this.gbc.gridx = 1;
        this.gbc.gridy = 3;
        this.basePanel.add(this.noOfMonths, this.gbc);
        this.gbc.gridx = 2;
        this.gbc.gridy = 3;
        this.basePanel.add((Component)this.payButton, this.gbc);
        this.gbc.gridx = 2;
        this.gbc.gridy = 3;
        this.basePanel.add((Component)this.validatePayButton, this.gbc);
        this.gbc.gridwidth = 3;
        this.addFormField(this.totalAmountLabel, 4);
        this.addFormField(this.nextEffectiveDateLabel, 5);
        this.gbc.anchor = 10;
        this.gbc.gridwidth = 3;
        this.addFormField(this.qrCodeLabel, 6);
        this.addFormField(this.timerLabel, 7);
        this.gbc.anchor = 17;
        this.addFormField(new JLabel("Contact Details"), 8);
        this.addFormField(AppUtility.linkify("support@shreetechnoworld.com", "mailto:support@shreetechnoworld.com", "Email"), 9);
        this.addFormField(AppUtility.linkify("8800776704", "https://wa.me/8800776704", "Click to start chat"), 10);
        this.addFormField(AppUtility.linkify("https://www.shreetechnoworld.com", "https://www.shreetechnoworld.com", "Go to website"), 11);
    }

    private void addFormField(JComponent component, int row) {
        this.gbc.gridx = 0;
        this.gbc.gridy = row;
        this.basePanel.add((Component)component, this.gbc);
    }

    public JPanel getBasePanel() {
        return this.basePanel;
    }

    public JComboBox<Integer> getNoOfMonths() {
        return this.noOfMonths;
    }

    public JButton getPayButton() {
        return this.payButton;
    }

    public JLabel getTotalAmountLabel() {
        return this.totalAmountLabel;
    }

    public JLabel getNextEffectiveDateLabel() {
        return this.nextEffectiveDateLabel;
    }

    public JLabel getQrCodeLabel() {
        return this.qrCodeLabel;
    }

    public JLabel getErrorLabel() {
        return this.errorLabel;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public void setMinutes(int minutes) {
        this.minutes = minutes;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public void setSeconds(int seconds) {
        this.seconds = seconds;
    }

    public JLabel getTimerLabel() {
        return this.timerLabel;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    public JButton getValidatePayButton() {
        return this.validatePayButton;
    }

    public LoginView getLoginView() {
        return this.loginView;
    }
}

