/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.view;

import com.arun.bhardwaj.controller.SignInController;
import com.arun.bhardwaj.factory.UIFactory;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.view.LoginView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.io.IOException;
import java.util.Objects;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class SignInView
extends JPanel {
    private final JPanel basePanel;
    private final JLabel headingLabel;
    private final JCheckBox isAdmin;
    private final JLabel userNameLabel;
    private final JTextField userNameField;
    private final JPasswordField passwordField;
    private final JButton signInButton;
    private final JButton forgetPasswordButton;
    private GridBagConstraints gbc;
    private LoginView loginView;

    public SignInView(LoginView loginView) throws IOException {
        this.loginView = loginView;
        this.basePanel = new JPanel(){
            private Image backgroundImage;
            {
                try {
                    this.backgroundImage = ImageIO.read(Objects.requireNonNull(this.getClass().getResource("/pictures/login-background.jpg")));
                }
                catch (IOException e) {
                    throw new IOException(e.getMessage());
                }
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (this.backgroundImage != null) {
                    g.drawImage(this.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
                }
            }
        };
        AppUtility.addBorderToPanel("", this.basePanel);
        this.basePanel.setLayout(new GridBagLayout());
        this.gbc = new GridBagConstraints();
        this.gbc.insets = new Insets(2, 5, 2, 5);
        this.headingLabel = new JLabel("Sign In ");
        this.headingLabel.setFont(this.headingLabel.getFont().deriveFont(18.0f));
        this.headingLabel.setForeground(new Color(63, 151, 255, 255));
        this.isAdmin = new JCheckBox("Admin", true);
        this.userNameLabel = new JLabel("<html>Username<span style='color: red;'>*</html>");
        this.userNameField = new JTextField(20);
        this.passwordField = new JPasswordField(20);
        this.userNameField.setVisible(false);
        this.signInButton = UIFactory.createCustomButton("Sign in", "success");
        this.forgetPasswordButton = UIFactory.createCustomButton("Forget Password ?", "primary");
        this.setLayout();
    }

    private void setLayout() {
        this.gbc.anchor = 10;
        this.addFormField(this.headingLabel, 1);
        this.gbc.anchor = 17;
        this.addFormField(this.isAdmin, 2);
        this.addFormField(this.userNameLabel, 3);
        this.addFormField(this.userNameField, 4);
        this.addFormField(new JLabel("<html>Password<span style='color: red;'>*</html>"), 5);
        this.addFormField(this.passwordField, 6);
        this.addFormField(this.signInButton, 7);
        this.addFormField(this.forgetPasswordButton, 8);
        new SignInController(this);
    }

    private void addFormField(JComponent component, int row) {
        this.gbc.gridx = 0;
        this.gbc.gridy = row;
        this.basePanel.add((Component)component, this.gbc);
    }

    public JPanel getBasePanel() {
        return this.basePanel;
    }

    public JTextField getUserNameField() {
        return this.userNameField;
    }

    public JPasswordField getPasswordField() {
        return this.passwordField;
    }

    public JButton getSignInButton() {
        return this.signInButton;
    }

    public JButton getForgetPasswordButton() {
        return this.forgetPasswordButton;
    }

    public JCheckBox getIsAdmin() {
        return this.isAdmin;
    }

    public JLabel getUserNameLabel() {
        return this.userNameLabel;
    }

    public LoginView getLoginView() {
        return this.loginView;
    }
}

