/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.view;

import com.arun.bhardwaj.controller.SignUpController;
import com.arun.bhardwaj.factory.UIFactory;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.view.LoginView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.io.IOException;
import java.util.Objects;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class SignUpView {
    private final JPanel basePanel;
    private final JPanel clientLogo;
    private final Container emailContainer;
    private final JLabel headingLabel;
    private final JTextField userNameField;
    private final JTextField mobileNoField;
    private final JTextField emailField;
    private final JTextField emailOTPField;
    private final JTextArea addressTextArea;
    private final JPasswordField passwordField;
    private final JButton signUpButton;
    private final JButton selectLogoButton;
    private final JButton deleteLogoButton;
    private final JButton sendOTPButton;
    private GridBagConstraints gbc;
    private LoginView loginView;

    public SignUpView(LoginView loginView) throws IOException {
        this.loginView = loginView;
        this.basePanel = new JPanel(){
            private Image backgroundImage;
            {
                try {
                    this.backgroundImage = ImageIO.read(Objects.requireNonNull(this.getClass().getResource("/pictures/login-background.jpg")));
                }
                catch (IOException e) {
                    throw new IOException(e.getMessage());
                }
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (this.backgroundImage != null) {
                    g.drawImage(this.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
                }
            }
        };
        AppUtility.addBorderToPanel("", this.basePanel);
        this.basePanel.setLayout(new GridBagLayout());
        this.gbc = new GridBagConstraints();
        this.gbc.insets = new Insets(2, 5, 2, 5);
        this.emailContainer = UIFactory.createGradientPanel();
        this.headingLabel = new JLabel(LoginView.AppName + " - account");
        this.headingLabel.setFont(this.headingLabel.getFont().deriveFont(18.0f));
        this.headingLabel.setForeground(new Color(63, 151, 255, 255));
        this.clientLogo = new JPanel();
        this.clientLogo.setPreferredSize(new Dimension(100, 100));
        this.clientLogo.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.clientLogo.setLayout(new BorderLayout());
        this.userNameField = new JTextField(15);
        this.addressTextArea = new JTextArea(4, 15);
        this.mobileNoField = new JTextField(15);
        this.passwordField = new JPasswordField(15);
        this.emailField = new JTextField(15);
        this.emailOTPField = new JTextField(4);
        this.signUpButton = UIFactory.createCustomButton("Register", "primary");
        this.selectLogoButton = UIFactory.createCustomButton("Add Logo", "primary");
        this.sendOTPButton = UIFactory.createCustomButton("Send OTP", "success");
        this.deleteLogoButton = UIFactory.createCustomButton("Delete Logo", "danger");
        this.deleteLogoButton.setVisible(false);
        this.setLayout();
        new SignUpController(this);
    }

    private void setLayout() {
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.gridwidth = 2;
        this.gbc.anchor = 10;
        this.basePanel.add((Component)this.headingLabel, this.gbc);
        this.gbc.gridy = 1;
        this.gbc.gridwidth = 1;
        this.gbc.anchor = 13;
        this.basePanel.add((Component)this.clientLogo, this.gbc);
        this.gbc.gridx = 1;
        this.gbc.anchor = 16;
        this.basePanel.add((Component)this.selectLogoButton, this.gbc);
        this.gbc.gridx = 1;
        this.gbc.anchor = 16;
        this.basePanel.add((Component)this.deleteLogoButton, this.gbc);
        this.addFormField("<html>Username<span style='color: red;'>*</html>", this.userNameField, 2);
        this.gbc.gridx = 0;
        this.gbc.gridy = 3;
        this.gbc.anchor = 768;
        this.basePanel.add((Component)new JLabel("<html>Address<span style='color: red;'>*</html>"), this.gbc);
        this.gbc.gridx = 1;
        this.gbc.anchor = 13;
        this.basePanel.add((Component)new JScrollPane(this.addressTextArea), this.gbc);
        this.addFormField("<html>Contact No<span style='color: red;'>*</html>", this.mobileNoField, 4);
        this.addFormField("<html>Password<span style='color: red;'>*</html>", this.passwordField, 5);
        this.addFormField("<html>Email<span style='color: red;'>*</html>", this.emailField, 7);
        this.gbc.gridx = 0;
        this.gbc.gridy = 8;
        this.gbc.anchor = 13;
        this.basePanel.add((Component)new JLabel("<html>Email OTP<span style='color: red;'>*</html>"), this.gbc);
        this.gbc.gridx = 1;
        this.gbc.anchor = 17;
        this.basePanel.add((Component)this.emailContainer, this.gbc);
        this.emailContainer.add(this.emailOTPField);
        this.emailContainer.add(this.sendOTPButton);
        this.gbc.gridx = 1;
        this.gbc.gridy = 9;
        this.gbc.anchor = 13;
        this.basePanel.add((Component)this.signUpButton, this.gbc);
    }

    private void addFormField(String label, JComponent field, int row) {
        this.gbc.gridx = 0;
        this.gbc.gridy = row;
        this.gbc.anchor = 13;
        this.basePanel.add((Component)new JLabel(label), this.gbc);
        this.gbc.gridx = 1;
        this.gbc.anchor = 17;
        this.basePanel.add((Component)field, this.gbc);
    }

    public JTextField getUserNameField() {
        return this.userNameField;
    }

    public JPasswordField getPasswordField() {
        return this.passwordField;
    }

    public JTextField getEmailField() {
        return this.emailField;
    }

    public JTextField getMobileNoField() {
        return this.mobileNoField;
    }

    public JPanel getBasePanel() {
        return this.basePanel;
    }

    public JButton getSignUpButton() {
        return this.signUpButton;
    }

    public JButton getSelectLogoButton() {
        return this.selectLogoButton;
    }

    public JPanel getClientLogo() {
        return this.clientLogo;
    }

    public JButton getDeleteLogoButton() {
        return this.deleteLogoButton;
    }

    public JTextField getEmailOTPField() {
        return this.emailOTPField;
    }

    public JTextArea getAddressTextArea() {
        return this.addressTextArea;
    }

    public JButton getSendOTPButton() {
        return this.sendOTPButton;
    }

    public LoginView getLoginView() {
        return this.loginView;
    }
}

