/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.view;

import com.arun.bhardwaj.utility.AppUtility;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import javax.swing.Timer;

public class TextAnimation3D
extends JPanel
implements ActionListener {
    private String currentQuote;
    private List<String> quotes;
    private int currentCharIndex = 0;
    private float fontSize = 24.0f;
    private final Timer animationTimer;
    private final Timer delayTimer;
    private final Random random;
    private Image backgroundImage;
    private boolean isDisplaying = true;
    private Map<String, List<String>> monthQuotes = new HashMap<String, List<String>>();

    public TextAnimation3D() throws IOException {
        this.loadQuotes();
        this.backgroundImage = ImageIO.read(Objects.requireNonNull(this.getClass().getResource("/pictures/background.jpg")));
        this.setForeground(Color.WHITE);
        this.setForeground(Color.WHITE);
        this.random = new Random();
        this.animationTimer = new Timer(100, this);
        this.delayTimer = new Timer(12000, e -> this.startNextQuote());
        this.animationTimer.start();
    }

    private void loadQuotes() {
        this.monthQuotes.put("January", Arrays.asList("In real estate, every new year brings new opportunities. Start strong, finish stronger!", "January sets the tone\u2014make every call, every visit count.", "New year, new listings, new deals\u2014let's make it a blockbuster year!"));
        this.monthQuotes.put("February", Arrays.asList("Real estate is not just about property, it\u2019s about people. Build relationships first.", "In February, let\u2019s spread the love\u2014of finding dream homes for every family.", "Trust is the foundation\u2014whether in love or in real estate deals."));
        this.monthQuotes.put("March", Arrays.asList("March isn't just about closing the financial year; it\u2019s about opening new possibilities.", "Invest in real estate before March 31\u2014because wealth is built with smart timing.", "The market is ripe\u2014March towards your goals!"));
        this.monthQuotes.put("April", Arrays.asList("April is for new resolutions\u2014list, market, and sell with passion.", "A new financial year means fresh opportunities\u2014make your move count.", "The Indian real estate market blooms in April\u2014be ready to reap the rewards."));
        this.monthQuotes.put("May", Arrays.asList("May brings heat\u2014and hot property deals! Close them before they cool off.", "In May, homes sell faster than mangoes in summer. Act quickly!", "Invest now; by next summer, you\u2019ll be collecting returns."));
        this.monthQuotes.put("June", Arrays.asList("June is the perfect time to review, recharge, and relaunch your real estate goals.", "Mid-year reminder: The best investment on earth is earth.", "Half the year gone, half to go\u2014make every property count."));
        this.monthQuotes.put("July", Arrays.asList("Monsoon brings new life, and new listings! Make it rain with deals.", "In July, every drop counts\u2014every lead, every follow-up.", "Just like monsoon clouds, property demand is building up\u2014seize it!"));
        this.monthQuotes.put("August", Arrays.asList("Celebrate freedom\u2014help your clients find their dream homes this August.", "True independence is financial freedom\u2014invest in real estate.", "In August, let\u2019s make homes a reality\u2014because every family deserves a roof of their own."));
        this.monthQuotes.put("September", Arrays.asList("Ganesh Chaturthi to Navratri\u2014bring prosperity with every property deal.", "September shines bright\u2014because home-buying season is here.", "Festivals bring joy; property investments bring wealth\u2014celebrate both."));
        this.monthQuotes.put("October", Arrays.asList("In October, let your clients light up their Diwali with a new home.", "Diwali isn\u2019t just about lights\u2014it\u2019s about new beginnings and new investments.", "Real estate and festivals\u2014both bring families together."));
        this.monthQuotes.put("November", Arrays.asList("In November, show gratitude\u2014by closing deals that make families happy.", "Real estate is not about selling houses; it\u2019s about fulfilling dreams.", "November is for harvesting\u2014deals you\u2019ve nurtured all year long."));
        this.monthQuotes.put("December", Arrays.asList("December isn\u2019t the end\u2014it\u2019s a chance to finish strong and start smarter.", "Celebrate success, learn from losses, and prepare for a bigger year ahead.", "The best closing gift is a happy client\u2014make every deal memorable."));
        String currentMonth = LocalDate.now().getMonth().name();
        currentMonth = AppUtility.capitalizeFirstLetter(currentMonth.toLowerCase());
        this.quotes = this.monthQuotes.getOrDefault(currentMonth, Collections.emptyList());
        this.currentQuote = this.quotes.get(0);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.drawImage(this.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Font font = new Font("SansSerif", 1, (int)this.fontSize);
        g2d.setFont(font);
        FontMetrics metrics = g2d.getFontMetrics(font);
        int x = (this.getWidth() - metrics.stringWidth(this.currentQuote.substring(0, this.currentCharIndex))) / 2;
        int y = this.getHeight() / 2 + metrics.getAscent() / 2;
        g2d.setColor(Color.DARK_GRAY);
        g2d.drawString(this.currentQuote.substring(0, this.currentCharIndex), x + 3, y + 3);
        g2d.setColor(Color.WHITE);
        g2d.drawString(this.currentQuote.substring(0, this.currentCharIndex), x, y);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.isDisplaying) {
            if (this.currentCharIndex < this.currentQuote.length()) {
                ++this.currentCharIndex;
            } else {
                this.isDisplaying = false;
                this.animationTimer.stop();
                this.delayTimer.start();
            }
        }
        this.repaint();
    }

    private void startNextQuote() {
        this.delayTimer.stop();
        this.currentQuote = this.quotes.get(this.random.nextInt(this.quotes.size()));
        this.currentCharIndex = 0;
        this.isDisplaying = true;
        this.animationTimer.start();
    }
}

