/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.view.ai;

import com.arun.bhardwaj.controller.ai.TalkWithAIController;
import com.arun.bhardwaj.factory.UIFactory;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.view.LoginView;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.Objects;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;

public class TalkWithAI {
    private final JDialog dio = new JDialog(LoginView.frame, "Talk with virtual assistant", false);
    private final JPanel basePanel = new JPanel();
    private final JPanel topToolBarBase = UIFactory.createGradientPanel();
    private final JPanel topToolBar = UIFactory.createGradientPanel();
    private final JPanel bottonToolBar = new JPanel();
    private final JPanel animatedEditorPanel;
    private final JTextField promtField;
    private final JButton downloadModelBtn;
    private final JButton generateTextBtn;
    private final JButton copyToClipboard;
    private final JButton newChatBtn;
    private final JTextPane editorPane = UIFactory.createGradientTextPane();
    private JComboBox<String> sourceDropdown;
    private JTextField urlField;

    public TalkWithAI() {
        this.editorPane.setEditable(false);
        this.animatedEditorPanel = new JPanel();
        this.downloadModelBtn = new JButton("Download Model");
        this.copyToClipboard = new JButton("Copy to clipboard", new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/copy.png"))));
        this.newChatBtn = new JButton("New", new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/new-clear.png"))));
        this.generateTextBtn = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/send.png"))));
        this.promtField = new JTextField("Ask your query here");
        String[] sources = new String[]{"Anything", "URL", "File"};
        this.sourceDropdown = new JComboBox<String>(sources);
        this.urlField = new JTextField();
        this.urlField.setEditable(false);
        this.setLayout();
        new TalkWithAIController(this);
    }

    private void setLayout() {
        this.dio.add(this.basePanel);
        this.basePanel.setLayout(new BorderLayout());
        this.basePanel.add("North", this.topToolBarBase);
        this.topToolBarBase.setLayout(new BorderLayout(2, 2));
        JPanel container = UIFactory.createGradientPanel();
        container.setLayout(new FlowLayout(0, 2, 2));
        container.add(new JLabel("Source"));
        container.add(this.sourceDropdown);
        this.topToolBarBase.add("West", container);
        this.topToolBarBase.add(this.urlField);
        this.topToolBarBase.add("East", this.topToolBar);
        this.topToolBar.setLayout(new FlowLayout(2, 2, 2));
        this.topToolBar.add(this.newChatBtn);
        this.topToolBar.add(this.downloadModelBtn);
        this.topToolBar.add(this.copyToClipboard);
        this.basePanel.add(new JScrollPane(this.editorPane));
        this.basePanel.add("South", this.bottonToolBar);
        this.bottonToolBar.setLayout(new BorderLayout(5, 5));
        this.bottonToolBar.add("West", this.animatedEditorPanel);
        this.bottonToolBar.add(this.promtField);
        this.bottonToolBar.add("East", this.generateTextBtn);
        this.dio.setMinimumSize(new Dimension(750, 450));
        AppUtility.setDialogLocationInCenter(this.dio);
    }

    public JDialog getDio() {
        return this.dio;
    }

    public JTextField getPromtField() {
        return this.promtField;
    }

    public JButton getDownloadModelBtn() {
        return this.downloadModelBtn;
    }

    public JTextPane getEditorPane() {
        return this.editorPane;
    }

    public JButton getGenerateTextBtn() {
        return this.generateTextBtn;
    }

    public JButton getCopyToClipboard() {
        return this.copyToClipboard;
    }

    public JPanel getAnimatedEditorPanel() {
        return this.animatedEditorPanel;
    }

    public JButton getNewChatBtn() {
        return this.newChatBtn;
    }

    public JComboBox<String> getSourceDropdown() {
        return this.sourceDropdown;
    }

    public JTextField getUrlField() {
        return this.urlField;
    }
}

