/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.view.common;

import com.arun.bhardwaj.controller.contact.ContactRecordController;
import com.arun.bhardwaj.controller.enquiry.EnquiryFollowUpController;
import com.arun.bhardwaj.controller.enquiry.EnquiryRecordController;
import com.arun.bhardwaj.controller.project.ManageProjectViewController;
import com.arun.bhardwaj.controller.property.PropertyForSellController;
import com.arun.bhardwaj.controller.property.PropertyOnRentController;
import com.arun.bhardwaj.controller.property.PropertyRecordController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CustomDatePicker {
    JDialog dio;
    private final JPanel calendarPanel;
    private final JPanel controlPanel;
    private final Calendar currentCalendar;
    private JComboBox<String> monthComboBox;
    private JComboBox<String> yearComboBox;
    private final Object object;
    private final String fieldName;
    List<String> MONTHS = Arrays.asList("Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec");

    private void setMonthAndYearInCurrentCalender(String existingDate) {
        if (!existingDate.isEmpty()) {
            this.currentCalendar.set(2, this.MONTHS.indexOf(existingDate.split("-")[1]));
            this.currentCalendar.set(1, Integer.parseInt(existingDate.split("-")[2]));
        }
    }

    public CustomDatePicker(Object object, String fieldName) {
        this.fieldName = fieldName;
        this.currentCalendar = Calendar.getInstance();
        if (object instanceof PropertyOnRentController) {
            if ("paymentDate".equals(fieldName)) {
                this.dio = new JDialog(((PropertyOnRentController)object).getView().getPaymentTrackerDio(), "Choose Date", true);
                String existingDate = ((PropertyOnRentController)object).getView().getPaymentDateTf().getText();
                this.setMonthAndYearInCurrentCalender(existingDate);
            } else if ("terminationDate".equals(fieldName)) {
                this.dio = new JDialog(((PropertyOnRentController)object).getView().getTerminationDialog(), "Choose Date", true);
                String existingDate = ((PropertyOnRentController)object).getView().getTerminationDateTf().getText();
                this.setMonthAndYearInCurrentCalender(existingDate);
            } else if ("depositDate".equals(fieldName)) {
                this.dio = new JDialog(((PropertyOnRentController)object).getView().getDio(), "Choose Date", true);
                String existingDate = ((PropertyOnRentController)object).getView().getDepositDateTf().getText();
                this.setMonthAndYearInCurrentCalender(existingDate);
            } else if ("depositRefundDate".equals(fieldName)) {
                this.dio = new JDialog(((PropertyOnRentController)object).getView().getDio(), "Choose Date", true);
                String existingDate = ((PropertyOnRentController)object).getView().getDepositRefundDate().getText();
                this.setMonthAndYearInCurrentCalender(existingDate);
            } else {
                this.dio = new JDialog(((PropertyOnRentController)object).getView().getDio(), "Choose Date", true);
                String existingDate = ((PropertyOnRentController)object).getView().getDateTf().getText();
                this.setMonthAndYearInCurrentCalender(existingDate);
            }
        } else if (object instanceof PropertyForSellController) {
            this.dio = new JDialog(((PropertyForSellController)object).getView().getDio(), "Choose Date", true);
            String existingDate = ((PropertyForSellController)object).getView().getDateTf().getText();
            this.setMonthAndYearInCurrentCalender(existingDate);
        } else if (object instanceof ContactRecordController) {
            this.dio = new JDialog(((ContactRecordController)object).getView().getDio(), "Choose Date", true);
            String existingDate = ((ContactRecordController)object).getView().getEventDioValueTf().getText();
            this.setMonthAndYearInCurrentCalender(existingDate);
        } else if (object instanceof PropertyRecordController) {
            this.dio = new JDialog(((PropertyRecordController)object).getView().getDio(), "Choose Date", true);
            if ("unavailableUntil".equals(fieldName)) {
                String existingDate = ((PropertyRecordController)object).getView().getUnAvailableUntilTf().getText();
                this.setMonthAndYearInCurrentCalender(existingDate);
            } else if ("dateTf".equals(fieldName)) {
                String existingDate = ((PropertyRecordController)object).getView().getDateTf().getText();
                this.setMonthAndYearInCurrentCalender(existingDate);
            }
        } else if (object instanceof EnquiryRecordController) {
            this.dio = new JDialog(((EnquiryRecordController)object).getView().getDio(), "Choose Date", true);
            String existingDate = ((EnquiryRecordController)object).getView().getDateTf().getText();
            this.setMonthAndYearInCurrentCalender(existingDate);
        } else if (object instanceof EnquiryFollowUpController) {
            this.dio = new JDialog(((EnquiryFollowUpController)object).getView().getEnquiryDio(), "Choose Date", true);
            String existingDate = null;
            existingDate = "date".equals(fieldName) ? ((EnquiryFollowUpController)object).getView().getEnquiryDateTf().getText() : ((EnquiryFollowUpController)object).getView().getEnquiryFollowUpDateTf().getText();
            this.setMonthAndYearInCurrentCalender(existingDate);
        } else if (object instanceof ManageProjectViewController) {
            this.dio = new JDialog(((ManageProjectViewController)object).getView().getDio(), "Choose Date", true);
            String existingDate = null;
            existingDate = "launchDate".equals(fieldName) ? ((ManageProjectViewController)object).getView().getLaunchDateTf().getText() : ((ManageProjectViewController)object).getView().getCompletionDateTf().getText();
            this.setMonthAndYearInCurrentCalender(existingDate);
        }
        this.object = object;
        this.calendarPanel = new JPanel(new BorderLayout());
        this.dio.add((Component)this.calendarPanel, "Center");
        this.controlPanel = new JPanel();
        this.dio.add((Component)this.controlPanel, "North");
        this.buildCalendar(this.currentCalendar);
        this.buildControlPanel();
        this.dio.setSize(400, 300);
    }

    private void buildControlPanel() {
        this.monthComboBox = new JComboBox<String>(new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"});
        this.monthComboBox.setSelectedIndex(this.currentCalendar.get(2));
        this.monthComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomDatePicker.this.currentCalendar.set(2, CustomDatePicker.this.monthComboBox.getSelectedIndex());
                CustomDatePicker.this.currentCalendar.set(1, Integer.parseInt((String)CustomDatePicker.this.yearComboBox.getSelectedItem()));
                CustomDatePicker.this.buildCalendar(CustomDatePicker.this.currentCalendar);
            }
        });
        this.yearComboBox = new JComboBox();
        Calendar calendar = Calendar.getInstance();
        int currentYear = calendar.get(1);
        for (int year = currentYear - 90; year <= currentYear + 15; ++year) {
            this.yearComboBox.addItem(String.valueOf(year));
        }
        int existingYear = this.currentCalendar.get(1);
        this.yearComboBox.setSelectedItem(String.valueOf(existingYear));
        this.yearComboBox.addActionListener(e -> {
            this.currentCalendar.set(2, this.monthComboBox.getSelectedIndex());
            this.currentCalendar.set(1, Integer.parseInt((String)this.yearComboBox.getSelectedItem()));
            this.buildCalendar(this.currentCalendar);
        });
        this.controlPanel.add(this.monthComboBox);
        this.controlPanel.add(this.yearComboBox);
    }

    private void buildCalendar(final Calendar calendar) {
        String[] daysOfWeek;
        calendar.set(5, 1);
        this.calendarPanel.removeAll();
        this.calendarPanel.revalidate();
        this.calendarPanel.repaint();
        SimpleDateFormat sdf = new SimpleDateFormat("MMMM yyyy");
        String monthYear = sdf.format(calendar.getTime());
        JLabel monthLabel = new JLabel(monthYear, 0);
        JPanel buttonPanel = new JPanel(new GridLayout(0, 7));
        for (String day : daysOfWeek = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"}) {
            buttonPanel.add(new JLabel(day, 0));
        }
        int firstDayOfMonth = calendar.get(7);
        int totalDaysInMonth = calendar.getActualMaximum(5);
        int day = 1;
        for (int i = 1; i <= 42; ++i) {
            JButton dayButton = new JButton("");
            if (i >= firstDayOfMonth && day <= totalDaysInMonth) {
                dayButton.setText(Integer.toString(day));
                final int selectedDay = day++;
                dayButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String strDate = selectedDay + "-" + new SimpleDateFormat("MMM").format(calendar.getTime()) + "-" + calendar.get(1);
                        CustomDatePicker.this.setDateValue(strDate);
                    }
                });
            }
            buttonPanel.add(dayButton);
        }
        this.calendarPanel.add((Component)monthLabel, "North");
        this.calendarPanel.add((Component)buttonPanel, "Center");
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Object getObject() {
        return this.object;
    }

    public JDialog getDio() {
        return this.dio;
    }

    private void setDateValue(String dateValue) {
        if (this.getObject() instanceof PropertyOnRentController) {
            PropertyOnRentController controller = (PropertyOnRentController)this.getObject();
            if ("paymentDate".equals(this.getFieldName())) {
                controller.getView().getPaymentDateTf().setText(dateValue);
                this.getDio().setVisible(false);
                this.getDio().dispose();
            } else if ("terminationDate".equals(this.getFieldName())) {
                controller.getView().getTerminationDateTf().setText(dateValue);
                this.getDio().setVisible(false);
                this.getDio().dispose();
            } else if ("depositRefundDate".equals(this.getFieldName())) {
                controller.getView().getDepositRefundDate().setText(dateValue);
                this.getDio().setVisible(false);
                this.getDio().dispose();
            } else if ("depositDate".equals(this.getFieldName())) {
                controller.getView().getDepositDateTf().setText(dateValue);
                this.getDio().setVisible(false);
                this.getDio().dispose();
            } else {
                controller.getView().getDateTf().setText(dateValue);
                this.getDio().setVisible(false);
                this.getDio().dispose();
                controller.calculateTenureEndDate();
            }
        } else if (this.getObject() instanceof PropertyForSellController) {
            PropertyForSellController controller = (PropertyForSellController)this.getObject();
            controller.getView().getDateTf().setText(dateValue);
            this.getDio().setVisible(false);
            this.getDio().dispose();
        } else if (this.getObject() instanceof ContactRecordController) {
            ContactRecordController controller = (ContactRecordController)this.getObject();
            controller.getView().getEventDioValueTf().setText(dateValue);
            this.getDio().setVisible(false);
            this.getDio().dispose();
        } else if (this.getObject() instanceof PropertyRecordController) {
            PropertyRecordController controller = (PropertyRecordController)this.getObject();
            if ("unavailableUntil".equals(this.fieldName)) {
                controller.getView().getUnAvailableUntilTf().setText(dateValue);
            } else if ("dateTf".equals(this.fieldName)) {
                controller.getView().getDateTf().setText(dateValue);
            }
            this.getDio().setVisible(false);
            this.getDio().dispose();
        } else if (this.getObject() instanceof EnquiryRecordController) {
            EnquiryRecordController controller = (EnquiryRecordController)this.getObject();
            controller.getView().getDateTf().setText(dateValue);
            this.getDio().setVisible(false);
            this.getDio().dispose();
        } else if (this.getObject() instanceof EnquiryFollowUpController) {
            EnquiryFollowUpController controller = (EnquiryFollowUpController)this.getObject();
            if ("date".equals(this.fieldName)) {
                controller.getView().getEnquiryDateTf().setText(dateValue);
            } else {
                controller.getView().getEnquiryFollowUpDateTf().setText(dateValue);
                controller.getView().getEnquiryDioClearFolloupDateBtn().setVisible(true);
            }
            this.getDio().setVisible(false);
            this.getDio().dispose();
        } else if (this.getObject() instanceof ManageProjectViewController) {
            ManageProjectViewController controller = (ManageProjectViewController)this.getObject();
            if ("launchDate".equals(this.fieldName)) {
                controller.getView().getLaunchDateTf().setText(dateValue);
            } else {
                controller.getView().getCompletionDateTf().setText(dateValue);
            }
            this.getDio().setVisible(false);
            this.getDio().dispose();
        }
    }
}

