/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.view.common;

import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.utility.UserCache;
import com.arun.bhardwaj.view.LoginView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ErrorDialog
extends JDialog {
    public ErrorDialog(Exception exception, String path) {
        super(LoginView.frame, "Error Occurred", true);
        this.setDefaultCloseOperation(2);
        this.setLayout(new BorderLayout());
        final JTextArea errorDetails = new JTextArea(this.getExceptionDetails(exception, path));
        errorDetails.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(errorDetails);
        this.add((Component)scrollPane, "Center");
        JButton sendButton = new JButton("Send Report", new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/whatsApp.png"))));
        sendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String encodedText = AppUtility.getEncodedText(errorDetails.getText());
                    String link = "https://wa.me/918800776704?text=" + encodedText;
                    Desktop.getDesktop().browse(new URI(link));
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(LoginView.frame, ex.getMessage(), "Error message", 0);
                }
            }
        });
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        buttonPanel.add(sendButton);
        this.add((Component)buttonPanel, "South");
        this.setSize(400, 300);
        AppUtility.setDialogLocationInCenter(this);
        this.setVisible(true);
    }

    private String getExceptionDetails(Exception exception, String buttonClicked) {
        StringBuilder details = new StringBuilder();
        details.append("Reporting Time: ").append(this.getCurrentTime()).append("\n");
        details.append("Class: ").append(exception.getClass().getName()).append("\n");
        details.append("Button Clicked: ").append(buttonClicked).append("\n");
        details.append("Exception Message: ").append(exception.getMessage()).append("\n");
        details.append("\nStack Trace:\n").append(this.getStackTrace(exception));
        details.append("\n\n*Client Details:* ").append(UserCache.getUserSignature());
        return details.toString();
    }

    private String getCurrentTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
        return sdf.format(new Date());
    }

    private String getStackTrace(Exception exception) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        exception.printStackTrace(printWriter);
        return stringWriter.toString();
    }
}

