/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.view.common;

import com.arun.bhardwaj.controller.common.ManageDocumentsController;
import com.arun.bhardwaj.factory.UIFactory;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.utility.ZoomAction;
import com.arun.bhardwaj.view.LoginView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class ManageDocuments {
    private final JDialog documentDio;
    private final JPanel documentBasePanel;
    private final JToolBar documentTopToolBar;
    private final JButton uploadDocuments;
    private final JButton removeDocumentBtn;
    private final JButton saveDocument;
    private final JButton downloadAll;
    private final JButton uploadMultipledocumentsBtn;
    private final DefaultTableModel defaultTableModel;
    private final JTable table;
    private final ListSelectionModel selectionModel;
    private final JSplitPane splitPane;
    private final JSplitPane previewSplitPane;
    private final JPanel previewPanel;
    private final JPanel statusToolBarPanel;
    private final JPanel statusToolBarBasePanel;
    private final JLabel imageName;
    private final JButton zoomInBtn;
    private final JButton zoomOutBtn;
    private final JDialog uploadDio;
    private final JPanel uploadBasePanel;
    private final JPanel uploadPanel;
    private final JPanel uploadToolbarBasePanel;
    private final JButton browseBtn;
    private final JButton saveBtn;
    private final JButton closeDocumentDio;
    private int primaryKey;
    private String fromModule;
    private String filePath;
    private String fileName;
    private final JPanel chatWithDocumentPanel;
    private final JPanel animatedEditorPanel;
    private final JTextPane responseTextArea;
    private final JToolBar chatBottonToolBar;
    private final JToolBar chatTopToolBar;
    private final JTextField promptTf;
    private final JButton callAiBtn;
    private final JButton copyToClipboard;

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public int getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(int primaryKey) {
        this.primaryKey = primaryKey;
    }

    public String getFromModule() {
        return this.fromModule;
    }

    public void setFromModule(String fromModule) {
        this.fromModule = fromModule;
    }

    public ManageDocuments(String fromModule, int primaryKey) {
        this.setPrimaryKey(primaryKey);
        this.setFromModule(fromModule);
        this.documentDio = new JDialog(LoginView.frame, "Manage documents", true);
        this.documentBasePanel = new JPanel();
        this.previewPanel = UIFactory.createGradientPanel();
        this.previewSplitPane = new JSplitPane();
        this.previewSplitPane.setDividerLocation(250);
        this.previewSplitPane.setOneTouchExpandable(false);
        this.documentTopToolBar = UIFactory.createGradientToolBar();
        this.documentTopToolBar.setFloatable(false);
        this.uploadDocuments = new JButton("Upload", new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/upload-s.png"))));
        this.uploadMultipledocumentsBtn = new JButton("Upload multiple files", new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/upload-s.png"))));
        this.removeDocumentBtn = new JButton("Delete", new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/delete-s.png"))));
        this.saveDocument = new JButton("Download", new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/download-s.png"))));
        this.downloadAll = new JButton("Download All", new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/download-s.png"))));
        this.saveDocument.setEnabled(false);
        this.removeDocumentBtn.setEnabled(false);
        this.downloadAll.setEnabled(false);
        this.splitPane = new JSplitPane();
        this.splitPane.setDividerLocation(250);
        this.splitPane.setOneTouchExpandable(false);
        Object[] columns = new Object[]{"Sno", "Date", "Name", "documentId"};
        this.defaultTableModel = new DefaultTableModel(columns, 0);
        this.table = new JTable(this.defaultTableModel){

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int rowIndex = this.rowAtPoint(p);
                int colIndex = this.columnAtPoint(p);
                if (colIndex >= 0 && rowIndex >= 0) {
                    Object value = this.getValueAt(rowIndex, colIndex);
                    return value != null ? value.toString() : null;
                }
                return null;
            }
        };
        this.table.setRowSelectionAllowed(true);
        this.table.setSelectionMode(0);
        this.selectionModel = this.table.getSelectionModel();
        this.table.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(150);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(150);
        this.table.setAutoResizeMode(4);
        InputMap im = this.table.getInputMap(2);
        im.put(KeyStroke.getKeyStroke(61, 128), "zoom in");
        im.put(KeyStroke.getKeyStroke(45, 128), "zoom out");
        this.table.getActionMap().put("zoom in", new ZoomAction(true, this.table));
        this.table.getActionMap().put("zoom out", new ZoomAction(false, this.table));
        this.table.getColumnModel().getColumn(3).setWidth(0);
        this.table.getColumnModel().getColumn(3).setMinWidth(0);
        this.table.getColumnModel().getColumn(3).setMaxWidth(0);
        this.table.setDefaultRenderer(Object.class, new CellBorderRenderer());
        this.table.setDefaultEditor(Object.class, null);
        this.statusToolBarPanel = new JPanel();
        this.statusToolBarBasePanel = new JPanel();
        this.zoomInBtn = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/zoom-in.png"))));
        this.zoomOutBtn = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/zoom-out.png"))));
        this.imageName = UIFactory.createGradientLabel(".", 0);
        this.imageName.setHorizontalAlignment(0);
        this.uploadDio = new JDialog(LoginView.frame, "Choose document", true);
        this.uploadPanel = new JPanel();
        this.uploadBasePanel = new JPanel();
        this.uploadToolbarBasePanel = new JPanel();
        this.uploadToolbarBasePanel.setLayout(new FlowLayout(2, 2, 2));
        this.browseBtn = new JButton("Browse", new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/browse.png"))));
        this.saveBtn = new JButton("Save", new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/save-s.png"))));
        this.closeDocumentDio = new JButton("Close", new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/close-s.png"))));
        this.saveBtn.setEnabled(false);
        this.uploadDio.setSize(500, 300);
        AppUtility.setDialogLocationInCenter(this.uploadDio);
        this.chatWithDocumentPanel = new JPanel();
        this.responseTextArea = UIFactory.createGradientTextPane();
        this.responseTextArea.setEditable(false);
        this.chatBottonToolBar = UIFactory.createGradientToolBar();
        this.promptTf = new JTextField("Ask your query here");
        this.callAiBtn = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/send.png"))));
        this.animatedEditorPanel = new JPanel();
        this.chatTopToolBar = UIFactory.createGradientToolBar();
        this.copyToClipboard = new JButton("Copy to clipboard", new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/copy.png"))));
        this.setLayout();
        new ManageDocumentsController(this);
    }

    private void setLayout() {
        this.documentDio.add(this.documentBasePanel);
        this.documentBasePanel.setLayout(new BorderLayout());
        this.documentBasePanel.add("North", this.documentTopToolBar);
        this.documentTopToolBar.setLayout(new FlowLayout(0, 2, 2));
        this.documentTopToolBar.add(this.uploadDocuments);
        this.documentTopToolBar.add(this.uploadMultipledocumentsBtn);
        this.documentTopToolBar.addSeparator();
        this.documentTopToolBar.add(this.removeDocumentBtn);
        this.documentTopToolBar.addSeparator();
        this.documentTopToolBar.add(this.saveDocument);
        this.documentTopToolBar.add(this.downloadAll);
        this.documentBasePanel.add(this.splitPane);
        this.splitPane.setLeftComponent(new JScrollPane(this.table));
        this.splitPane.setRightComponent(this.previewSplitPane);
        this.previewSplitPane.setLeftComponent(new JScrollPane(this.previewPanel));
        this.previewPanel.setLayout(new BorderLayout());
        this.previewSplitPane.setRightComponent(this.chatWithDocumentPanel);
        this.chatWithDocumentPanel.setLayout(new BorderLayout(2, 2));
        this.chatWithDocumentPanel.add("North", this.chatTopToolBar);
        this.chatTopToolBar.setLayout(new FlowLayout(2, 2, 2));
        this.chatTopToolBar.add(this.copyToClipboard);
        this.chatWithDocumentPanel.add(new JScrollPane(this.responseTextArea));
        this.chatWithDocumentPanel.add("South", this.chatBottonToolBar);
        this.chatBottonToolBar.setLayout(new BorderLayout(2, 2));
        this.chatBottonToolBar.add("West", this.animatedEditorPanel);
        this.chatBottonToolBar.add(this.promptTf);
        this.chatBottonToolBar.add("East", this.callAiBtn);
        this.documentBasePanel.add("South", this.statusToolBarBasePanel);
        this.statusToolBarBasePanel.setLayout(new BorderLayout(3, 3));
        this.statusToolBarBasePanel.add("West", this.statusToolBarPanel);
        this.statusToolBarPanel.setLayout(new FlowLayout(0, 2, 2));
        this.statusToolBarPanel.add(this.zoomOutBtn);
        this.statusToolBarPanel.add(this.zoomInBtn);
        this.statusToolBarBasePanel.add(this.imageName);
        this.uploadDio.getContentPane().add(this.uploadBasePanel);
        this.uploadBasePanel.setLayout(new BorderLayout());
        this.uploadBasePanel.add(this.uploadPanel);
        this.uploadPanel.setLayout(new BorderLayout());
        this.uploadBasePanel.add("South", this.uploadToolbarBasePanel);
        this.uploadToolbarBasePanel.add(this.browseBtn);
        this.uploadToolbarBasePanel.add(this.saveBtn);
        this.uploadToolbarBasePanel.add(this.closeDocumentDio);
        this.documentDio.setMinimumSize(new Dimension(750, 450));
        AppUtility.setDialogLocationInCenter(this.documentDio);
    }

    public JDialog getDocumentDio() {
        return this.documentDio;
    }

    public JButton getUploadDocuments() {
        return this.uploadDocuments;
    }

    public JDialog getUploadDio() {
        return this.uploadDio;
    }

    public DefaultTableModel getDefaultTableModel() {
        return this.defaultTableModel;
    }

    public JTable getTable() {
        return this.table;
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public JButton getZoomInBtn() {
        return this.zoomInBtn;
    }

    public JButton getZoomOutBtn() {
        return this.zoomOutBtn;
    }

    public JButton getBrowseBtn() {
        return this.browseBtn;
    }

    public JButton getSaveBtn() {
        return this.saveBtn;
    }

    public JButton getRemoveDocumentBtn() {
        return this.removeDocumentBtn;
    }

    public JButton getCloseDocumentDio() {
        return this.closeDocumentDio;
    }

    public JPanel getUploadPanel() {
        return this.uploadPanel;
    }

    public JPanel getPreviewPanel() {
        return this.previewPanel;
    }

    public JButton getSaveDocument() {
        return this.saveDocument;
    }

    public JLabel getImageName() {
        return this.imageName;
    }

    public JButton getDownloadAll() {
        return this.downloadAll;
    }

    public JButton getUploadMultipledocumentsBtn() {
        return this.uploadMultipledocumentsBtn;
    }

    public JButton getCallAiBtn() {
        return this.callAiBtn;
    }

    public JTextPane getResponseTextArea() {
        return this.responseTextArea;
    }

    public JTextField getPromptTf() {
        return this.promptTf;
    }

    public JPanel getAnimatedEditorPanel() {
        return this.animatedEditorPanel;
    }

    public JButton getCopyToClipboard() {
        return this.copyToClipboard;
    }

    public JSplitPane getPreviewSplitPane() {
        return this.previewSplitPane;
    }

    public JPanel getChatWithDocumentPanel() {
        return this.chatWithDocumentPanel;
    }

    private static class CellBorderRenderer
    extends DefaultTableCellRenderer {
        private CellBorderRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Border border = BorderFactory.createLineBorder(new Color(90, 168, 204));
            JComponent comp = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            comp.setBorder(border);
            if (isSelected) {
                this.setBackground(new Color(90, 168, 204));
            } else {
                this.setBackground(table.getBackground());
            }
            switch (column) {
                case 0: {
                    this.setHorizontalAlignment(0);
                    break;
                }
                default: {
                    this.setHorizontalAlignment(2);
                }
            }
            return comp;
        }
    }
}

