/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.view.common;

import com.arun.bhardwaj.controller.common.PreviewAndShareController;
import com.arun.bhardwaj.factory.UIFactory;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.view.LoginView;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;

public class PreviewAndShareView {
    private final JDialog dio = new JDialog(LoginView.frame, "Preview", true);
    private final JPanel basePanel = new JPanel();
    private JTextArea textArea;
    private JScrollPane scrollPane;
    private JToolBar bottomToolBar;
    private JButton sendOnWhatsAppBtn;
    private String contactNo;

    public PreviewAndShareView(String strMessage, String contactNo) {
        this.textArea = new JTextArea(strMessage);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.scrollPane = new JScrollPane(this.textArea);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.bottomToolBar = UIFactory.createGradientToolBar();
        this.sendOnWhatsAppBtn = UIFactory.createCustomButton("Share on whatsApp", "SUCCESS");
        this.setContactNo(contactNo);
        new PreviewAndShareController(this);
        this.setLayout();
    }

    private void setLayout() {
        this.dio.add(this.basePanel);
        this.basePanel.setLayout(new BorderLayout());
        this.basePanel.add(this.scrollPane);
        this.basePanel.add("South", this.bottomToolBar);
        this.bottomToolBar.setLayout(new FlowLayout(2, 2, 2));
        this.bottomToolBar.add(this.sendOnWhatsAppBtn);
        this.dio.setMinimumSize(new Dimension(750, 450));
        AppUtility.setDialogLocationInCenter(this.dio);
        this.dio.setVisible(true);
    }

    public JButton getSendOnWhatsAppBtn() {
        return this.sendOnWhatsAppBtn;
    }

    public JTextArea getTextArea() {
        return this.textArea;
    }

    public JDialog getDio() {
        return this.dio;
    }

    public String getContactNo() {
        return this.contactNo;
    }

    public void setContactNo(String contactNo) {
        this.contactNo = contactNo;
    }
}

