/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.view.enquiry;

import com.arun.bhardwaj.controller.enquiry.EnquiryPropertySearchController;
import com.arun.bhardwaj.factory.UIFactory;
import com.arun.bhardwaj.model.enquiry.EnquiryRecord;
import com.arun.bhardwaj.utility.ZoomAction;
import com.arun.bhardwaj.view.LoginView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class EnquiryPropertySearchView {
    private final JDialog enquiryPropertySearchDioDio;
    private final JPanel enquiryPropertySearchDioPanel;
    private final JSplitPane splitPane;
    private final JEditorPane enquiryCriteriaTextArea;
    private final DefaultTableModel defaultTableModel;
    private final JTable table;
    private final ListSelectionModel selectionModel;
    private final JMenuItem viewOwnerDetailsPopupMenu;
    private EnquiryRecord enquiryRecord;
    private final JToolBar statusToolBar;
    private final JPanel statusToolBarPanel;
    private final JPanel statusToolBarBasePanel;
    private final JButton zoomInBtn;
    private final JButton zoomOutBtn;
    private final JButton shareBtn;
    private final JToolBar topToolBar;
    private final JCheckBox showAllProperties;

    public EnquiryRecord getEnquiryRecord() {
        return this.enquiryRecord;
    }

    public void setEnquiryRecord(EnquiryRecord enquiryRecord) {
        this.enquiryRecord = enquiryRecord;
    }

    public EnquiryPropertySearchView(EnquiryRecord enquiryRecord) {
        this.enquiryRecord = enquiryRecord;
        this.enquiryPropertySearchDioDio = new JDialog(LoginView.frame, "Enquiry", true);
        this.enquiryPropertySearchDioPanel = new JPanel();
        this.splitPane = new JSplitPane();
        this.splitPane.setDividerLocation(200);
        this.splitPane.setOneTouchExpandable(false);
        this.enquiryCriteriaTextArea = UIFactory.createGradientEditorPane();
        this.enquiryCriteriaTextArea.setEditable(false);
        this.enquiryCriteriaTextArea.setContentType("text/html");
        Object[] columns = new Object[]{"Sno", "Type", "Address", "Location", "Area Sqft", "Price", "Deposit", "Rent", "ContactId"};
        this.defaultTableModel = new DefaultTableModel(columns, 0);
        this.table = new JTable(this.defaultTableModel){

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int rowIndex = this.rowAtPoint(p);
                int colIndex = this.columnAtPoint(p);
                if (colIndex >= 0 && rowIndex >= 0) {
                    Object value = this.getValueAt(rowIndex, colIndex);
                    return value != null ? value.toString() : null;
                }
                return null;
            }
        };
        this.table.setRowSelectionAllowed(true);
        this.table.setSelectionMode(2);
        this.selectionModel = this.table.getSelectionModel();
        this.table.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(150);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(300);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(200);
        this.table.getColumnModel().getColumn(4).setPreferredWidth(150);
        this.table.getColumnModel().getColumn(5).setPreferredWidth(150);
        this.table.getColumnModel().getColumn(6).setPreferredWidth(150);
        this.table.getColumnModel().getColumn(7).setPreferredWidth(150);
        this.table.getColumnModel().getColumn(8).setPreferredWidth(150);
        this.table.setAutoResizeMode(4);
        InputMap im = this.table.getInputMap(2);
        im.put(KeyStroke.getKeyStroke(61, 128), "zoom in");
        im.put(KeyStroke.getKeyStroke(45, 128), "zoom out");
        this.table.getActionMap().put("zoom in", new ZoomAction(true, this.table));
        this.table.getActionMap().put("zoom out", new ZoomAction(false, this.table));
        this.table.getColumnModel().getColumn(8).setWidth(0);
        this.table.getColumnModel().getColumn(8).setMinWidth(0);
        this.table.getColumnModel().getColumn(8).setMaxWidth(0);
        this.table.getColumnModel().getColumn(0).setWidth(0);
        this.table.getColumnModel().getColumn(0).setMinWidth(0);
        this.table.getColumnModel().getColumn(0).setMaxWidth(0);
        this.table.setDefaultRenderer(Object.class, new CellBorderRenderer());
        this.table.setDefaultEditor(Object.class, null);
        JPopupMenu pm = new JPopupMenu();
        this.viewOwnerDetailsPopupMenu = new JMenuItem("View owner details", new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/view-s.png"))));
        pm.add(this.viewOwnerDetailsPopupMenu);
        this.table.setComponentPopupMenu(pm);
        this.statusToolBar = new JToolBar();
        this.statusToolBar.setFloatable(false);
        this.statusToolBarPanel = UIFactory.createGradientPanel();
        this.statusToolBarBasePanel = new JPanel();
        this.zoomInBtn = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/zoom-in.png"))));
        this.zoomOutBtn = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/zoom-out.png"))));
        this.shareBtn = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/whatsApp.png"))));
        this.topToolBar = new JToolBar();
        this.topToolBar.setFloatable(false);
        this.showAllProperties = new JCheckBox("Show all properties");
        this.setLayout();
        new EnquiryPropertySearchController(this);
    }

    private void setLayout() {
        this.enquiryPropertySearchDioDio.add(this.enquiryPropertySearchDioPanel);
        this.enquiryPropertySearchDioPanel.setLayout(new BorderLayout());
        this.enquiryPropertySearchDioPanel.add("North", this.topToolBar);
        this.topToolBar.setLayout(new FlowLayout(2, 2, 2));
        this.topToolBar.add(this.showAllProperties);
        this.enquiryPropertySearchDioPanel.add(this.splitPane);
        this.splitPane.setLeftComponent(new JScrollPane(this.enquiryCriteriaTextArea));
        this.splitPane.setRightComponent(new JScrollPane(this.table));
        this.enquiryPropertySearchDioPanel.add("South", this.statusToolBar);
        this.statusToolBar.setLayout(new BorderLayout());
        this.statusToolBar.add("West", this.statusToolBarPanel);
        this.statusToolBarPanel.setLayout(new FlowLayout(0, 2, 2));
        this.statusToolBarPanel.add(this.zoomOutBtn);
        this.statusToolBarPanel.add(this.zoomInBtn);
        this.statusToolBar.add(this.statusToolBarBasePanel);
        this.statusToolBarBasePanel.setLayout(new FlowLayout(2, 2, 2));
        this.statusToolBarBasePanel.add(this.shareBtn);
    }

    public JDialog getEnquiryPropertySearchDioDio() {
        return this.enquiryPropertySearchDioDio;
    }

    public JEditorPane getEnquiryCriteriaTextArea() {
        return this.enquiryCriteriaTextArea;
    }

    public DefaultTableModel getDefaultTableModel() {
        return this.defaultTableModel;
    }

    public JTable getTable() {
        return this.table;
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public JMenuItem getViewOwnerDetailsPopupMenu() {
        return this.viewOwnerDetailsPopupMenu;
    }

    public JButton getZoomInBtn() {
        return this.zoomInBtn;
    }

    public JButton getZoomOutBtn() {
        return this.zoomOutBtn;
    }

    public JCheckBox getShowAllProperties() {
        return this.showAllProperties;
    }

    public JButton getShareBtn() {
        return this.shareBtn;
    }

    private static class CellBorderRenderer
    extends DefaultTableCellRenderer {
        private CellBorderRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Border border = BorderFactory.createLineBorder(new Color(90, 168, 204));
            JComponent comp = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            comp.setBorder(border);
            if (isSelected) {
                this.setBackground(new Color(90, 168, 204));
            } else {
                this.setBackground(table.getBackground());
            }
            switch (column) {
                case 0: {
                    this.setHorizontalAlignment(0);
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    this.setHorizontalAlignment(4);
                    break;
                }
                default: {
                    this.setHorizontalAlignment(2);
                }
            }
            return comp;
        }
    }
}

