/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.view.enquiry;

import com.arun.bhardwaj.controller.enquiry.EnquiryRecordController;
import com.arun.bhardwaj.customcomponent.NumberTextField;
import com.arun.bhardwaj.factory.UIFactory;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.utility.NumberToWordsConverter;
import com.arun.bhardwaj.view.LoginView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;

public class EnquiryRecordView {
    public JDialog dio = new JDialog(LoginView.frame, "New Record", true);
    private final JTabbedPane detailsTp = new JTabbedPane();
    private final JPanel basePanel = new JPanel();
    private final JPanel fieldBasePanel = new JPanel(new GridBagLayout());
    private GridBagConstraints gbc = new GridBagConstraints();
    private final JRadioButton forRent;
    private final JRadioButton forPurchase;
    private final Container lookingForContainer;
    private final JButton contactBtn;
    private final JTextField dateTf;
    private final JTextField nameTf;
    private final JTextField locationTf;
    private final JTextField sourceTf;
    private final JTextField additionalInfoTf;
    private final NumberTextField budgetFromTf;
    private final NumberTextField budgetToTf;
    private final NumberTextField sizeFromTf;
    private final NumberTextField sizeToTf;
    private final JLabel budgetFromLabel;
    private final JLabel budgetToLabel;
    private final JLabel sizeFromLabel;
    private final JLabel sizeToLabel;
    private final JButton dateBtn;
    private final JPanel commentsBasePanel;
    private final JTextArea commentsTextArea;
    private final JComboBox groupNames;
    private final JToolBar tb;
    private final JToolBar tb1;
    private final JPanel tb2BasePanel;
    private final JButton saveBtn;
    private final JButton closeBtn;
    private final JButton updateBtn;
    private final JCheckBox closeEnquiry;
    private int selectedContactId;
    private int enquiryId;
    private EnquiryRecordController enquiryRecordController;

    public int getEnquiryId() {
        return this.enquiryId;
    }

    public void setEnquiryId(int enquiryId) {
        this.enquiryId = enquiryId;
    }

    public int getSelectedContactId() {
        return this.selectedContactId;
    }

    public void setSelectedContactId(int selectedContactId) {
        this.selectedContactId = selectedContactId;
    }

    public EnquiryRecordView() {
        this.gbc.insets = new Insets(2, 2, 2, 2);
        this.lookingForContainer = new Container();
        this.forRent = new JRadioButton("Rent", true);
        this.forPurchase = new JRadioButton("Purchase");
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.forPurchase);
        bg.add(this.forRent);
        this.tb = new JToolBar();
        this.tb.setFloatable(false);
        this.tb.setOrientation(1);
        this.tb1 = new JToolBar();
        this.tb1.setFloatable(false);
        this.tb1.setOrientation(1);
        this.tb2BasePanel = UIFactory.createGradientPanel();
        this.dateTf = new JTextField(16);
        this.dateTf.setEditable(false);
        this.nameTf = new JTextField(16);
        this.nameTf.setEditable(false);
        this.locationTf = new JTextField(40);
        this.budgetFromTf = new NumberTextField(16);
        this.budgetToTf = new NumberTextField(16);
        this.sizeFromTf = new NumberTextField(16);
        this.sizeToTf = new NumberTextField(16);
        this.budgetFromTf.setPreferredSize(new Dimension(185, 35));
        this.budgetToTf.setPreferredSize(new Dimension(185, 35));
        this.sizeFromTf.setPreferredSize(new Dimension(185, 35));
        this.sizeToTf.setPreferredSize(new Dimension(185, 35));
        this.budgetFromLabel = new JLabel(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/info.png"))));
        this.budgetToLabel = new JLabel(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/info.png"))));
        this.sizeFromLabel = new JLabel(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/info.png"))));
        this.sizeToLabel = new JLabel(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/info.png"))));
        this.budgetFromLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                String currentText = EnquiryRecordView.this.budgetFromTf.getText();
                if (!currentText.trim().isEmpty()) {
                    EnquiryRecordView.this.budgetFromLabel.setToolTipText(NumberToWordsConverter.convertToIndianWords(Long.parseLong(currentText)));
                }
            }
        });
        this.budgetToLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                String currentText = EnquiryRecordView.this.budgetToTf.getText();
                if (!currentText.trim().isEmpty()) {
                    EnquiryRecordView.this.budgetToLabel.setToolTipText(NumberToWordsConverter.convertToIndianWords(Long.parseLong(currentText)));
                }
            }
        });
        this.sizeFromLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                String currentText = EnquiryRecordView.this.sizeFromTf.getText();
                if (!currentText.trim().isEmpty()) {
                    EnquiryRecordView.this.sizeFromLabel.setToolTipText(NumberToWordsConverter.convertToIndianWords(Long.parseLong(currentText)));
                }
            }
        });
        this.sizeToLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                String currentText = EnquiryRecordView.this.sizeToTf.getText();
                if (!currentText.trim().isEmpty()) {
                    EnquiryRecordView.this.sizeToLabel.setToolTipText(NumberToWordsConverter.convertToIndianWords(Long.parseLong(currentText)));
                }
            }
        });
        this.sourceTf = new JTextField(40);
        this.additionalInfoTf = new JTextField(40);
        this.dateBtn = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/date.png"))));
        this.contactBtn = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/contact-s.png"))));
        this.commentsBasePanel = new JPanel();
        this.commentsTextArea = new JTextArea(3, 40);
        this.groupNames = new JComboBox();
        this.groupNames.setPreferredSize(new Dimension(190, 35));
        this.saveBtn = new JButton("Save", new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/save.png"))));
        this.closeBtn = new JButton("Close", new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/close-s.png"))));
        this.updateBtn = new JButton("Update", new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/update-s.png"))));
        this.closeEnquiry = new JCheckBox("Close Enquiry");
        this.closeEnquiry.setVisible(false);
        this.setLayout();
        this.enquiryRecordController = new EnquiryRecordController(this);
    }

    private void setLayout() {
        this.dio.getContentPane().add(this.basePanel);
        this.basePanel.setLayout(new BorderLayout(2, 2));
        this.basePanel.add(this.fieldBasePanel);
        this.gbc.anchor = 17;
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.fieldBasePanel.add((Component)new JLabel("Looking for"), this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.fieldBasePanel.add((Component)this.lookingForContainer, this.gbc);
        this.lookingForContainer.setLayout(new FlowLayout(0, 2, 2));
        this.lookingForContainer.add(this.forRent);
        this.lookingForContainer.add(this.forPurchase);
        this.gbc.gridx = 0;
        this.gbc.gridy = 2;
        this.fieldBasePanel.add((Component)new JLabel("<html>Date<span style='color: red;'>*</span></html>"), this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 3;
        this.fieldBasePanel.add((Component)this.dateTf, this.gbc);
        this.gbc.gridx = 1;
        this.gbc.gridy = 3;
        this.fieldBasePanel.add((Component)this.dateBtn, this.gbc);
        this.gbc.gridx = 1;
        this.gbc.gridy = 5;
        this.fieldBasePanel.add((Component)this.budgetFromLabel, this.gbc);
        this.gbc.gridx = 1;
        this.gbc.gridy = 7;
        this.fieldBasePanel.add((Component)this.sizeFromLabel, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 4;
        this.fieldBasePanel.add((Component)new JLabel("Min Budget"), this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 5;
        this.fieldBasePanel.add((Component)this.budgetFromTf, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 6;
        this.fieldBasePanel.add((Component)new JLabel("Min Area in Sqft"), this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 7;
        this.fieldBasePanel.add((Component)this.sizeFromTf, this.gbc);
        this.gbc.gridx = 2;
        this.gbc.gridy = 0;
        this.fieldBasePanel.add((Component)new JLabel("<html>Property Type<span style='color: red;'>*</span></html>"), this.gbc);
        this.gbc.gridx = 2;
        this.gbc.gridy = 1;
        this.fieldBasePanel.add((Component)this.groupNames, this.gbc);
        this.gbc.gridx = 2;
        this.gbc.gridy = 2;
        this.fieldBasePanel.add((Component)new JLabel("<html>Name<span style='color: red;'>*</span></html>"), this.gbc);
        this.gbc.gridx = 2;
        this.gbc.gridy = 3;
        this.fieldBasePanel.add((Component)this.nameTf, this.gbc);
        this.gbc.gridx = 3;
        this.gbc.gridy = 3;
        this.fieldBasePanel.add((Component)this.contactBtn, this.gbc);
        this.gbc.gridx = 3;
        this.gbc.gridy = 5;
        this.fieldBasePanel.add((Component)this.budgetToLabel, this.gbc);
        this.gbc.gridx = 3;
        this.gbc.gridy = 7;
        this.fieldBasePanel.add((Component)this.sizeToLabel, this.gbc);
        this.gbc.gridx = 2;
        this.gbc.gridy = 4;
        this.fieldBasePanel.add((Component)new JLabel("Max Budget"), this.gbc);
        this.gbc.gridx = 2;
        this.gbc.gridy = 5;
        this.fieldBasePanel.add((Component)this.budgetToTf, this.gbc);
        this.gbc.gridx = 2;
        this.gbc.gridy = 6;
        this.fieldBasePanel.add((Component)new JLabel("Max Area in Sqft"), this.gbc);
        this.gbc.gridx = 2;
        this.gbc.gridy = 7;
        this.fieldBasePanel.add((Component)this.sizeToTf, this.gbc);
        this.gbc.gridwidth = 4;
        this.gbc.gridx = 0;
        this.gbc.gridy = 8;
        this.fieldBasePanel.add((Component)new JLabel("Locations"), this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 9;
        this.fieldBasePanel.add((Component)this.locationTf, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 10;
        this.fieldBasePanel.add((Component)new JLabel("Source"), this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 11;
        this.fieldBasePanel.add((Component)this.sourceTf, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 12;
        this.fieldBasePanel.add((Component)new JLabel("Additional Info"), this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 13;
        this.fieldBasePanel.add((Component)this.additionalInfoTf, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 14;
        this.fieldBasePanel.add((Component)new JLabel("Comments"), this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 15;
        this.fieldBasePanel.add((Component)new JScrollPane(this.commentsTextArea), this.gbc);
        this.basePanel.add("South", this.tb2BasePanel);
        this.tb2BasePanel.setLayout(new FlowLayout(2, 2, 2));
        this.tb2BasePanel.add(this.closeEnquiry);
        this.tb2BasePanel.add(this.updateBtn);
        this.tb2BasePanel.add(this.saveBtn);
        this.tb2BasePanel.add(this.closeBtn);
        this.dio.setMinimumSize(new Dimension(530, 610));
        AppUtility.setDialogLocationInCenter(this.dio);
    }

    public JDialog getDio() {
        return this.dio;
    }

    public JButton getSaveBtn() {
        return this.saveBtn;
    }

    public JButton getUpdateBtn() {
        return this.updateBtn;
    }

    public JButton getCloseBtn() {
        return this.closeBtn;
    }

    public JButton getContactBtn() {
        return this.contactBtn;
    }

    public JComboBox getGroupNames() {
        return this.groupNames;
    }

    public JTextField getLocationTf() {
        return this.locationTf;
    }

    public JTextArea getCommentsTextArea() {
        return this.commentsTextArea;
    }

    public JRadioButton getForRent() {
        return this.forRent;
    }

    public JRadioButton getForPurchase() {
        return this.forPurchase;
    }

    public JTextField getDateTf() {
        return this.dateTf;
    }

    public JButton getDateBtn() {
        return this.dateBtn;
    }

    public JTextField getBudgetFromTf() {
        return this.budgetFromTf;
    }

    public JTextField getBudgetToTf() {
        return this.budgetToTf;
    }

    public JTextField getSizeFromTf() {
        return this.sizeFromTf;
    }

    public JTextField getSizeToTf() {
        return this.sizeToTf;
    }

    public JTextField getSourceTf() {
        return this.sourceTf;
    }

    public JTextField getNameTf() {
        return this.nameTf;
    }

    public JCheckBox getCloseEnquiry() {
        return this.closeEnquiry;
    }

    public EnquiryRecordController getEnquiryRecordController() {
        return this.enquiryRecordController;
    }

    public JLabel getSizeFromLabel() {
        return this.sizeFromLabel;
    }

    public JLabel getSizeToLabel() {
        return this.sizeToLabel;
    }

    public JLabel getBudgetFromLabel() {
        return this.budgetFromLabel;
    }

    public JLabel getBudgetToLabel() {
        return this.budgetToLabel;
    }

    public JTextField getAdditionalInfoTf() {
        return this.additionalInfoTf;
    }
}

