/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.view.legal;

import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.utility.ReadEmailUtility;
import com.arun.bhardwaj.view.LoginView;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Frame;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Store;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class PrivacyPolicyView {
    private final JDialog dio = new JDialog((Frame)LoginView.frame, "Privacy Policy");
    private final Container panel = new JPanel();
    private final JTextArea content = new JTextArea();
    private final JScrollPane sp;

    public PrivacyPolicyView() {
        this.content.setColumns(30);
        this.content.setLineWrap(true);
        this.content.setWrapStyleWord(true);
        this.content.setEditable(false);
        int v = 20;
        int h = 30;
        this.sp = new JScrollPane(this.content, v, h);
        this.dio.setSize(400, 500);
        AppUtility.setDialogLocationInCenter(this.dio);
        this.setLayout();
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
        executorService.schedule(() -> {
            try {
                this.loadPrivacyPolicy();
                this.dio.setVisible(true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(LoginView.frame, e.getMessage(), "Error Message", 0);
            }
        }, 2L, TimeUnit.SECONDS);
        executorService.shutdown();
    }

    private void setLayout() {
        this.dio.add(this.panel);
        this.panel.setLayout(new BorderLayout());
        this.panel.add(this.sp);
    }

    private void loadPrivacyPolicy() throws Exception {
        Message[] messages;
        Session session = ReadEmailUtility.getSession();
        Store store = session.getStore();
        store.connect();
        Folder inbox = store.getFolder("INBOX");
        inbox.open(1);
        for (Message message : messages = inbox.getMessages()) {
            if (message.getSubject() == null || !"Privacy Policy".equals(message.getSubject())) continue;
            this.content.setText(ReadEmailUtility.getTextFromMessage(message));
            this.content.setCaretPosition(0);
        }
        inbox.close(false);
        store.close();
    }
}

