/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.view.project;

import com.arun.bhardwaj.controller.project.ProjectDetailsViewController;
import com.arun.bhardwaj.factory.UIFactory;
import com.arun.bhardwaj.utility.ZoomAction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class ProjectDetailsView
extends JPanel {
    private JSplitPane splitPane = new JSplitPane(1, true);
    private final JPanel leftPanel;
    private final JPanel rightPanel;
    private final JPanel topToolBarBasePanel;
    private final JToolBar topToolBar;
    private final JButton addProjectButton;
    private final JButton updateProjectButton;
    private final JButton deleteProjectButton;
    private final JButton addProjectTypeButton;
    private final JButton updateProjectTypeButton;
    private final JButton deleteProjectTypeButton;
    private final JButton manageDocumentBtn;
    private final JButton refreshButton;
    private JComboBox projectTypeList;
    private JComboBox propertyTypeFilter;
    private JComboBox projectStatusFilter;
    private JComboBox builderNameFilter;
    private JComboBox architectNameFilter;
    private Container filterContainer;
    private GridBagConstraints filterGbc;
    private JComboBox searchBy;
    private JLabel searchByLabel;
    private JTextField searchDataTf;
    private final DefaultTableModel defaultTableModel;
    private final JTable table;
    private final ListSelectionModel selectionModel;
    private JMenuItem updateProjectDetailsPopupMenu;
    private JMenuItem deleteProjectDetailsPopupMenu;
    private JMenuItem documentProjectDetailsPopupMenu;
    private final JToolBar statusToolBar;
    private final JPanel statusToolBarPanel;
    private final JButton zoomInBtn;
    private final JButton zoomOutBtn;
    private final int PAGE_SIZE = 100;
    private int currentPage = 1;
    private int totalRecords = 0;
    private final JButton prevButton;
    private final JButton nextButton;
    private final JLabel pageLabel;
    private JPanel projectDetailBasePanel;
    private final JEditorPane projectDetailsEditorPane;
    private JToolBar projectDetailsToolBar;
    private JButton shareProjectDetails;
    private ProjectDetailsViewController controller;

    public ProjectDetailsView() {
        this.splitPane.setDividerLocation(0.75);
        this.splitPane.setResizeWeight(0.75);
        this.splitPane.setOneTouchExpandable(true);
        this.leftPanel = new JPanel();
        this.rightPanel = new JPanel();
        this.topToolBarBasePanel = UIFactory.createGradientPanel();
        this.topToolBarBasePanel.setLayout(new BorderLayout(2, 2));
        this.topToolBar = UIFactory.createGradientToolBar();
        this.topToolBar.setFloatable(false);
        this.filterContainer = new JPanel(new GridBagLayout());
        this.filterContainer.setBackground(new Color(248, 246, 245));
        this.filterGbc = new GridBagConstraints();
        this.filterGbc.insets = new Insets(2, 2, 2, 2);
        this.searchByLabel = new JLabel("");
        this.searchDataTf = new JTextField(20);
        this.searchDataTf.setVisible(false);
        String[] searchByOptions = new String[]{"Select", "Project Type", "Property Type", "Project Status", "Project Name", "Builder Name", "Architect Name", "Location", "RERA Registration No"};
        this.searchBy = new JComboBox<String>(searchByOptions);
        this.searchBy.setPreferredSize(new Dimension(150, 23));
        this.projectTypeList = new JComboBox();
        this.projectTypeList.setPreferredSize(new Dimension(150, 23));
        this.propertyTypeFilter = new JComboBox();
        this.propertyTypeFilter.setPreferredSize(new Dimension(150, 23));
        this.builderNameFilter = new JComboBox();
        this.builderNameFilter.setPreferredSize(new Dimension(150, 23));
        this.architectNameFilter = new JComboBox();
        this.architectNameFilter.setPreferredSize(new Dimension(150, 23));
        this.builderNameFilter.setVisible(false);
        this.architectNameFilter.setVisible(false);
        String[] projectStatus = new String[]{"All Records", "Completed", "In Progress"};
        this.projectStatusFilter = new JComboBox<String>(projectStatus);
        this.projectStatusFilter.setPreferredSize(new Dimension(150, 23));
        this.projectTypeList.setVisible(false);
        this.propertyTypeFilter.setVisible(false);
        this.projectStatusFilter.setVisible(false);
        this.addProjectButton = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/new.png"))));
        this.updateProjectButton = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/update.png"))));
        this.deleteProjectButton = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/delete.png"))));
        this.addProjectTypeButton = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/new.png"))));
        this.updateProjectTypeButton = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/update.png"))));
        this.deleteProjectTypeButton = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/delete.png"))));
        this.manageDocumentBtn = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/documents.png"))));
        this.refreshButton = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/refresh.png"))));
        this.updateProjectTypeButton.setEnabled(false);
        this.deleteProjectTypeButton.setEnabled(false);
        Object[] columns = new Object[]{"projectId", "Project Name", "Description", "Project Type", "Project Status", "Launch Date", "Completion Date"};
        this.defaultTableModel = new DefaultTableModel(columns, 0);
        this.table = new JTable(this.defaultTableModel){

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int rowIndex = this.rowAtPoint(p);
                int colIndex = this.columnAtPoint(p);
                if (colIndex >= 0 && rowIndex >= 0) {
                    Object value = this.getValueAt(rowIndex, colIndex);
                    return value != null ? value.toString() : null;
                }
                return null;
            }
        };
        this.table.setRowSelectionAllowed(true);
        this.table.setSelectionMode(2);
        this.selectionModel = this.table.getSelectionModel();
        this.table.setDefaultRenderer(Object.class, new CellBorderRenderer());
        this.table.getColumnModel().getColumn(0).setPreferredWidth(0);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(250);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(4).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(5).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(6).setPreferredWidth(100);
        this.table.setAutoResizeMode(4);
        InputMap im = this.table.getInputMap(2);
        im.put(KeyStroke.getKeyStroke(61, 128), "zoom in");
        im.put(KeyStroke.getKeyStroke(45, 128), "zoom out");
        this.table.getActionMap().put("zoom in", new ZoomAction(true, this.table));
        this.table.getActionMap().put("zoom out", new ZoomAction(false, this.table));
        this.table.getColumnModel().getColumn(0).setWidth(0);
        this.table.getColumnModel().getColumn(0).setMinWidth(0);
        this.table.getColumnModel().getColumn(0).setMaxWidth(0);
        this.table.setDefaultEditor(Object.class, null);
        JPopupMenu pmProjectDetails = new JPopupMenu();
        this.updateProjectDetailsPopupMenu = new JMenuItem("Update Record", new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/update-s.png"))));
        this.deleteProjectDetailsPopupMenu = new JMenuItem("Delete Record", new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/delete-s.png"))));
        this.documentProjectDetailsPopupMenu = new JMenuItem("Manage Documents", new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/documents-s.png"))));
        pmProjectDetails.add(this.updateProjectDetailsPopupMenu);
        pmProjectDetails.add(this.deleteProjectDetailsPopupMenu);
        pmProjectDetails.addSeparator();
        pmProjectDetails.add(this.documentProjectDetailsPopupMenu);
        this.table.setComponentPopupMenu(pmProjectDetails);
        this.statusToolBar = UIFactory.createGradientToolBar();
        this.statusToolBar.setFloatable(false);
        this.statusToolBarPanel = UIFactory.createGradientPanel();
        this.zoomInBtn = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/zoom-in.png"))));
        this.zoomOutBtn = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/zoom-out.png"))));
        this.prevButton = new JButton("Previous");
        this.nextButton = new JButton("Next");
        this.pageLabel = new JLabel("");
        this.projectDetailBasePanel = new JPanel();
        this.projectDetailBasePanel.setLayout(new BorderLayout(2, 2));
        this.projectDetailsEditorPane = UIFactory.createGradientEditorPane();
        this.projectDetailsEditorPane.setEditable(false);
        this.projectDetailsEditorPane.setContentType("text/html");
        this.projectDetailsToolBar = new JToolBar();
        this.shareProjectDetails = UIFactory.createCustomButton("Validate and share on whatsapp", "INFO");
        this.setLayout();
        this.controller = new ProjectDetailsViewController(this);
    }

    private void setLayout() {
        this.setLayout(new BorderLayout());
        this.add(this.splitPane);
        this.splitPane.setLeftComponent(this.leftPanel);
        this.leftPanel.setLayout(new BorderLayout(2, 2));
        this.leftPanel.add(new JScrollPane(this.table));
        this.splitPane.setRightComponent(this.rightPanel);
        this.rightPanel.setLayout(new BorderLayout(2, 2));
        this.rightPanel.add(this.projectDetailBasePanel);
        this.projectDetailBasePanel.add(new JScrollPane(this.projectDetailsEditorPane));
        this.projectDetailBasePanel.add("South", this.projectDetailsToolBar);
        this.projectDetailsToolBar.setFloatable(false);
        this.projectDetailsToolBar.setLayout(new FlowLayout(2, 2, 2));
        this.projectDetailsToolBar.add(this.shareProjectDetails);
        this.add("North", this.topToolBarBasePanel);
        this.topToolBarBasePanel.add("West", this.topToolBar);
        this.topToolBar.setLayout(new FlowLayout(0, 2, 2));
        this.topToolBar.add(this.addProjectButton);
        this.topToolBar.add(this.updateProjectButton);
        this.topToolBar.add(this.deleteProjectButton);
        this.topToolBar.addSeparator();
        this.topToolBar.add(this.addProjectTypeButton);
        this.topToolBar.add(this.updateProjectTypeButton);
        this.topToolBar.add(this.deleteProjectTypeButton);
        this.topToolBar.addSeparator();
        this.topToolBar.add(this.manageDocumentBtn);
        this.topToolBar.add(this.refreshButton);
        this.topToolBarBasePanel.add("East", this.filterContainer);
        this.filterGbc.anchor = 17;
        this.filterGbc.gridx = 0;
        this.filterGbc.gridy = 0;
        this.filterContainer.add((Component)new JLabel("Search By"), this.filterGbc);
        this.filterGbc.gridx = 0;
        this.filterGbc.gridy = 1;
        this.filterContainer.add((Component)this.searchBy, this.filterGbc);
        this.filterGbc.gridx = 1;
        this.filterGbc.gridy = 0;
        this.filterContainer.add((Component)this.searchByLabel, this.filterGbc);
        this.filterGbc.gridx = 1;
        this.filterGbc.gridy = 1;
        this.filterContainer.add((Component)this.projectTypeList, this.filterGbc);
        this.filterGbc.gridx = 1;
        this.filterGbc.gridy = 1;
        this.filterContainer.add((Component)this.propertyTypeFilter, this.filterGbc);
        this.filterGbc.gridx = 1;
        this.filterGbc.gridy = 1;
        this.filterContainer.add((Component)this.projectStatusFilter, this.filterGbc);
        this.filterGbc.gridx = 1;
        this.filterGbc.gridy = 1;
        this.filterContainer.add((Component)this.searchDataTf, this.filterGbc);
        this.filterGbc.gridx = 1;
        this.filterGbc.gridy = 1;
        this.filterContainer.add((Component)this.builderNameFilter, this.filterGbc);
        this.filterGbc.gridx = 1;
        this.filterGbc.gridy = 1;
        this.filterContainer.add((Component)this.architectNameFilter, this.filterGbc);
        this.add("South", this.statusToolBar);
        this.statusToolBar.setLayout(new BorderLayout());
        this.statusToolBar.add("West", this.statusToolBarPanel);
        this.statusToolBarPanel.setLayout(new FlowLayout(0, 2, 2));
        this.statusToolBarPanel.add(this.zoomOutBtn);
        this.statusToolBarPanel.add(this.zoomInBtn);
        this.statusToolBarPanel.add(this.prevButton);
        this.statusToolBarPanel.add(this.pageLabel);
        this.statusToolBarPanel.add(this.nextButton);
    }

    public JButton getAddProjectButton() {
        return this.addProjectButton;
    }

    public JButton getUpdateProjectButton() {
        return this.updateProjectButton;
    }

    public JButton getDeleteProjectButton() {
        return this.deleteProjectButton;
    }

    public JButton getAddProjectTypeButton() {
        return this.addProjectTypeButton;
    }

    public JButton getUpdateProjectTypeButton() {
        return this.updateProjectTypeButton;
    }

    public JButton getDeleteProjectTypeButton() {
        return this.deleteProjectTypeButton;
    }

    public JButton getRefreshButton() {
        return this.refreshButton;
    }

    public JComboBox getProjectTypeList() {
        return this.projectTypeList;
    }

    public JTable getTable() {
        return this.table;
    }

    public ProjectDetailsViewController getController() {
        return this.controller;
    }

    public DefaultTableModel getDefaultTableModel() {
        return this.defaultTableModel;
    }

    public JButton getZoomInBtn() {
        return this.zoomInBtn;
    }

    public JButton getZoomOutBtn() {
        return this.zoomOutBtn;
    }

    public int getPAGE_SIZE() {
        return 100;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public JButton getPrevButton() {
        return this.prevButton;
    }

    public JButton getNextButton() {
        return this.nextButton;
    }

    public JLabel getPageLabel() {
        return this.pageLabel;
    }

    public int getTotalRecords() {
        return this.totalRecords;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public void setTotalRecords(int totalRecords) {
        this.totalRecords = totalRecords;
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public JMenuItem getUpdateProjectDetailsPopupMenu() {
        return this.updateProjectDetailsPopupMenu;
    }

    public JMenuItem getDeleteProjectDetailsPopupMenu() {
        return this.deleteProjectDetailsPopupMenu;
    }

    public JEditorPane getProjectDetailsEditorPane() {
        return this.projectDetailsEditorPane;
    }

    public JButton getShareProjectDetails() {
        return this.shareProjectDetails;
    }

    public JMenuItem getDocumentProjectDetailsPopupMenu() {
        return this.documentProjectDetailsPopupMenu;
    }

    public JButton getManageDocumentBtn() {
        return this.manageDocumentBtn;
    }

    public JComboBox getPropertyTypeFilter() {
        return this.propertyTypeFilter;
    }

    public JComboBox getSearchBy() {
        return this.searchBy;
    }

    public JComboBox getProjectStatusFilter() {
        return this.projectStatusFilter;
    }

    public JLabel getSearchByLabel() {
        return this.searchByLabel;
    }

    public JTextField getSearchDataTf() {
        return this.searchDataTf;
    }

    public JComboBox getBuilderNameFilter() {
        return this.builderNameFilter;
    }

    public JComboBox getArchitectNameFilter() {
        return this.architectNameFilter;
    }

    public static class CellBorderRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Border border = BorderFactory.createLineBorder(new Color(90, 168, 204));
            JComponent comp = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            comp.setBorder(border);
            if (isSelected) {
                this.setBackground(new Color(90, 168, 204));
            } else {
                this.setBackground(table.getBackground());
            }
            return comp;
        }
    }
}

