/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.view.property;

import com.arun.bhardwaj.controller.property.HomeLoanCalculatorController;
import com.arun.bhardwaj.factory.UIFactory;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.view.LoginView;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;

public class HomeLoanCalculator {
    private final JDialog dio;
    private final JPanel basePanel;
    private final JPanel leftPanel;
    private final JPanel rightPanel;
    private final JPanel chartPanel;
    private JTextField loanAmount;
    private JTextField tenureInYears;
    private JTextField intrestRatePA;
    private final JEditorPane resultTextArea;
    private final JSplitPane topSplitPane;
    private int propertyPrice;

    public int getPropertyPrice() {
        return this.propertyPrice;
    }

    public void setPropertyPrice(int propertyPrice) {
        this.propertyPrice = propertyPrice;
    }

    public HomeLoanCalculator(String propertyPrice) {
        this.setPropertyPrice(Integer.parseInt(propertyPrice));
        this.dio = new JDialog(LoginView.frame, "Home loan calculator", true);
        this.basePanel = new JPanel();
        this.leftPanel = UIFactory.createGradientPanel();
        AppUtility.addBorderToPanel("Details", this.leftPanel);
        this.rightPanel = UIFactory.createGradientPanel();
        AppUtility.addBorderToPanel("Summary", this.rightPanel);
        this.chartPanel = UIFactory.createGradientPanel();
        AppUtility.addBorderToPanel("Pie chart", this.chartPanel);
        this.loanAmount = new JTextField();
        this.tenureInYears = new JTextField();
        this.intrestRatePA = new JTextField();
        this.topSplitPane = new JSplitPane(1, false);
        this.topSplitPane.setDividerLocation(180);
        this.topSplitPane.setOneTouchExpandable(false);
        this.resultTextArea = UIFactory.createGradientEditorPane();
        this.resultTextArea.setEditable(false);
        this.resultTextArea.setContentType("text/html");
        this.setLayout();
        new HomeLoanCalculatorController(this);
    }

    private void setLayout() {
        this.dio.getContentPane().add(this.basePanel);
        this.basePanel.setLayout(new BorderLayout());
        this.basePanel.add(this.topSplitPane);
        this.topSplitPane.setLeftComponent(this.leftPanel);
        this.leftPanel.setLayout(new GridLayout(6, 1, 2, 2));
        this.leftPanel.add(new JLabel("Loan Amount:", 2));
        this.leftPanel.add(this.loanAmount);
        this.leftPanel.add(new JLabel("Tenure (Years) :"));
        this.leftPanel.add(this.tenureInYears);
        this.leftPanel.add(new JLabel("Interest Rate (% P.A.) :"));
        this.leftPanel.add(this.intrestRatePA);
        this.topSplitPane.setRightComponent(this.rightPanel);
        this.rightPanel.setLayout(new BorderLayout(2, 2));
        this.rightPanel.add(new JScrollPane(this.resultTextArea));
        this.basePanel.add("South", this.chartPanel);
        this.chartPanel.setLayout(new BorderLayout());
        this.dio.setSize(500, 700);
        AppUtility.setDialogLocationInCenter(this.dio);
        this.dio.setResizable(true);
    }

    public JEditorPane getResultTextArea() {
        return this.resultTextArea;
    }

    public JTextField getLoanAmount() {
        return this.loanAmount;
    }

    public JTextField getTenureInYears() {
        return this.tenureInYears;
    }

    public JTextField getIntrestRatePA() {
        return this.intrestRatePA;
    }

    public JDialog getDio() {
        return this.dio;
    }

    public JPanel getChartPanel() {
        return this.chartPanel;
    }
}

