/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.view.property;

import com.arun.bhardwaj.controller.property.PropertyAuditController;
import com.arun.bhardwaj.factory.UIFactory;
import com.arun.bhardwaj.utility.ZoomAction;
import com.arun.bhardwaj.view.LoginView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class PropertyAudit {
    private final JDialog propertyAuditDio;
    private final JPanel propertyAuditPanel;
    private final JPanel propertyTopBasePanel;
    private final JButton shareWithOwnerBtn;
    private final JButton manageDocumentBtn;
    private String propertyAddress;
    private final DefaultTableModel defaultTableModel;
    private final JTable table;
    private final int v;
    private final int h;
    private final JScrollPane sp;
    private final ListSelectionModel selectionModel;
    private final JSplitPane splitPane;
    private final JEditorPane propDetailsTextArea;
    private final JPanel statusToolBarPanel;
    private final JButton zoomInBtn;
    private final JButton zoomOutBtn;
    private int propertyId;

    public int getPropertyId() {
        return this.propertyId;
    }

    public void setPropertyId(int propertyId) {
        this.propertyId = propertyId;
    }

    public PropertyAudit(int propertyId, String propertyAddress) {
        this.propertyId = propertyId;
        this.propertyAddress = propertyAddress;
        this.propertyAuditDio = new JDialog(LoginView.frame, "Property audit", true);
        this.propertyAuditPanel = new JPanel();
        this.propertyTopBasePanel = UIFactory.createGradientPanel();
        this.manageDocumentBtn = new JButton("Manage documents", new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/documents-s.png"))));
        this.shareWithOwnerBtn = new JButton("Validate and Share with owner", new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/whatsApp.png"))));
        this.splitPane = new JSplitPane();
        this.splitPane.setDividerLocation(250);
        this.splitPane.setOneTouchExpandable(false);
        Object[] columns = new Object[]{"Sno", "Date", "Status", "statusId"};
        this.defaultTableModel = new DefaultTableModel(columns, 0);
        this.table = new JTable(this.defaultTableModel){

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int rowIndex = this.rowAtPoint(p);
                int colIndex = this.columnAtPoint(p);
                if (colIndex >= 0 && rowIndex >= 0) {
                    Object value = this.getValueAt(rowIndex, colIndex);
                    return value != null ? value.toString() : null;
                }
                return null;
            }
        };
        this.table.setRowSelectionAllowed(true);
        this.table.setSelectionMode(0);
        this.selectionModel = this.table.getSelectionModel();
        this.table.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(150);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(150);
        this.table.setAutoResizeMode(4);
        InputMap im = this.table.getInputMap(2);
        im.put(KeyStroke.getKeyStroke(61, 128), "zoom in");
        im.put(KeyStroke.getKeyStroke(45, 128), "zoom out");
        this.table.getActionMap().put("zoom in", new ZoomAction(true, this.table));
        this.table.getActionMap().put("zoom out", new ZoomAction(false, this.table));
        this.table.getColumnModel().getColumn(3).setWidth(0);
        this.table.getColumnModel().getColumn(3).setMinWidth(0);
        this.table.getColumnModel().getColumn(3).setMaxWidth(0);
        this.table.setDefaultRenderer(Object.class, new CellBorderRenderer());
        this.table.setDefaultEditor(Object.class, null);
        this.v = 20;
        this.h = 30;
        this.sp = new JScrollPane(this.table, this.v, this.h);
        this.statusToolBarPanel = UIFactory.createGradientPanel();
        this.zoomInBtn = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/zoom-in.png"))));
        this.zoomOutBtn = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/zoom-out.png"))));
        this.propDetailsTextArea = UIFactory.createGradientEditorPane();
        this.propDetailsTextArea.setEditable(false);
        this.propDetailsTextArea.setContentType("text/html");
        this.setLayout();
        new PropertyAuditController(this);
    }

    private void setLayout() {
        this.propertyAuditDio.add(this.propertyAuditPanel);
        this.propertyAuditPanel.setLayout(new BorderLayout());
        this.propertyAuditPanel.add("North", this.propertyTopBasePanel);
        this.propertyTopBasePanel.setLayout(new FlowLayout(2, 1, 1));
        this.propertyTopBasePanel.add(this.manageDocumentBtn);
        this.propertyTopBasePanel.add(this.shareWithOwnerBtn);
        this.propertyAuditPanel.add(this.splitPane);
        this.splitPane.setLeftComponent(this.sp);
        this.splitPane.setRightComponent(new JScrollPane(this.propDetailsTextArea));
        this.propertyAuditPanel.add("South", this.statusToolBarPanel);
        this.statusToolBarPanel.setLayout(new FlowLayout(0, 2, 2));
        this.statusToolBarPanel.add(this.zoomOutBtn);
        this.statusToolBarPanel.add(this.zoomInBtn);
    }

    public JDialog getPropertyAuditDio() {
        return this.propertyAuditDio;
    }

    public DefaultTableModel getDefaultTableModel() {
        return this.defaultTableModel;
    }

    public JTable getTable() {
        return this.table;
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public JEditorPane getPropDetailsTextArea() {
        return this.propDetailsTextArea;
    }

    public JButton getShareWithOwnerBtn() {
        return this.shareWithOwnerBtn;
    }

    public String getPropertyAddress() {
        return this.propertyAddress;
    }

    public void setPropertyAddress(String propertyAddress) {
        this.propertyAddress = propertyAddress;
    }

    public JButton getZoomInBtn() {
        return this.zoomInBtn;
    }

    public JButton getZoomOutBtn() {
        return this.zoomOutBtn;
    }

    public JButton getManageDocumentBtn() {
        return this.manageDocumentBtn;
    }

    private static class CellBorderRenderer
    extends DefaultTableCellRenderer {
        private CellBorderRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Border border = BorderFactory.createLineBorder(new Color(90, 168, 204));
            JComponent comp = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            comp.setBorder(border);
            String rentStatus = (String)table.getValueAt(row, 2);
            if (isSelected) {
                this.setBackground(new Color(90, 168, 204));
            } else if ("ON RENT".equals(rentStatus)) {
                this.setBackground(new Color(212, 237, 218, 255));
            } else {
                this.setBackground(table.getBackground());
            }
            switch (column) {
                case 0: {
                    this.setHorizontalAlignment(0);
                    break;
                }
                default: {
                    this.setHorizontalAlignment(2);
                }
            }
            return comp;
        }
    }
}

