/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.view.property;

import com.arun.bhardwaj.controller.property.PropertyRecordController;
import com.arun.bhardwaj.customcomponent.NumberTextField;
import com.arun.bhardwaj.factory.UIFactory;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.utility.NumberToWordsConverter;
import com.arun.bhardwaj.view.LoginView;
import com.arun.bhardwaj.view.project.ProjectDetailsView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableModel;

public class PropertyRecordView {
    private final JDialog dio = new JDialog(LoginView.frame, "New Record", true);
    private JTabbedPane tabbedPane = new JTabbedPane(2);
    private final JPanel basePanel = new JPanel();
    private final JPanel fieldsPanel = new JPanel(new GridBagLayout());
    private final JPanel fieldBasePanel = new JPanel();
    private Container availableForContainer;
    private JLabel availabilityLabel;
    private GridBagConstraints gbc = new GridBagConstraints();
    private JLabel basicHeadingLabel;
    private final JButton contactBtn;
    private final JLabel depositLabel;
    private final JLabel rentLabel;
    private final JLabel sellingPriceLabel;
    private final JLabel partyNameLabel;
    private final JLabel sellingPriceInWordsLabel;
    private final JLabel depositInWordLabel;
    private final JLabel rentInWordLabel;
    private final Container sellingPriceContainer;
    private final Container depositContainer;
    private final Container rentContainer;
    private final JTextField dateTf;
    private final Container dateContainer;
    private final JTextField locationTf;
    private final JTextField addressTf;
    private final JTextField cityTf;
    private final NumberTextField pinTf;
    private final NumberTextField areaInSqftTf;
    private final NumberTextField depositTf;
    private final NumberTextField rentTf;
    private final NumberTextField priceTf;
    private final JButton areaConversionBtn;
    private final JButton dateBtn;
    private int leaseId;
    static JTextField offeredByNameTf;
    static JTextField offeredByNameIdTf;
    private Container offeredByContainer;
    private final JComboBox furnishingStatusCB;
    private final JComboBox offeredByCB;
    private final JTextArea commentsTextArea;
    private final JCheckBox forRent;
    private final JCheckBox forSell;
    private final JCheckBox onRent;
    private final JCheckBox unAvailable;
    private final JTextField unAvailableUntilTf;
    private final JButton unAvailableUntilBtn;
    static JComboBox groupNames;
    private final JButton addNewGroup;
    private final JToolBar tb3;
    private final JPanel tbBasePanel;
    public final JButton saveBtn;
    public final JButton closeBtn;
    public final JButton updateBtn;
    private JPanel addDetailsBasePanel;
    private JPanel additionalDetailsPanel;
    private JPanel additionalDetailsFormPanel;
    private GridBagConstraints additionalDetailsGbc;
    private JToolBar addDetailsHeaderToolBar;
    private JLabel addDetailsHeaderLabel;
    private JTextField additionalDetailsNameTf;
    private JTextField additionalDetailsValueTf;
    private JButton addAdditionalDetailsButton;
    private JButton clearAdditionalDetailsButton;
    private JTable additionalDetailsTable;
    private ListSelectionModel additionalDetailsSelectionModel;
    private DefaultTableModel additionalDetailsDefaultTableModel;
    private JMenuItem deleteAdditionalDetailsPopupMenu;
    private PropertyRecordController propertyRecordController;

    public PropertyRecordView() {
        this.gbc.insets = new Insets(2, 2, 2, 2);
        this.basicHeadingLabel = new JLabel("   Basic Details");
        this.basicHeadingLabel.setFont(this.basicHeadingLabel.getFont().deriveFont(18.0f));
        this.basicHeadingLabel.setForeground(new Color(63, 151, 255, 255));
        this.availableForContainer = new Container();
        this.forRent = new JCheckBox("Rent", true);
        this.forSell = new JCheckBox("Sell");
        this.onRent = new JCheckBox("On Rent");
        this.onRent.setEnabled(false);
        this.onRent.setVisible(false);
        this.availabilityLabel = new JLabel("<html>Available for <span style='color: red;'>*</span> </html>");
        this.unAvailable = new JCheckBox("Unavailable");
        this.unAvailableUntilTf = new JTextField(7);
        this.unAvailableUntilTf.setEditable(false);
        this.unAvailableUntilBtn = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/date.png"))));
        this.unAvailableUntilTf.setVisible(false);
        this.unAvailableUntilBtn.setVisible(false);
        this.tbBasePanel = UIFactory.createGradientPanel();
        this.tb3 = new JToolBar();
        this.tb3.setFloatable(false);
        this.depositLabel = new JLabel("<html>Deposit<span style='color: red;'>*</span> </html>");
        this.rentLabel = new JLabel("<html>Rent<span style='color: red;'>*</span> </html>");
        this.sellingPriceLabel = new JLabel("Selling Price ");
        this.sellingPriceInWordsLabel = new JLabel(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/info.png"))));
        this.rentInWordLabel = new JLabel(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/info.png"))));
        this.depositInWordLabel = new JLabel(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/info.png"))));
        this.sellingPriceContainer = new JPanel(new FlowLayout(0, 2, 2));
        this.depositContainer = new JPanel(new FlowLayout(0, 2, 2));
        this.rentContainer = new JPanel(new FlowLayout(0, 2, 2));
        this.partyNameLabel = new JLabel("<html>Owner's Name<span style='color: red;'>*</span></html> ");
        this.dateContainer = new JPanel(new FlowLayout(0, 2, 2));
        this.dateTf = new JTextField(13);
        this.dateTf.setEditable(false);
        this.addressTf = new JTextField(19);
        this.locationTf = new JTextField(15);
        this.pinTf = new NumberTextField(10);
        this.cityTf = new JTextField(16);
        this.depositTf = new NumberTextField(20);
        this.rentTf = new NumberTextField(20);
        this.areaInSqftTf = new NumberTextField(20);
        this.priceTf = new NumberTextField(20);
        this.depositTf.setPreferredSize(new Dimension(152, 32));
        this.rentTf.setPreferredSize(new Dimension(182, 32));
        this.areaInSqftTf.setPreferredSize(new Dimension(187, 32));
        this.priceTf.setPreferredSize(new Dimension(140, 32));
        this.pinTf.setPreferredSize(new Dimension(220, 32));
        this.sellingPriceInWordsLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                String currentText = PropertyRecordView.this.priceTf.getText();
                if (!currentText.trim().isEmpty()) {
                    PropertyRecordView.this.sellingPriceInWordsLabel.setToolTipText(NumberToWordsConverter.convertToIndianWords(Long.parseLong(currentText)));
                }
            }
        });
        this.depositInWordLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                String currentText = PropertyRecordView.this.depositTf.getText();
                if (!currentText.trim().isEmpty()) {
                    PropertyRecordView.this.depositInWordLabel.setToolTipText(NumberToWordsConverter.convertToIndianWords(Long.parseLong(currentText)));
                }
            }
        });
        this.rentInWordLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                String currentText = PropertyRecordView.this.rentTf.getText();
                if (!currentText.trim().isEmpty()) {
                    PropertyRecordView.this.rentInWordLabel.setToolTipText(NumberToWordsConverter.convertToIndianWords(Long.parseLong(currentText)));
                }
            }
        });
        this.areaConversionBtn = new JButton("C");
        offeredByNameTf = new JTextField(12);
        offeredByNameTf.setEditable(false);
        this.offeredByContainer = new Container();
        this.dateBtn = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/date.png"))));
        offeredByNameIdTf = new JTextField();
        offeredByNameIdTf.setEditable(false);
        this.contactBtn = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/contacts.png"))));
        this.furnishingStatusCB = new JComboBox();
        this.offeredByCB = new JComboBox();
        this.furnishingStatusCB.setPreferredSize(new Dimension(180, 35));
        this.offeredByCB.setPreferredSize(new Dimension(180, 35));
        this.commentsTextArea = new JTextArea(4, 36);
        groupNames = new JComboBox();
        groupNames.setPreferredSize(new Dimension(180, 35));
        this.addNewGroup = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/add-s.png"))));
        this.saveBtn = new JButton("Save", new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/save.png"))));
        this.closeBtn = new JButton("Close", new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/close-s.png"))));
        this.updateBtn = new JButton("Update", new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/update-s.png"))));
        this.addDetailsBasePanel = new JPanel();
        this.addDetailsHeaderToolBar = UIFactory.createGradientToolBar();
        this.addDetailsHeaderLabel = new JLabel("  Additional Details");
        this.addDetailsHeaderLabel.setFont(this.addDetailsHeaderLabel.getFont().deriveFont(18.0f));
        this.addDetailsHeaderLabel.setForeground(new Color(63, 151, 255, 255));
        this.additionalDetailsPanel = new JPanel();
        this.additionalDetailsPanel.setLayout(new BorderLayout(2, 2));
        this.additionalDetailsFormPanel = new JPanel(new GridBagLayout());
        this.additionalDetailsGbc = new GridBagConstraints();
        this.additionalDetailsGbc.insets = new Insets(2, 2, 2, 2);
        this.additionalDetailsNameTf = new JTextField(20);
        this.additionalDetailsValueTf = new JTextField(20);
        this.addAdditionalDetailsButton = UIFactory.createCustomButton("Add", "SUCCESS");
        this.clearAdditionalDetailsButton = UIFactory.createCustomButton("Clear", "DANGER");
        Object[] additionalDtsColumns = new Object[]{"additionalDetilsId", "Name", "Value"};
        this.additionalDetailsDefaultTableModel = new DefaultTableModel(additionalDtsColumns, 0);
        this.additionalDetailsTable = new JTable(this.additionalDetailsDefaultTableModel){

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int rowIndex = this.rowAtPoint(p);
                int colIndex = this.columnAtPoint(p);
                if (colIndex >= 0 && rowIndex >= 0) {
                    Object value = this.getValueAt(rowIndex, colIndex);
                    return value != null ? value.toString() : null;
                }
                return null;
            }
        };
        this.additionalDetailsTable.setRowSelectionAllowed(true);
        this.additionalDetailsTable.setSelectionMode(0);
        this.additionalDetailsSelectionModel = this.additionalDetailsTable.getSelectionModel();
        this.additionalDetailsTable.getColumnModel().getColumn(0).setWidth(0);
        this.additionalDetailsTable.getColumnModel().getColumn(0).setMinWidth(0);
        this.additionalDetailsTable.getColumnModel().getColumn(0).setMaxWidth(0);
        this.additionalDetailsTable.setDefaultRenderer(Object.class, new ProjectDetailsView.CellBorderRenderer());
        JPopupMenu pmAdditionalDetails = new JPopupMenu();
        this.deleteAdditionalDetailsPopupMenu = new JMenuItem("Delete Record", new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/delete-s.png"))));
        pmAdditionalDetails.add(this.deleteAdditionalDetailsPopupMenu);
        this.additionalDetailsTable.setComponentPopupMenu(pmAdditionalDetails);
        this.setLayout();
        this.propertyRecordController = new PropertyRecordController(this);
    }

    private void setLayout() {
        this.dio.getContentPane().add(this.basePanel);
        this.basePanel.setLayout(new BorderLayout(2, 2));
        this.basePanel.add(this.tabbedPane);
        this.tabbedPane.addTab("", new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/basic.png"))), this.fieldBasePanel, "Basics Information");
        this.tabbedPane.addTab("", new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/additional.png"))), this.addDetailsBasePanel, "Additional Details");
        this.fieldBasePanel.setLayout(new BorderLayout(2, 2));
        this.fieldBasePanel.add("North", this.basicHeadingLabel);
        this.fieldBasePanel.add(this.fieldsPanel);
        this.gbc.anchor = 17;
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.fieldsPanel.add((Component)new JLabel("Source"), this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.fieldsPanel.add((Component)this.offeredByCB, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 2;
        this.fieldsPanel.add((Component)new JLabel("<html>Property Type<span style='color: red;'>*</span> </html>"), this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 3;
        this.fieldsPanel.add((Component)groupNames, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 4;
        this.fieldsPanel.add((Component)new JLabel("Location"), this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 5;
        this.fieldsPanel.add((Component)this.locationTf, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 6;
        this.fieldsPanel.add((Component)this.sellingPriceLabel, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 7;
        this.fieldsPanel.add((Component)this.sellingPriceContainer, this.gbc);
        this.sellingPriceContainer.add(this.priceTf);
        this.sellingPriceContainer.add(this.sellingPriceInWordsLabel);
        this.gbc.gridx = 0;
        this.gbc.gridy = 8;
        this.fieldsPanel.add((Component)new JLabel("Furnishing Status"), this.gbc);
        this.gbc.anchor = 18;
        this.gbc.gridx = 0;
        this.gbc.gridy = 9;
        this.fieldsPanel.add((Component)this.furnishingStatusCB, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 10;
        this.fieldsPanel.add((Component)this.partyNameLabel, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 11;
        this.fieldsPanel.add((Component)this.offeredByContainer, this.gbc);
        this.offeredByContainer.setLayout(new FlowLayout(0, 2, 2));
        this.offeredByContainer.add(offeredByNameTf);
        this.offeredByContainer.add(this.contactBtn);
        this.gbc.anchor = 17;
        this.gbc.gridx = 1;
        this.gbc.gridy = 0;
        this.fieldsPanel.add((Component)new JLabel("<html>Date<span style='color: red;'>*</span></html>"), this.gbc);
        this.gbc.gridx = 1;
        this.gbc.gridy = 1;
        this.fieldsPanel.add((Component)this.dateContainer, this.gbc);
        this.dateContainer.add(this.dateTf);
        this.dateContainer.add(this.dateBtn);
        this.gbc.gridx = 1;
        this.gbc.gridy = 2;
        this.fieldsPanel.add((Component)new JLabel("Area"), this.gbc);
        this.gbc.gridx = 1;
        this.gbc.gridy = 3;
        this.fieldsPanel.add((Component)this.areaInSqftTf, this.gbc);
        this.gbc.gridx = 1;
        this.gbc.gridy = 4;
        this.fieldsPanel.add((Component)new JLabel("City"), this.gbc);
        this.gbc.gridx = 1;
        this.gbc.gridy = 5;
        this.fieldsPanel.add((Component)this.cityTf, this.gbc);
        this.gbc.gridx = 1;
        this.gbc.gridy = 6;
        this.fieldsPanel.add((Component)this.depositLabel, this.gbc);
        this.gbc.gridx = 1;
        this.gbc.gridy = 7;
        this.fieldsPanel.add((Component)this.depositContainer, this.gbc);
        this.depositContainer.add(this.depositTf);
        this.depositContainer.add(this.depositInWordLabel);
        this.gbc.gridx = 1;
        this.gbc.gridy = 8;
        this.fieldsPanel.add((Component)new JLabel("Comments"), this.gbc);
        this.gbc.gridwidth = 3;
        this.gbc.gridheight = 3;
        this.gbc.gridx = 1;
        this.gbc.gridy = 9;
        this.fieldsPanel.add((Component)new JScrollPane(this.commentsTextArea), this.gbc);
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.gbc.gridx = 2;
        this.gbc.gridy = 0;
        this.fieldsPanel.add((Component)this.availabilityLabel, this.gbc);
        this.gbc.gridx = 2;
        this.gbc.gridy = 1;
        this.fieldsPanel.add((Component)this.availableForContainer, this.gbc);
        this.availableForContainer.setLayout(new FlowLayout(0, 2, 2));
        this.availableForContainer.add(this.onRent);
        this.availableForContainer.add(this.forRent);
        this.availableForContainer.add(this.forSell);
        this.availableForContainer.add(this.unAvailable);
        this.availableForContainer.add(this.unAvailableUntilTf);
        this.availableForContainer.add(this.unAvailableUntilBtn);
        this.gbc.gridwidth = 2;
        this.gbc.gridx = 2;
        this.gbc.gridy = 2;
        this.fieldsPanel.add((Component)new JLabel("<html>Address<span style='color: red;'>*</span></html>"), this.gbc);
        this.gbc.gridx = 2;
        this.gbc.gridy = 3;
        this.fieldsPanel.add((Component)this.addressTf, this.gbc);
        this.gbc.gridx = 2;
        this.gbc.gridy = 4;
        this.fieldsPanel.add((Component)new JLabel("PIN"), this.gbc);
        this.gbc.gridx = 2;
        this.gbc.gridy = 5;
        this.fieldsPanel.add((Component)this.pinTf, this.gbc);
        this.gbc.gridx = 2;
        this.gbc.gridy = 6;
        this.fieldsPanel.add((Component)this.rentLabel, this.gbc);
        this.gbc.gridx = 2;
        this.gbc.gridy = 7;
        this.fieldsPanel.add((Component)this.rentContainer, this.gbc);
        this.rentContainer.add(this.rentTf);
        this.rentContainer.add(this.rentInWordLabel);
        this.gbc.gridwidth = 1;
        this.basePanel.add("South", this.tbBasePanel);
        this.tbBasePanel.setLayout(new FlowLayout(2, 1, 1));
        this.tbBasePanel.add(this.updateBtn);
        this.tbBasePanel.add(this.saveBtn);
        this.tbBasePanel.add(this.closeBtn);
        this.addDetailsBasePanel.setLayout(new BorderLayout(2, 2));
        this.addDetailsBasePanel.add("North", this.addDetailsHeaderToolBar);
        this.addDetailsHeaderToolBar.add(this.addDetailsHeaderLabel);
        this.addDetailsBasePanel.add(this.additionalDetailsPanel);
        this.additionalDetailsPanel.add("North", this.additionalDetailsFormPanel);
        this.additionalDetailsGbc.anchor = 17;
        this.additionalDetailsGbc.gridx = 0;
        this.additionalDetailsGbc.gridy = 0;
        this.additionalDetailsFormPanel.add((Component)new JLabel("<html>Name<span style='color: red;'>*</span></html>"), this.additionalDetailsGbc);
        this.additionalDetailsGbc.gridx = 0;
        this.additionalDetailsGbc.gridy = 1;
        this.additionalDetailsFormPanel.add((Component)this.additionalDetailsNameTf, this.additionalDetailsGbc);
        this.additionalDetailsGbc.gridx = 1;
        this.additionalDetailsGbc.gridy = 0;
        this.additionalDetailsFormPanel.add((Component)new JLabel("<html>Value<span style='color: red;'>*</span></html>"), this.additionalDetailsGbc);
        this.additionalDetailsGbc.gridx = 1;
        this.additionalDetailsGbc.gridy = 1;
        this.additionalDetailsFormPanel.add((Component)this.additionalDetailsValueTf, this.additionalDetailsGbc);
        this.additionalDetailsGbc.gridx = 2;
        this.additionalDetailsGbc.gridy = 1;
        this.additionalDetailsFormPanel.add((Component)this.addAdditionalDetailsButton, this.additionalDetailsGbc);
        this.additionalDetailsGbc.gridx = 3;
        this.additionalDetailsGbc.gridy = 1;
        this.additionalDetailsFormPanel.add((Component)this.clearAdditionalDetailsButton, this.additionalDetailsGbc);
        this.additionalDetailsPanel.add(new JScrollPane(this.additionalDetailsTable));
        this.dio.setMinimumSize(new Dimension(720, 510));
        AppUtility.setDialogLocationInCenter(this.dio);
    }

    public JDialog getDio() {
        return this.dio;
    }

    public JButton getSaveBtn() {
        return this.saveBtn;
    }

    public JButton getUpdateBtn() {
        return this.updateBtn;
    }

    public JButton getCloseBtn() {
        return this.closeBtn;
    }

    public JButton getContactBtn() {
        return this.contactBtn;
    }

    public static JComboBox getGroupNames() {
        return groupNames;
    }

    public static JTextField getOfferedByNameTf() {
        return offeredByNameTf;
    }

    public static JTextField getOfferedByNameIdTf() {
        return offeredByNameIdTf;
    }

    public JTextField getAddressTf() {
        return this.addressTf;
    }

    public JTextField getLocationTf() {
        return this.locationTf;
    }

    public JTextField getCityTf() {
        return this.cityTf;
    }

    public JTextField getPinTf() {
        return this.pinTf;
    }

    public JTextField getDepositTf() {
        return this.depositTf;
    }

    public JTextField getRentTf() {
        return this.rentTf;
    }

    public JComboBox getOfferedByCB() {
        return this.offeredByCB;
    }

    public JComboBox getFurnishingStatusCB() {
        return this.furnishingStatusCB;
    }

    public JTextArea getCommentsTextArea() {
        return this.commentsTextArea;
    }

    public JTextField getAreaInSqftTf() {
        return this.areaInSqftTf;
    }

    public JTextField getPriceTf() {
        return this.priceTf;
    }

    public JCheckBox getForRent() {
        return this.forRent;
    }

    public JCheckBox getForSell() {
        return this.forSell;
    }

    public JCheckBox getOnRent() {
        return this.onRent;
    }

    public JTextField getDateTf() {
        return this.dateTf;
    }

    public JButton getDateBtn() {
        return this.dateBtn;
    }

    public PropertyRecordController getPropertyRecordController() {
        return this.propertyRecordController;
    }

    public JButton getAddNewGroup() {
        return this.addNewGroup;
    }

    public JButton getAreaConversionBtn() {
        return this.areaConversionBtn;
    }

    public JLabel getDepositLabel() {
        return this.depositLabel;
    }

    public JLabel getRentLabel() {
        return this.rentLabel;
    }

    public JLabel getSellingPriceLabel() {
        return this.sellingPriceLabel;
    }

    public JLabel getPartyNameLabel() {
        return this.partyNameLabel;
    }

    public JButton getAddAdditionalDetailsButton() {
        return this.addAdditionalDetailsButton;
    }

    public JButton getClearAdditionalDetailsButton() {
        return this.clearAdditionalDetailsButton;
    }

    public JTable getAdditionalDetailsTable() {
        return this.additionalDetailsTable;
    }

    public DefaultTableModel getAdditionalDetailsDefaultTableModel() {
        return this.additionalDetailsDefaultTableModel;
    }

    public JMenuItem getDeleteAdditionalDetailsPopupMenu() {
        return this.deleteAdditionalDetailsPopupMenu;
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public int getLeaseId() {
        return this.leaseId;
    }

    public void setLeaseId(int leaseId) {
        this.leaseId = leaseId;
    }

    public JTextField getAdditionalDetailsNameTf() {
        return this.additionalDetailsNameTf;
    }

    public JTextField getAdditionalDetailsValueTf() {
        return this.additionalDetailsValueTf;
    }

    public JCheckBox getUnAvailable() {
        return this.unAvailable;
    }

    public JTextField getUnAvailableUntilTf() {
        return this.unAvailableUntilTf;
    }

    public JButton getUnAvailableUntilBtn() {
        return this.unAvailableUntilBtn;
    }

    public JLabel getAvailabilityLabel() {
        return this.availabilityLabel;
    }
}

