/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.view.property;

import com.arun.bhardwaj.controller.property.PropertyController;
import com.arun.bhardwaj.customcomponent.NumberTextField;
import com.arun.bhardwaj.factory.UIFactory;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.utility.NumberToWordsConverter;
import com.arun.bhardwaj.utility.ZoomAction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Objects;
import java.util.stream.IntStream;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class PropertyView
extends JPanel {
    private final JSplitPane splitPane = new JSplitPane(1, true);
    private final JPanel leftPanel;
    private final JPanel rightPanel;
    private final JPanel rightDataPanel;
    private final JPanel filterDataPanel;
    private final JToolBar filterDataToolBar;
    private final JToolBar propertyToolsBar;
    private final JPanel filterPanel;
    private final JEditorPane notificationEditorPanel;
    private final JPanel downFiltersPanel;
    private final JComboBox offeredTypeFilterCb;
    private final JComboBox furnishingStatusFilterCb;
    private final JPanel filterBasePanel;
    private final JToolBar filterToolBar;
    private final JPanel filterDownToolBar;
    private final JComboBox searchCb;
    private final JTextField addressTf;
    private final JTextField locationTf;
    private final JTextField cityTf;
    private final JTextField pinTf;
    private final JTextField depositFromTf;
    private final JTextField depositTo;
    private final JTextField rentFromTf;
    private final JTextField rentTo;
    private final JTextField priceFrom;
    private final JTextField priceTo;
    private final JButton chooseContactSearchBtn;
    private final JLabel selectedContactName;
    private int selectedContactId;
    private JTextField commentsTf;
    private JTextField additionalInfoTf;
    private final JButton searchBtn;
    private final JToolBar topToolBar;
    private final JToolBar statusToolBar;
    private final JButton newBtn;
    private final JButton newGBtn;
    private final JButton updRBtn;
    private final JButton updGBtn;
    private final JButton delBtn;
    private final JButton delGBtn;
    private final JButton propertyOnRentBtn;
    private final JButton sellOfAssetBtn;
    private final JButton propertyHistoryBtn;
    private final JButton refBtn;
    private final JButton showPieChartBtn;
    private final JButton manageDocumentBtn;
    private final JCheckBox rentCB;
    private final JCheckBox sellCB;
    private final JCheckBox onRentCB;
    private final JCheckBox pendingForRenewal;
    private final JCheckBox notForRentAndSell;
    private final JCheckBox alreadyAvailableCheckBox;
    private final JCheckBox availableWithinCheckBox;
    private final NumberTextField availableWithinTextField;
    private JComboBox groupList;
    private final DefaultTableModel defaultTableModel;
    private final JTable table;
    private final JMenuItem updatePopupMenu;
    private final JMenuItem deletePopupMenu;
    private final JMenuItem newPopupMenu;
    private final JMenuItem refPopupMenu;
    private final JMenuItem manageSellPopupMenu;
    private final JMenuItem manageRentPopupMenu;
    private final JMenuItem historyPopupMenu;
    private final JMenuItem agentDetailsPopupMenu;
    private final JMenuItem ownerDetailsPopupMenu;
    private final JMenuItem tenantDetailsPopupMenu;
    private final JMenuItem showChartPopupMenu;
    private final JMenuItem manageDocumentPopupMenu;
    private final JPanel statisticsPanel;
    private final JLabel statisticsLabel;
    private final JLabel pendingForRenewalLabel;
    private final ListSelectionModel selectionModel;
    private final JPanel statusPanel;
    private final JButton zoomInBtn;
    private final JButton zoomOutBtn;
    private final PropertyController propertyController;
    private final JButton homeLoanCalculator;
    private final JButton calculator;
    private final int PAGE_SIZE = 50;
    private int currentPage = 1;
    private int totalRecords = 0;
    private final JButton prevButton;
    private final JButton nextButton;
    private final JLabel pageLabel;

    public PropertyView() {
        this.splitPane.setDividerLocation(200);
        this.splitPane.setOneTouchExpandable(true);
        this.leftPanel = new JPanel();
        this.filterPanel = new JPanel();
        this.filterBasePanel = new JPanel();
        this.filterToolBar = UIFactory.createGradientToolBar();
        this.filterToolBar.setFloatable(false);
        String[] searchBy = new String[]{"Select", "Address", "Deposit", "Rent", "Price", "Offered by", "Tenant", "Comments", "Additional Info"};
        this.searchCb = new JComboBox<String>(searchBy);
        this.addressTf = new JTextField("address");
        this.locationTf = new JTextField("location");
        this.cityTf = new JTextField("city");
        this.pinTf = new JTextField("pin");
        this.addressTf.setVisible(false);
        this.locationTf.setVisible(false);
        this.cityTf.setVisible(false);
        this.pinTf.setVisible(false);
        this.depositFromTf = new JTextField("deposit from");
        this.depositTo = new JTextField("deposit to");
        this.depositFromTf.setVisible(false);
        this.depositTo.setVisible(false);
        this.rentFromTf = new JTextField("rent from");
        this.rentTo = new JTextField("rent to");
        this.rentFromTf.setVisible(false);
        this.rentTo.setVisible(false);
        this.priceFrom = new JTextField("price from");
        this.priceTo = new JTextField("price to");
        this.priceFrom.setVisible(false);
        this.priceTo.setVisible(false);
        this.commentsTf = new JTextField("comments");
        this.commentsTf.setVisible(false);
        this.additionalInfoTf = new JTextField("Additional Info");
        this.additionalInfoTf.setVisible(false);
        this.chooseContactSearchBtn = new JButton("Select contact");
        this.chooseContactSearchBtn.setVisible(false);
        this.selectedContactName = new JLabel("");
        this.filterDownToolBar = UIFactory.createGradientPanel();
        this.filterDownToolBar.setLayout(new FlowLayout(2, 2, 2));
        this.searchBtn = new JButton("Search");
        this.searchBtn.setVisible(false);
        this.notificationEditorPanel = UIFactory.createGradientEditorPane();
        this.notificationEditorPanel.setEditable(false);
        this.notificationEditorPanel.setContentType("text/html");
        this.downFiltersPanel = new JPanel();
        this.offeredTypeFilterCb = new JComboBox();
        this.furnishingStatusFilterCb = new JComboBox();
        this.rightPanel = new JPanel();
        this.rightDataPanel = new JPanel();
        this.filterDataPanel = new JPanel();
        this.filterDataPanel.setLayout(new BorderLayout(2, 2));
        this.filterDataToolBar = new JToolBar();
        this.topToolBar = UIFactory.createGradientToolBar();
        this.topToolBar.setFloatable(false);
        this.statusToolBar = new JToolBar();
        this.statusToolBar.setFloatable(false);
        this.statisticsPanel = UIFactory.createGradientPanel();
        this.statisticsLabel = new JLabel("");
        this.statisticsLabel.setForeground(new Color(63, 151, 255, 255));
        this.pendingForRenewalLabel = new JLabel("");
        this.pendingForRenewalLabel.setForeground(new Color(227, 3, 39, 255));
        this.newBtn = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/new.png"))));
        this.newGBtn = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/newg.png"))));
        this.updRBtn = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/update.png"))));
        this.updGBtn = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/update.png"))));
        this.delBtn = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/delete.png"))));
        this.delGBtn = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/deleteg.png"))));
        this.propertyOnRentBtn = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/manage-rent.png"))));
        this.sellOfAssetBtn = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/sell.png"))));
        this.propertyHistoryBtn = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/history.png"))));
        this.refBtn = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/refresh.png"))));
        this.showPieChartBtn = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/chart.png"))));
        this.manageDocumentBtn = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/documents.png"))));
        this.rentCB = new JCheckBox("For rent", true);
        this.sellCB = new JCheckBox("For sell", true);
        this.onRentCB = new JCheckBox("Currently rented", true);
        this.pendingForRenewal = new JCheckBox("Renewal due");
        this.pendingForRenewal.setForeground(new Color(227, 3, 39, 255));
        this.pendingForRenewal.setVisible(false);
        this.notForRentAndSell = new JCheckBox("Unavailable properties");
        this.alreadyAvailableCheckBox = new JCheckBox("Already available");
        this.availableWithinCheckBox = new JCheckBox("Available within days");
        this.availableWithinTextField = new NumberTextField(4);
        this.alreadyAvailableCheckBox.setVisible(false);
        this.availableWithinCheckBox.setVisible(false);
        this.availableWithinTextField.setVisible(false);
        this.availableWithinTextField.setPreferredSize(new Dimension(42, 24));
        this.groupList = new JComboBox();
        this.groupList.setPreferredSize(new Dimension(120, 22));
        Object[] columns = new Object[]{"Sno", "Date", "Type", "Address", "Status", "Area SqFt", "Price", "Deposit", "Rent", "Comments", "LeaseId", "isContactExpired", "Lease Duration"};
        this.defaultTableModel = new DefaultTableModel(columns, 0);
        this.table = new JTable(this.defaultTableModel){

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int rowIndex = this.rowAtPoint(p);
                int colIndex = this.columnAtPoint(p);
                if (colIndex >= 0 && rowIndex >= 0) {
                    Object value = this.getValueAt(rowIndex, colIndex);
                    if (colIndex == 5) {
                        return value != null ? NumberToWordsConverter.convertToIndianWords(Integer.parseInt(value.toString())) : null;
                    }
                    if (colIndex == 6 || colIndex == 7 || colIndex == 8) {
                        return value != null ? NumberToWordsConverter.convertToIndianWords(Integer.parseInt(AppUtility.removeCurrencyAndCommas(value.toString()))) : null;
                    }
                    return value != null ? value.toString() : null;
                }
                return null;
            }
        };
        this.table.setRowSelectionAllowed(true);
        this.table.setSelectionMode(2);
        this.selectionModel = this.table.getSelectionModel();
        this.table.setDefaultRenderer(Object.class, new CellBorderRenderer());
        this.table.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(120);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(350);
        this.table.getColumnModel().getColumn(4).setPreferredWidth(200);
        this.table.getColumnModel().getColumn(5).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(6).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(7).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(8).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(9).setPreferredWidth(200);
        this.table.setAutoResizeMode(4);
        InputMap im = this.table.getInputMap(2);
        im.put(KeyStroke.getKeyStroke(61, 128), "zoom in");
        im.put(KeyStroke.getKeyStroke(45, 128), "zoom out");
        this.table.getActionMap().put("zoom in", new ZoomAction(true, this.table));
        this.table.getActionMap().put("zoom out", new ZoomAction(false, this.table));
        this.table.getColumnModel().getColumn(0).setWidth(0);
        this.table.getColumnModel().getColumn(0).setMinWidth(0);
        this.table.getColumnModel().getColumn(0).setMaxWidth(0);
        IntStream.range(10, 12).forEach(i -> {
            this.table.getColumnModel().getColumn(i).setWidth(0);
            this.table.getColumnModel().getColumn(i).setMinWidth(0);
            this.table.getColumnModel().getColumn(i).setMaxWidth(0);
        });
        this.table.setDefaultEditor(Object.class, null);
        JPopupMenu pm = new JPopupMenu();
        this.updatePopupMenu = new JMenuItem("Update Record", new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/update-s.png"))));
        this.deletePopupMenu = new JMenuItem("Delete Record", new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/delete-s.png"))));
        this.historyPopupMenu = new JMenuItem("History", new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/history-s.png"))));
        this.newPopupMenu = new JMenuItem("New Record", new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/new-s.png"))));
        this.refPopupMenu = new JMenuItem("Refresh", new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/ref-s.png"))));
        this.manageRentPopupMenu = new JMenuItem("Manage Rent", new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/manage-rent-s.png"))));
        this.manageSellPopupMenu = new JMenuItem("Manage Sell", new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/sell-s.png"))));
        this.agentDetailsPopupMenu = new JMenuItem("View Agent's Details", new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/view-s.png"))));
        this.ownerDetailsPopupMenu = new JMenuItem("View Owner's Details", new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/view-s.png"))));
        this.tenantDetailsPopupMenu = new JMenuItem("View Tenant's Details", new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/view-s.png"))));
        this.showChartPopupMenu = new JMenuItem("Pie Chart", new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/chart-s.png"))));
        this.manageDocumentPopupMenu = new JMenuItem("Manage Documents", new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/documents-s.png"))));
        pm.add(this.newPopupMenu);
        pm.add(this.updatePopupMenu);
        pm.add(this.deletePopupMenu);
        pm.addSeparator();
        pm.add(this.manageRentPopupMenu);
        pm.add(this.manageSellPopupMenu);
        pm.add(this.agentDetailsPopupMenu);
        pm.add(this.ownerDetailsPopupMenu);
        pm.add(this.tenantDetailsPopupMenu);
        pm.addSeparator();
        pm.add(this.manageDocumentPopupMenu);
        pm.addSeparator();
        pm.add(this.historyPopupMenu);
        pm.add(this.showChartPopupMenu);
        pm.addSeparator();
        pm.add(this.refPopupMenu);
        this.table.setComponentPopupMenu(pm);
        this.statusPanel = new JPanel();
        this.zoomInBtn = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/zoom-in.png"))));
        this.zoomOutBtn = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/zoom-out.png"))));
        this.prevButton = new JButton("Previous");
        this.nextButton = new JButton("Next");
        this.pageLabel = new JLabel("");
        this.propertyToolsBar = UIFactory.createGradientToolBar();
        this.propertyToolsBar.setFloatable(false);
        this.propertyToolsBar.setOrientation(1);
        this.homeLoanCalculator = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/loanCalculator.png"))));
        this.calculator = new JButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/calculator.png"))));
        this.propertyController = new PropertyController(this);
        this.setLayout();
    }

    private void setLayout() {
        this.setLayout(new BorderLayout());
        this.add(this.splitPane);
        this.splitPane.setLeftComponent(this.leftPanel);
        this.leftPanel.setLayout(new BorderLayout());
        this.leftPanel.add("North", this.filterBasePanel);
        this.filterBasePanel.setLayout(new BorderLayout());
        this.filterBasePanel.add("North", this.filterToolBar);
        this.filterToolBar.setLayout(new FlowLayout(0, 2, 2));
        this.filterToolBar.add(new JLabel("Search by"));
        this.filterToolBar.add(this.searchCb);
        this.filterBasePanel.add(this.filterPanel);
        this.filterPanel.setLayout(new BoxLayout(this.filterPanel, 1));
        this.filterPanel.add(this.addressTf);
        this.filterPanel.add(this.locationTf);
        this.filterPanel.add(this.cityTf);
        this.filterPanel.add(this.pinTf);
        this.filterPanel.add(this.depositFromTf);
        this.filterPanel.add(this.depositTo);
        this.filterPanel.add(this.rentFromTf);
        this.filterPanel.add(this.rentTo);
        this.filterPanel.add(this.priceFrom);
        this.filterPanel.add(this.priceTo);
        this.filterPanel.add(this.commentsTf);
        this.filterPanel.add(this.additionalInfoTf);
        this.filterPanel.add(this.selectedContactName);
        this.filterPanel.add(this.chooseContactSearchBtn);
        this.filterBasePanel.add("South", this.filterDownToolBar);
        this.filterDownToolBar.add(this.searchBtn);
        this.leftPanel.add(new JScrollPane(this.notificationEditorPanel));
        this.leftPanel.add("South", this.downFiltersPanel);
        this.downFiltersPanel.setLayout(new BoxLayout(this.downFiltersPanel, 1));
        this.downFiltersPanel.add(this.offeredTypeFilterCb);
        this.downFiltersPanel.add(this.furnishingStatusFilterCb);
        this.splitPane.setRightComponent(this.rightPanel);
        this.rightPanel.setLayout(new BorderLayout());
        this.rightPanel.add("North", this.topToolBar);
        this.topToolBar.add(this.newBtn);
        this.topToolBar.add(this.updRBtn);
        this.topToolBar.add(this.delBtn);
        this.topToolBar.addSeparator();
        this.topToolBar.add(this.newGBtn);
        this.topToolBar.add(this.updGBtn);
        this.topToolBar.add(this.delGBtn);
        this.topToolBar.addSeparator();
        this.topToolBar.add(this.propertyOnRentBtn);
        this.topToolBar.add(this.sellOfAssetBtn);
        this.topToolBar.addSeparator();
        this.topToolBar.add(this.manageDocumentBtn);
        this.topToolBar.add(this.propertyHistoryBtn);
        this.topToolBar.add(this.showPieChartBtn);
        this.topToolBar.add(this.refBtn);
        this.topToolBar.add(this.groupList);
        this.rightPanel.add(this.rightDataPanel);
        this.rightDataPanel.setLayout(new BorderLayout(2, 2));
        this.rightDataPanel.add(new JScrollPane(this.table));
        this.rightDataPanel.add("South", this.filterDataPanel);
        this.filterDataPanel.add("West", this.filterDataToolBar);
        this.filterDataToolBar.setLayout(new FlowLayout(0, 2, 2));
        this.filterDataToolBar.add(this.rentCB);
        this.filterDataToolBar.add(this.sellCB);
        this.filterDataToolBar.add(this.onRentCB);
        this.filterDataToolBar.addSeparator();
        this.filterDataToolBar.add(this.pendingForRenewal);
        this.filterDataToolBar.addSeparator();
        this.filterDataToolBar.add(this.notForRentAndSell);
        this.filterDataToolBar.add(this.alreadyAvailableCheckBox);
        this.filterDataToolBar.add(this.availableWithinCheckBox);
        this.filterDataToolBar.add(this.availableWithinTextField);
        this.filterDataPanel.add("East", this.propertyToolsBar);
        this.propertyToolsBar.setLayout(new FlowLayout(2, 2, 2));
        this.propertyToolsBar.add(this.homeLoanCalculator);
        this.propertyToolsBar.add(this.calculator);
        this.rightPanel.add("South", this.statusToolBar);
        this.statusToolBar.setLayout(new BorderLayout());
        this.statusToolBar.add("West", this.statusPanel);
        this.statusPanel.setLayout(new FlowLayout(0, 2, 2));
        this.statusPanel.add(this.zoomOutBtn);
        this.statusPanel.add(this.zoomInBtn);
        this.statusPanel.add(this.prevButton);
        this.statusPanel.add(this.pageLabel);
        this.statusPanel.add(this.nextButton);
        this.statusToolBar.add(new JScrollPane(this.statisticsPanel));
        this.statisticsPanel.setLayout(new FlowLayout(2));
        this.statisticsPanel.add(this.statisticsLabel);
        this.statisticsPanel.add(this.pendingForRenewalLabel);
    }

    public JButton getNewBtn() {
        return this.newBtn;
    }

    public JButton getNewGBtn() {
        return this.newGBtn;
    }

    public JButton getUpdRBtn() {
        return this.updRBtn;
    }

    public JButton getUpdGBtn() {
        return this.updGBtn;
    }

    public JButton getDelBtn() {
        return this.delBtn;
    }

    public JButton getDelGBtn() {
        return this.delGBtn;
    }

    public JTable getTable() {
        return this.table;
    }

    public JComboBox getGroupList() {
        return this.groupList;
    }

    public DefaultTableModel getDefaultTableModel() {
        return this.defaultTableModel;
    }

    public JComboBox getSearchCb() {
        return this.searchCb;
    }

    public JButton getSearchBtn() {
        return this.searchBtn;
    }

    public JTextField getAddressTf() {
        return this.addressTf;
    }

    public JTextField getLocationTf() {
        return this.locationTf;
    }

    public JTextField getCityTf() {
        return this.cityTf;
    }

    public JTextField getPinTf() {
        return this.pinTf;
    }

    public JTextField getDepositFromTf() {
        return this.depositFromTf;
    }

    public JTextField getDepositTo() {
        return this.depositTo;
    }

    public JTextField getRentFromTf() {
        return this.rentFromTf;
    }

    public JTextField getRentTo() {
        return this.rentTo;
    }

    public JPanel getFilterPanel() {
        return this.filterPanel;
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public JTextField getCommentsTf() {
        return this.commentsTf;
    }

    public JButton getPropertyOnRentBtn() {
        return this.propertyOnRentBtn;
    }

    public JCheckBox getRentCB() {
        return this.rentCB;
    }

    public JCheckBox getSellCB() {
        return this.sellCB;
    }

    public JCheckBox getOnRentCB() {
        return this.onRentCB;
    }

    public JButton getSellOfAssetBtn() {
        return this.sellOfAssetBtn;
    }

    public JButton getPropertyHistoryBtn() {
        return this.propertyHistoryBtn;
    }

    public JButton getRefBtn() {
        return this.refBtn;
    }

    public JLabel getStatisticsLabel() {
        return this.statisticsLabel;
    }

    public JLabel getPendingForRenewalLabel() {
        return this.pendingForRenewalLabel;
    }

    public JCheckBox getNotForRentAndSell() {
        return this.notForRentAndSell;
    }

    public JTextField getPriceFrom() {
        return this.priceFrom;
    }

    public JTextField getPriceTo() {
        return this.priceTo;
    }

    public JComboBox getOfferedTypeFilterCb() {
        return this.offeredTypeFilterCb;
    }

    public JComboBox getFurnishingStatusFilterCb() {
        return this.furnishingStatusFilterCb;
    }

    public JButton getChooseContactSearchBtn() {
        return this.chooseContactSearchBtn;
    }

    public JLabel getSelectedContactName() {
        return this.selectedContactName;
    }

    public int getSelectedContactId() {
        return this.selectedContactId;
    }

    public void setSelectedContactId(int selectedContactId) {
        this.selectedContactId = selectedContactId;
    }

    public JButton getZoomInBtn() {
        return this.zoomInBtn;
    }

    public JButton getZoomOutBtn() {
        return this.zoomOutBtn;
    }

    public JCheckBox getPendingForRenewal() {
        return this.pendingForRenewal;
    }

    public JMenuItem getUpdatePopupMenu() {
        return this.updatePopupMenu;
    }

    public JMenuItem getDeletePopupMenu() {
        return this.deletePopupMenu;
    }

    public JMenuItem getNewPopupMenu() {
        return this.newPopupMenu;
    }

    public JMenuItem getRefPopupMenu() {
        return this.refPopupMenu;
    }

    public JMenuItem getManageSellPopupMenu() {
        return this.manageSellPopupMenu;
    }

    public JMenuItem getManageRentPopupMenu() {
        return this.manageRentPopupMenu;
    }

    public JMenuItem getHistoryPopupMenu() {
        return this.historyPopupMenu;
    }

    public JMenuItem getAgentDetailsPopupMenu() {
        return this.agentDetailsPopupMenu;
    }

    public JMenuItem getOwnerDetailsPopupMenu() {
        return this.ownerDetailsPopupMenu;
    }

    public JMenuItem getTenantDetailsPopupMenu() {
        return this.tenantDetailsPopupMenu;
    }

    public JButton getShowPieChartBtn() {
        return this.showPieChartBtn;
    }

    public JMenuItem getShowChartPopupMenu() {
        return this.showChartPopupMenu;
    }

    public PropertyController getPropertyController() {
        return this.propertyController;
    }

    public JMenuItem getManageDocumentPopupMenu() {
        return this.manageDocumentPopupMenu;
    }

    public JButton getManageDocumentBtn() {
        return this.manageDocumentBtn;
    }

    public JButton getCalculator() {
        return this.calculator;
    }

    public JButton getHomeLoanCalculator() {
        return this.homeLoanCalculator;
    }

    public JEditorPane getNotificationEditorPanel() {
        return this.notificationEditorPanel;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public int getPAGE_SIZE() {
        return 50;
    }

    public int getTotalRecords() {
        return this.totalRecords;
    }

    public void setTotalRecords(int totalRecords) {
        this.totalRecords = totalRecords;
    }

    public JButton getPrevButton() {
        return this.prevButton;
    }

    public JButton getNextButton() {
        return this.nextButton;
    }

    public JLabel getPageLabel() {
        return this.pageLabel;
    }

    public JCheckBox getAlreadyAvailableCheckBox() {
        return this.alreadyAvailableCheckBox;
    }

    public JCheckBox getAvailableWithinCheckBox() {
        return this.availableWithinCheckBox;
    }

    public NumberTextField getAvailableWithinTextField() {
        return this.availableWithinTextField;
    }

    public JTextField getAdditionalInfoTf() {
        return this.additionalInfoTf;
    }

    public static class CellBorderRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Border border = BorderFactory.createLineBorder(new Color(90, 168, 204));
            JComponent comp = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            comp.setBorder(border);
            boolean isContractExpired = (Boolean)table.getValueAt(row, 11);
            String rentStatus = (String)table.getValueAt(row, 4);
            if (isSelected) {
                this.setBackground(new Color(90, 168, 204));
            } else if ("ON RENT".equals(rentStatus) && !isContractExpired) {
                this.setBackground(new Color(212, 237, 218, 255));
            } else if (isContractExpired) {
                this.setBackground(new Color(248, 215, 218, 255));
            } else {
                this.setBackground(table.getBackground());
            }
            switch (column) {
                case 1: {
                    this.setHorizontalAlignment(0);
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    this.setHorizontalAlignment(4);
                    break;
                }
                default: {
                    this.setHorizontalAlignment(2);
                }
            }
            return comp;
        }
    }
}

