/*
 * Decompiled with CFR 0.152.
 */
package com.arun.bhardwaj.view.settings;

import com.arun.bhardwaj.controller.settings.SettingController;
import com.arun.bhardwaj.factory.UIFactory;
import com.arun.bhardwaj.utility.AppUtility;
import com.arun.bhardwaj.view.settings.ManageTeamView;
import com.arun.bhardwaj.view.settings.UserDetailsView;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.Objects;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class SettingsView
extends JPanel {
    private final JSplitPane splitPane = new JSplitPane(1, true);
    private final JPanel leftPanel;
    private final JPanel rightPanel;
    private final JButton userDetails;
    private final JButton subscriptionDetails;
    private final JPanel subscriptionPanel;
    private final CardLayout cardLayout;
    private final UserDetailsView userDetailsView;
    private final ManageTeamView manageTeamView;

    public SettingsView() {
        this.splitPane.setDividerLocation(200);
        this.splitPane.setOneTouchExpandable(false);
        this.leftPanel = UIFactory.createGradientPanel();
        AppUtility.addBorderToPanel("Options", this.leftPanel);
        this.userDetails = new JButton("User Details", new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/user.png"))));
        this.subscriptionDetails = new JButton("Subscription Details", new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/pictures/subscription.png"))));
        this.userDetails.setPreferredSize(new Dimension(180, 50));
        this.subscriptionDetails.setPreferredSize(new Dimension(180, 50));
        this.rightPanel = new JPanel();
        this.subscriptionPanel = new JPanel();
        this.cardLayout = new CardLayout();
        this.userDetailsView = new UserDetailsView();
        this.manageTeamView = new ManageTeamView();
        this.setLayout();
        new SettingController(this);
    }

    private void setLayout() {
        this.setLayout(new BorderLayout());
        this.add(this.splitPane);
        this.splitPane.setLeftComponent(this.leftPanel);
        this.leftPanel.setLayout(new FlowLayout(3, 2, 2));
        this.leftPanel.add(this.userDetails);
        this.splitPane.setRightComponent(this.rightPanel);
        this.rightPanel.setLayout(this.cardLayout);
        this.rightPanel.add("user", this.userDetailsView);
        this.rightPanel.add("team", this.manageTeamView);
        this.rightPanel.add("subscription", this.subscriptionPanel);
    }

    public JButton getUserDetails() {
        return this.userDetails;
    }

    public JButton getSubscriptionDetails() {
        return this.subscriptionDetails;
    }

    public CardLayout getCardLayout() {
        return this.cardLayout;
    }

    public JPanel getRightPanel() {
        return this.rightPanel;
    }

    public UserDetailsView getUserDetailsView() {
        return this.userDetailsView;
    }
}

